/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithExpression;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public final class InstanceOfExpr
extends Expression
implements NodeWithType<InstanceOfExpr, ReferenceType<?>>,
NodeWithExpression<InstanceOfExpr> {
    private Expression expression;
    private ReferenceType<?> type;

    public InstanceOfExpr() {
        this(null, new NameExpr(), new ClassOrInterfaceType());
    }

    @AllFieldsConstructor
    public InstanceOfExpr(Expression expression, ReferenceType<?> type) {
        this(null, expression, type);
    }

    public InstanceOfExpr(Range range, Expression expression, ReferenceType<?> type) {
        super(range);
        this.setExpression(expression);
        this.setType(type);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public ReferenceType<?> getType() {
        return this.type;
    }

    @Override
    public InstanceOfExpr setExpression(Expression expression) {
        Utils.assertNotNull(expression);
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expression);
        if (this.expression != null) {
            this.expression.setParentNode(null);
        }
        this.expression = expression;
        this.setAsParentNodeOf(expression);
        return this;
    }

    @Override
    public InstanceOfExpr setType(ReferenceType<?> type) {
        Utils.assertNotNull(type);
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        if (this.type != null) {
            this.type.setParentNode(null);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
        return this;
    }
}

