/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class ArrayCreationExpr
extends Expression {
    private NodeList<ArrayCreationLevel> levels;
    private Type elementType;
    private ArrayInitializerExpr initializer;

    public ArrayCreationExpr() {
        this(null, new ClassOrInterfaceType(), new NodeList<ArrayCreationLevel>(), new ArrayInitializerExpr());
    }

    @AllFieldsConstructor
    public ArrayCreationExpr(Type elementType, NodeList<ArrayCreationLevel> levels, ArrayInitializerExpr initializer) {
        this(null, elementType, levels, initializer);
    }

    public ArrayCreationExpr(Type elementType) {
        this(null, elementType, new NodeList<ArrayCreationLevel>(), new ArrayInitializerExpr());
    }

    public ArrayCreationExpr(Range range, Type elementType) {
        this(range, elementType, new NodeList<ArrayCreationLevel>(), new ArrayInitializerExpr());
    }

    public ArrayCreationExpr(Range range, Type elementType, NodeList<ArrayCreationLevel> levels, ArrayInitializerExpr initializer) {
        super(range);
        this.setLevels(levels);
        this.setElementType(elementType);
        this.setInitializer(initializer);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<ArrayInitializerExpr> getInitializer() {
        return Optional.ofNullable(this.initializer);
    }

    public Type getElementType() {
        return this.elementType;
    }

    public ArrayCreationExpr setInitializer(ArrayInitializerExpr initializer) {
        this.notifyPropertyChange(ObservableProperty.INITIALIZER, this.initializer, initializer);
        if (this.initializer != null) {
            this.initializer.setParentNode(null);
        }
        this.initializer = initializer;
        this.setAsParentNodeOf(initializer);
        return this;
    }

    public ArrayCreationExpr setElementType(Type elementType) {
        Utils.assertNotNull(elementType);
        this.notifyPropertyChange(ObservableProperty.ELEMENT_TYPE, this.elementType, elementType);
        if (this.elementType != null) {
            this.elementType.setParentNode(null);
        }
        this.elementType = elementType;
        this.setAsParentNodeOf(elementType);
        return this;
    }

    public NodeList<ArrayCreationLevel> getLevels() {
        return this.levels;
    }

    public ArrayCreationExpr setLevels(NodeList<ArrayCreationLevel> levels) {
        Utils.assertNotNull(levels);
        this.notifyPropertyChange(ObservableProperty.LEVELS, this.levels, levels);
        if (this.levels != null) {
            this.levels.setParentNode(null);
        }
        this.levels = levels;
        this.setAsParentNodeOf(levels);
        return this;
    }

    public Type createdType() {
        Type result = this.elementType;
        for (int i = 0; i < this.levels.size(); ++i) {
            result = new ArrayType(result, new NodeList<AnnotationExpr>());
        }
        return result;
    }

    public ArrayCreationExpr setElementType(Class<?> typeClass) {
        this.tryAddImportToParentCompilationUnit(typeClass);
        return this.setElementType(new ClassOrInterfaceType(typeClass.getSimpleName()));
    }

    public ArrayCreationExpr setElementType(String type) {
        ClassOrInterfaceType classOrInterfaceType = new ClassOrInterfaceType(type);
        return this.setElementType(classOrInterfaceType);
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getLevels());
    }
}

