/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.javadoc.description;

import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.utils.Utils;

public class JavadocInlineTag
implements JavadocDescriptionElement {
    private Type type;
    private String content;

    public static JavadocDescriptionElement fromText(String text) {
        if (!text.startsWith("{@")) {
            throw new IllegalArgumentException(String.format("Expected to start with '{@'. Text '%s'", text));
        }
        if (!text.endsWith("}")) {
            throw new IllegalArgumentException(String.format("Expected to end with '}'. Text '%s'", text));
        }
        text = text.substring(2, text.length() - 1);
        String tagName = Utils.nextWord(text);
        Type type = Type.fromName(tagName);
        String content = text.substring(tagName.length());
        return new JavadocInlineTag(type, content);
    }

    public JavadocInlineTag(Type type, String content) {
        this.type = type;
        this.content = content;
    }

    @Override
    public String toText() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavadocInlineTag that = (JavadocInlineTag)o;
        if (this.type != that.type) {
            return false;
        }
        return this.content.equals(that.content);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }

    public String toString() {
        return "JavadocInlineTag{type=" + (Object)((Object)this.type) + ", content='" + this.content + '\'' + '}';
    }

    public static enum Type {
        CODE,
        DOC_ROOT,
        INHERIT_DOC,
        LINK,
        LINKPLAIN,
        LITERAL,
        VALUE,
        UNKNOWN;

        private String keyword = Utils.toCamelCase(this.name());

        static Type fromName(String tagName) {
            for (Type t : Type.values()) {
                if (!t.keyword.equals(tagName)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

