/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithImplements;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public final class EnumDeclaration
extends TypeDeclaration<EnumDeclaration>
implements NodeWithImplements<EnumDeclaration> {
    private NodeList<ClassOrInterfaceType> implementedTypes;
    private NodeList<EnumConstantDeclaration> entries;

    public EnumDeclaration() {
        this(null, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new SimpleName(), new NodeList<ClassOrInterfaceType>(), new NodeList<EnumConstantDeclaration>(), new NodeList());
    }

    public EnumDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), new SimpleName(name), new NodeList<ClassOrInterfaceType>(), new NodeList<EnumConstantDeclaration>(), new NodeList());
    }

    public EnumDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<EnumConstantDeclaration> entries, NodeList<BodyDeclaration<?>> members) {
        this(null, modifiers, annotations, name, implementedTypes, entries, members);
    }

    public EnumDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<EnumConstantDeclaration> entries, NodeList<BodyDeclaration<?>> members) {
        super(range, annotations, modifiers, name, members);
        this.setImplementedTypes((NodeList)implementedTypes);
        this.setEntries(entries);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public NodeList<EnumConstantDeclaration> getEntries() {
        return this.entries;
    }

    public EnumConstantDeclaration getEntry(int i) {
        return (EnumConstantDeclaration)this.getEntries().get(i);
    }

    public EnumDeclaration setEntry(int i, EnumConstantDeclaration element) {
        this.getEntries().set(i, element);
        return this;
    }

    public EnumDeclaration addEntry(EnumConstantDeclaration element) {
        this.getEntries().add(element);
        return this;
    }

    @Override
    public NodeList<ClassOrInterfaceType> getImplementedTypes() {
        return this.implementedTypes;
    }

    public EnumDeclaration setEntries(NodeList<EnumConstantDeclaration> entries) {
        this.notifyPropertyChange(ObservableProperty.ENTRIES, this.entries, entries);
        this.entries = Utils.assertNotNull(entries);
        this.setAsParentNodeOf(this.entries);
        return this;
    }

    @Override
    public EnumDeclaration setImplementedTypes(NodeList<ClassOrInterfaceType> implementsList) {
        this.notifyPropertyChange(ObservableProperty.IMPLEMENTED_TYPES, this.implementedTypes, implementsList);
        this.implementedTypes = Utils.assertNotNull(implementsList);
        this.setAsParentNodeOf(this.implementedTypes);
        return this;
    }

    public EnumConstantDeclaration addEnumConstant(String name) {
        Utils.assertNonEmpty(name);
        EnumConstantDeclaration enumConstant = new EnumConstantDeclaration(name);
        this.getEntries().add(enumConstant);
        enumConstant.setParentNode(this);
        return enumConstant;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        LinkedList res = new LinkedList(super.getNodeLists());
        res.add(this.implementedTypes);
        res.add(this.entries);
        return res;
    }
}

