/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.Optional;

public final class AnnotationMemberDeclaration
extends BodyDeclaration<AnnotationMemberDeclaration>
implements NodeWithJavadoc<AnnotationMemberDeclaration>,
NodeWithSimpleName<AnnotationMemberDeclaration>,
NodeWithType<AnnotationMemberDeclaration, Type>,
NodeWithModifiers<AnnotationMemberDeclaration> {
    private EnumSet<Modifier> modifiers;
    private Type type;
    private SimpleName name;
    private Expression defaultValue;

    public AnnotationMemberDeclaration() {
        this(null, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new ClassOrInterfaceType(), new SimpleName(), null);
    }

    public AnnotationMemberDeclaration(EnumSet<Modifier> modifiers, Type type, String name, Expression defaultValue) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), type, new SimpleName(name), defaultValue);
    }

    public AnnotationMemberDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, Type type, SimpleName name, Expression defaultValue) {
        this(null, modifiers, annotations, type, name, defaultValue);
    }

    public AnnotationMemberDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, Type type, SimpleName name, Expression defaultValue) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setType(type);
        this.setName(name);
        this.setDefaultValue(defaultValue);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public Expression removeDefaultValue() {
        Expression res = this.defaultValue;
        if (res != null) {
            this.setDefaultValue(null);
        }
        return res;
    }

    public AnnotationMemberDeclaration setDefaultValue(Expression defaultValue) {
        this.notifyPropertyChange(ObservableProperty.DEFAULT_VALUE, this.defaultValue, defaultValue);
        if (this.defaultValue != null) {
            this.defaultValue.setParentNode(null);
        }
        this.defaultValue = defaultValue;
        this.setAsParentNodeOf(defaultValue);
        return this;
    }

    @Override
    public AnnotationMemberDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = Utils.assertNotNull(modifiers);
        return this;
    }

    @Override
    public AnnotationMemberDeclaration setName(SimpleName name) {
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        this.name = Utils.assertNotNull(name);
        this.setAsParentNodeOf(name);
        return this;
    }

    @Override
    public AnnotationMemberDeclaration setType(Type type) {
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = Utils.assertNotNull(type);
        this.setAsParentNodeOf(type);
        return this;
    }

    @Override
    public JavadocComment getJavadocComment() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }
}

