/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Problem;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ParseResult<T> {
    private final T result;
    private final List<Problem> problems;
    private final List<JavaToken> tokens;
    private final CommentsCollection commentsCollection;

    ParseResult(T result, List<Problem> problems, List<JavaToken> tokens, CommentsCollection commentsCollection) {
        this.commentsCollection = commentsCollection;
        this.result = result;
        this.problems = problems;
        this.tokens = tokens;
    }

    ParseResult(Throwable throwable) {
        this(null, Collections.singletonList(new Problem(ParseResult.createMessage(throwable), null, throwable)), null, null);
    }

    private static String createMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            return throwable.getClass().getSimpleName();
        }
        return message;
    }

    public boolean isSuccessful() {
        return this.problems.isEmpty() && this.result != null;
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public Problem getProblem(int i) {
        return this.getProblems().get(i);
    }

    public Optional<List<JavaToken>> getTokens() {
        return Optional.ofNullable(this.tokens);
    }

    public Optional<CommentsCollection> getCommentsCollection() {
        return Optional.ofNullable(this.commentsCollection);
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public String toString() {
        if (this.isSuccessful()) {
            return "Parsing successful";
        }
        StringBuilder message = new StringBuilder("Parsing failed:").append(Utils.EOL);
        for (Problem problem : this.problems) {
            message.append(problem.toString()).append(Utils.EOL);
        }
        return message.toString();
    }
}

