/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithThrownExceptions;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public final class ConstructorDeclaration
extends BodyDeclaration<ConstructorDeclaration>
implements NodeWithJavadoc<ConstructorDeclaration>,
NodeWithDeclaration,
NodeWithSimpleName<ConstructorDeclaration>,
NodeWithModifiers<ConstructorDeclaration>,
NodeWithParameters<ConstructorDeclaration>,
NodeWithThrownExceptions<ConstructorDeclaration>,
NodeWithBlockStmt<ConstructorDeclaration>,
NodeWithTypeParameters<ConstructorDeclaration> {
    private EnumSet<Modifier> modifiers;
    private NodeList<TypeParameter> typeParameters;
    private SimpleName name;
    private NodeList<Parameter> parameters;
    private NodeList<ReferenceType> thrownExceptions;
    private BlockStmt body;

    public ConstructorDeclaration() {
        this(null, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), new SimpleName(), new NodeList<Parameter>(), new NodeList<ReferenceType>(), new BlockStmt());
    }

    public ConstructorDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), new SimpleName(name), new NodeList<Parameter>(), new NodeList<ReferenceType>(), new BlockStmt());
    }

    public ConstructorDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt block) {
        this(null, modifiers, annotations, typeParameters, name, parameters, thrownExceptions, block);
    }

    public ConstructorDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt block) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters((NodeList)typeParameters);
        this.setName(name);
        this.setParameters((NodeList)parameters);
        this.setThrownExceptions((NodeList)thrownExceptions);
        this.setBody(block);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public NodeList<ReferenceType> getThrownExceptions() {
        return this.thrownExceptions;
    }

    @Override
    public NodeList<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public ConstructorDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = Utils.assertNotNull(modifiers);
        return this;
    }

    @Override
    public ConstructorDeclaration setName(SimpleName name) {
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        this.name = Utils.assertNotNull(name);
        this.setAsParentNodeOf(this.name);
        return this;
    }

    @Override
    public ConstructorDeclaration setParameters(NodeList<Parameter> parameters) {
        this.notifyPropertyChange(ObservableProperty.PARAMETERS, this.parameters, parameters);
        this.parameters = Utils.assertNotNull(parameters);
        this.setAsParentNodeOf(this.parameters);
        return this;
    }

    @Override
    public ConstructorDeclaration setThrownExceptions(NodeList<ReferenceType> thrownExceptions) {
        this.notifyPropertyChange(ObservableProperty.THROWN_TYPES, this.thrownExceptions, thrownExceptions);
        this.thrownExceptions = Utils.assertNotNull(thrownExceptions);
        this.setAsParentNodeOf(this.thrownExceptions);
        return this;
    }

    @Override
    public ConstructorDeclaration setTypeParameters(NodeList<TypeParameter> typeParameters) {
        this.notifyPropertyChange(ObservableProperty.TYPE_PARAMETERS, this.typeParameters, typeParameters);
        this.typeParameters = Utils.assertNotNull(typeParameters);
        this.setAsParentNodeOf(this.typeParameters);
        return this;
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuilder sb = new StringBuilder();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = Modifier.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.asString());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
        }
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toString(prettyPrinterNoCommentsConfiguration));
                continue;
            }
            sb.append(param.getType().toString(prettyPrinterNoCommentsConfiguration));
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType thr : this.getThrownExceptions()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toString(prettyPrinterNoCommentsConfiguration));
            }
        }
        return sb.toString();
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    @Override
    public BlockStmt getBody() {
        return this.body;
    }

    @Override
    public ConstructorDeclaration setBody(BlockStmt body) {
        this.body = Utils.assertNotNull(body);
        this.setAsParentNodeOf(body);
        return this;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        LinkedList res = new LinkedList(super.getNodeLists());
        res.add(this.typeParameters);
        res.add(this.parameters);
        res.add(this.thrownExceptions);
        return res;
    }
}

