/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class IfStmt
extends Statement {
    private Expression condition;
    private Statement thenStmt;
    private Statement elseStmt;

    public IfStmt() {
        this(Range.UNKNOWN, new BooleanLiteralExpr(), new EmptyStmt(), null);
    }

    public IfStmt(Expression condition, Statement thenStmt, Statement elseStmt) {
        this(Range.UNKNOWN, condition, thenStmt, elseStmt);
    }

    public IfStmt(Range range, Expression condition, Statement thenStmt, Statement elseStmt) {
        super(range);
        this.setCondition(condition);
        this.setThenStmt(thenStmt);
        this.setElseStmt(elseStmt);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Optional<Statement> getElseStmt() {
        return Optional.ofNullable(this.elseStmt);
    }

    public Statement getThenStmt() {
        return this.thenStmt;
    }

    public IfStmt setCondition(Expression condition) {
        this.notifyPropertyChange(ObservableProperty.CONDITION, this.condition, condition);
        this.condition = Utils.assertNotNull(condition);
        this.setAsParentNodeOf(this.condition);
        return this;
    }

    public IfStmt setElseStmt(Statement elseStmt) {
        this.notifyPropertyChange(ObservableProperty.ELSE_STMT, this.elseStmt, elseStmt);
        this.elseStmt = elseStmt;
        this.setAsParentNodeOf(this.elseStmt);
        return this;
    }

    public IfStmt setThenStmt(Statement thenStmt) {
        this.notifyPropertyChange(ObservableProperty.THEN_STMT, this.thenStmt, thenStmt);
        this.thenStmt = Utils.assertNotNull(thenStmt);
        this.setAsParentNodeOf(this.thenStmt);
        return this;
    }
}

