/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.utils.PositionUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

class CommentsInserter {
    private final ParserConfiguration configuration;

    CommentsInserter(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    private void insertComments(CompilationUnit cu, TreeSet<Comment> comments) {
        if (comments.isEmpty()) {
            return;
        }
        List<Node> children = cu.getChildNodes();
        Comment firstComment = comments.iterator().next();
        if (cu.getPackage().isPresent() && (children.isEmpty() || PositionUtils.areInOrder(firstComment, cu.getPackage().get()))) {
            cu.setComment(firstComment);
            comments.remove(firstComment);
        }
    }

    /*
     * WARNING - void declaration
     */
    void insertComments(Node node, TreeSet<Comment> commentsToAttribute) {
        if (commentsToAttribute.isEmpty()) {
            return;
        }
        if (node instanceof CompilationUnit) {
            this.insertComments((CompilationUnit)node, commentsToAttribute);
        }
        List<Node> children = node.getChildNodes();
        for (Node node2 : children) {
            TreeSet<Node> commentsInsideChild = new TreeSet<Node>(Node.NODE_BY_BEGIN_POSITION);
            for (Comment c : commentsToAttribute) {
                if (!PositionUtils.nodeContains(node2, c, this.configuration.doNotConsiderAnnotationsAsNodeStartForCodeAttribution)) continue;
                commentsInsideChild.add(c);
            }
            commentsToAttribute.removeAll(commentsInsideChild);
            this.insertComments(node2, commentsInsideChild);
        }
        LinkedList<Object> attributedComments = new LinkedList<Object>();
        for (Comment comment : commentsToAttribute) {
            if (!comment.isLineComment()) continue;
            for (Node child : children) {
                if (child.getEnd().line != comment.getBegin().line || !this.attributeLineCommentToNodeOrChild(child, comment.asLineComment())) continue;
                attributedComments.add(comment);
            }
        }
        Object var5_7 = null;
        attributedComments = new LinkedList();
        LinkedList<Node> childrenAndComments = new LinkedList<Node>();
        for (Node child : children) {
            childrenAndComments.add(child);
        }
        childrenAndComments.addAll(commentsToAttribute);
        PositionUtils.sortByBeginPosition(childrenAndComments, this.configuration.doNotConsiderAnnotationsAsNodeStartForCodeAttribution);
        for (Node thing : childrenAndComments) {
            void var5_8;
            if (thing instanceof Comment) {
                Comment comment = (Comment)thing;
                if (comment.isOrphan()) continue;
                Object var5_10 = null;
                continue;
            }
            if (var5_8 == null || thing.hasComment() || this.configuration.doNotAssignCommentsPrecedingEmptyLines && this.thereAreLinesBetween((Node)var5_8, thing)) continue;
            thing.setComment((Comment)var5_8);
            attributedComments.add(var5_8);
            Object var5_11 = null;
        }
        commentsToAttribute.removeAll(attributedComments);
        for (Comment c : commentsToAttribute) {
            if (!c.isOrphan()) continue;
            node.addOrphanComment(c);
        }
    }

    private boolean attributeLineCommentToNodeOrChild(Node node, LineComment lineComment) {
        if (node.getBegin().line == lineComment.getBegin().line && !node.hasComment()) {
            if (!(node instanceof Comment)) {
                node.setComment(lineComment);
            }
            return true;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        children.addAll(node.getChildNodes());
        PositionUtils.sortByBeginPosition(children);
        Collections.reverse(children);
        for (Node child : children) {
            if (!this.attributeLineCommentToNodeOrChild(child, lineComment)) continue;
            return true;
        }
        return false;
    }

    private boolean thereAreLinesBetween(Node a, Node b) {
        if (!PositionUtils.areInOrder(a, b)) {
            return this.thereAreLinesBetween(b, a);
        }
        int endOfA = a.getEnd().line;
        return b.getBegin().line > endOfA + 1;
    }
}

