/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.imports;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.imports.SingleStaticImportDeclaration;
import com.github.javaparser.ast.imports.SingleTypeImportDeclaration;
import com.github.javaparser.ast.imports.StaticImportOnDemandDeclaration;
import com.github.javaparser.ast.imports.TypeImportOnDemandDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.utils.Utils;

public abstract class ImportDeclaration
extends Node {
    public ImportDeclaration() {
        this(Range.UNKNOWN);
    }

    public ImportDeclaration(Range range) {
        super(range);
    }

    public static ImportDeclaration create(Range range, NameExpr name, boolean isStatic, boolean isAsterisk) {
        Utils.assertNotNull(range);
        Utils.assertNotNull(name);
        if (isStatic) {
            if (isAsterisk) {
                return new StaticImportOnDemandDeclaration(range, new ClassOrInterfaceType(name.getQualifiedName()));
            }
            if (!(name instanceof QualifiedNameExpr)) {
                throw new IllegalArgumentException("import static name has only one identifier.");
            }
            String staticMember = name.getName();
            QualifiedNameExpr qualifiedName = (QualifiedNameExpr)name;
            String className = qualifiedName.getQualifier().getQualifiedName();
            return new SingleStaticImportDeclaration(range, new ClassOrInterfaceType(className), staticMember);
        }
        if (isAsterisk) {
            return new TypeImportOnDemandDeclaration(range, name);
        }
        return new SingleTypeImportDeclaration(range, new ClassOrInterfaceType(name.getQualifiedName()));
    }
}

