/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.HasParentNode;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class NodeList<N extends Node>
implements Iterable<N>,
HasParentNode<NodeList<N>>,
Visitable {
    private List<N> innerList = new ArrayList<N>(0);
    private Node parentNode;

    public NodeList() {
        this(null);
    }

    public NodeList(Node parent) {
        this.setParentNode(parent);
    }

    public NodeList<N> add(N node) {
        this.own(node);
        this.innerList.add(node);
        return this;
    }

    private void own(N node) {
        if (node == null) {
            return;
        }
        this.setAsParentNodeOf((Node)node);
    }

    public boolean remove(Node node) {
        boolean remove = this.innerList.remove(node);
        node.setParentNode(null);
        return remove;
    }

    public static <X extends Node> NodeList<X> nodeList(X ... nodes) {
        NodeList<X> nodeList = new NodeList<X>();
        for (X node : nodes) {
            nodeList.add(node);
        }
        return nodeList;
    }

    public static <X extends Node> NodeList<X> nodeList(Collection<X> nodes) {
        NodeList<Node> nodeList = new NodeList<Node>();
        for (Node node : nodes) {
            nodeList.add(node);
        }
        return nodeList;
    }

    public static <X extends Node> NodeList<X> nodeList(NodeList<X> nodes) {
        NodeList<Node> nodeList = new NodeList<Node>();
        for (Node node : nodes) {
            nodeList.add(node);
        }
        return nodeList;
    }

    public boolean contains(N node) {
        return this.innerList.contains(node);
    }

    public Stream<N> stream() {
        return this.innerList.stream();
    }

    public int size() {
        return this.innerList.size();
    }

    public N get(int i) {
        return (N)((Node)this.innerList.get(i));
    }

    @Override
    public Iterator<N> iterator() {
        return this.innerList.iterator();
    }

    public NodeList<N> set(int index, N element) {
        this.setAsParentNodeOf((Node)element);
        this.innerList.set(index, element);
        return this;
    }

    public NodeList<N> remove(int index) {
        this.innerList.remove(index);
        return this;
    }

    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    public void sort(Comparator<? super N> comparator) {
        Collections.sort(this.innerList, comparator);
    }

    public void addAll(NodeList<N> otherList) {
        for (Node node : otherList) {
            this.add(node);
        }
    }

    public NodeList<N> add(int index, N node) {
        this.own(node);
        this.innerList.add(index, node);
        return this;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public NodeList<N> setParentNode(Node parentNode) {
        this.parentNode = parentNode;
        this.setAsParentNodeOf(this.innerList);
        return this;
    }

    @Override
    public Node getParentNodeForChildren() {
        return this.parentNode;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }
}

