/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public class NameExpr
extends Expression
implements NodeWithName<NameExpr> {
    private String name;

    public NameExpr() {
        this(Range.UNKNOWN, "empty");
    }

    public NameExpr(String name) {
        this(Range.UNKNOWN, name);
    }

    public NameExpr(Range range, String name) {
        super(range);
        this.setName(name);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public NameExpr setName(String name) {
        this.name = Utils.assertNotNull(name);
        return this;
    }

    public static NameExpr name(String qualifiedName) {
        String[] split = qualifiedName.split("\\.");
        NameExpr ret = new NameExpr(split[0]);
        for (int i = 1; i < split.length; ++i) {
            ret = new QualifiedNameExpr(ret, split[i]);
        }
        return ret;
    }

    public String getQualifiedName() {
        return this.name;
    }
}

