/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.Optional;

public abstract class TypeDeclaration<T>
extends BodyDeclaration<T>
implements NodeWithName<T>,
NodeWithJavaDoc<T>,
NodeWithModifiers<T>,
NodeWithMembers<T> {
    private NameExpr name;
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private NodeList<BodyDeclaration<?>> members;

    public TypeDeclaration() {
        this(Range.UNKNOWN, new NodeList<AnnotationExpr>(), EnumSet.noneOf(Modifier.class), new NameExpr(), new NodeList());
    }

    public TypeDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(Range.UNKNOWN, new NodeList<AnnotationExpr>(), modifiers, NameExpr.name(name), new NodeList());
    }

    public TypeDeclaration(NodeList<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, NameExpr name, NodeList<BodyDeclaration<?>> members) {
        this(Range.UNKNOWN, annotations, modifiers, name, members);
    }

    public TypeDeclaration(Range range, NodeList<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, NameExpr name, NodeList<BodyDeclaration<?>> members) {
        super(range, annotations);
        this.setNameExpr(name);
        this.setModifiers(modifiers);
        this.setMembers(members);
    }

    public TypeDeclaration<T> addMember(BodyDeclaration<?> decl) {
        NodeList<BodyDeclaration<?>> members = this.getMembers();
        members.add(decl);
        return this;
    }

    @Override
    public NodeList<BodyDeclaration<?>> getMembers() {
        return this.members;
    }

    @Override
    public final EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public final String getName() {
        return this.name.getName();
    }

    @Override
    public T setMembers(NodeList<BodyDeclaration<?>> members) {
        this.members = Utils.assertNotNull(members);
        this.setAsParentNodeOf(this.members);
        return (T)this;
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = Utils.assertNotNull(modifiers);
        return (T)this;
    }

    @Override
    public T setName(String name) {
        this.setNameExpr(new NameExpr(Utils.assertNotNull(name)));
        return (T)this;
    }

    public T setNameExpr(NameExpr nameExpr) {
        this.name = Utils.assertNotNull(nameExpr);
        this.setAsParentNodeOf(this.name);
        return (T)this;
    }

    public final NameExpr getNameExpr() {
        return this.name;
    }

    @Override
    public Optional<JavadocComment> getJavaDoc() {
        if (this.getComment().isPresent() && this.getComment().get() instanceof JavadocComment) {
            return this.getComment();
        }
        return Utils.none();
    }
}

