/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Problem;
import com.github.javaparser.Token;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ParseResult<T> {
    private final Optional<T> result;
    private final List<Problem> problems;
    private final Optional<List<Token>> tokens;
    private final Optional<CommentsCollection> commentsCollection;

    ParseResult(Optional<T> result, List<Problem> problems, Optional<List<Token>> tokens, Optional<CommentsCollection> commentsCollection) {
        this.commentsCollection = Utils.assertNotNull(commentsCollection);
        this.result = Utils.assertNotNull(result);
        this.problems = Utils.assertNotNull(problems);
        this.tokens = Utils.assertNotNull(tokens);
    }

    ParseResult(Throwable throwable) {
        this(Optional.empty(), Collections.singletonList(new Problem(ParseResult.createMessage(throwable), Optional.empty(), Optional.of(throwable))), Optional.empty(), Optional.empty());
    }

    private static String createMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            return throwable.getClass().getSimpleName();
        }
        return message;
    }

    public boolean isSuccessful() {
        return this.problems.isEmpty() && this.result.isPresent();
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public Optional<List<Token>> getTokens() {
        return this.tokens;
    }

    public Optional<CommentsCollection> getCommentsCollection() {
        return this.commentsCollection;
    }

    public Optional<T> getResult() {
        return this.result;
    }

    public String toString() {
        if (this.isSuccessful()) {
            return "Parsing successful";
        }
        StringBuilder message = new StringBuilder("Parsing failed:").append(Utils.EOL);
        for (Problem problem : this.problems) {
            message.append(problem.toString()).append(Utils.EOL);
        }
        return message.toString();
    }
}

