/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ASTParser;
import com.github.javaparser.CommentsInserter;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Provider;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.imports.ImportDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;

public final class JavaParser {
    private final CommentsInserter commentsInserter;
    private ASTParser astParser = null;

    public JavaParser() {
        this(new ParserConfiguration());
    }

    public JavaParser(ParserConfiguration configuration) {
        this.commentsInserter = new CommentsInserter(configuration);
    }

    private ASTParser getParserForProvider(Provider provider) {
        if (this.astParser == null) {
            this.astParser = new ASTParser(provider);
        } else {
            this.astParser.ReInit(provider);
        }
        return this.astParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N extends Node> ParseResult<N> parse(ParseStart<N> start, Provider provider) {
        Utils.assertNotNull(start);
        Utils.assertNotNull(provider);
        try {
            ASTParser parser = this.getParserForProvider(provider);
            Node resultNode = (Node)start.parse(parser);
            CommentsCollection comments = this.astParser.getCommentsCollection();
            this.commentsInserter.insertComments(resultNode, comments.copy().getComments());
            ParseResult<Node> parseResult = new ParseResult<Node>(Optional.of(resultNode), parser.problems, Optional.of(this.astParser.getTokens()), Optional.of(this.astParser.getCommentsCollection()));
            return parseResult;
        }
        catch (Exception e) {
            ParseResult parseResult = new ParseResult(e);
            return parseResult;
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static CompilationUnit parse(InputStream in, Charset encoding) {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(in, encoding));
    }

    public static CompilationUnit parse(InputStream in) {
        return JavaParser.parse(in, Providers.UTF8);
    }

    public static CompilationUnit parse(File file, Charset encoding) throws FileNotFoundException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(file, encoding));
    }

    public static CompilationUnit parse(File file) throws FileNotFoundException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(file));
    }

    public static CompilationUnit parse(Path path, Charset encoding) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(path, encoding));
    }

    public static CompilationUnit parse(Path path) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(path));
    }

    public static CompilationUnit parse(Reader reader) {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(reader));
    }

    public static CompilationUnit parse(String code) {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(code));
    }

    public static BlockStmt parseBlock(String blockStatement) {
        return JavaParser.simplifiedParse(ParseStart.BLOCK, Providers.provider(blockStatement));
    }

    public static Statement parseStatement(String statement) {
        return JavaParser.simplifiedParse(ParseStart.STATEMENT, Providers.provider(statement));
    }

    private static <T extends Node> T simplifiedParse(ParseStart<T> context, Provider provider) {
        ParseResult<T> result = new JavaParser(new ParserConfiguration()).parse(context, provider);
        if (result.isSuccessful()) {
            return (T)((Node)result.getResult().get());
        }
        throw new ParseProblemException(result.getProblems());
    }

    public static ImportDeclaration parseImport(String importDeclaration) {
        return JavaParser.simplifiedParse(ParseStart.IMPORT_DECLARATION, Providers.provider(importDeclaration));
    }

    public static <T extends Expression> T parseExpression(String expression) {
        return (T)JavaParser.simplifiedParse(ParseStart.EXPRESSION, Providers.provider(expression));
    }

    public static AnnotationExpr parseAnnotation(String annotation) {
        return JavaParser.simplifiedParse(ParseStart.ANNOTATION, Providers.provider(annotation));
    }

    public static BodyDeclaration<?> parseAnnotationBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseStart.ANNOTATION_BODY, Providers.provider(body));
    }

    public static BodyDeclaration<?> parseClassBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseStart.CLASS_BODY, Providers.provider(body));
    }

    public static BodyDeclaration parseInterfaceBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseStart.INTERFACE_BODY, Providers.provider(body));
    }
}

