/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.List;

public final class TryStmt
extends Statement {
    private List<VariableDeclarationExpr> resources;
    private BlockStmt tryBlock;
    private List<CatchClause> catchs;
    private BlockStmt finallyBlock;

    public TryStmt() {
    }

    public TryStmt(BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        this.setTryBlock(tryBlock);
        this.setCatchs(catchs);
        this.setFinallyBlock(finallyBlock);
    }

    public TryStmt(Range range, List<VariableDeclarationExpr> resources, BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        super(range);
        this.setResources(resources);
        this.setTryBlock(tryBlock);
        this.setCatchs(catchs);
        this.setFinallyBlock(finallyBlock);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<CatchClause> getCatchs() {
        this.catchs = Utils.ensureNotNull(this.catchs);
        return this.catchs;
    }

    public BlockStmt getFinallyBlock() {
        return this.finallyBlock;
    }

    public BlockStmt getTryBlock() {
        return this.tryBlock;
    }

    public List<VariableDeclarationExpr> getResources() {
        this.resources = Utils.ensureNotNull(this.resources);
        return this.resources;
    }

    public TryStmt setCatchs(List<CatchClause> catchs) {
        this.catchs = catchs;
        this.setAsParentNodeOf(this.catchs);
        return this;
    }

    public TryStmt setFinallyBlock(BlockStmt finallyBlock) {
        this.finallyBlock = finallyBlock;
        this.setAsParentNodeOf(this.finallyBlock);
        return this;
    }

    public TryStmt setTryBlock(BlockStmt tryBlock) {
        this.tryBlock = tryBlock;
        this.setAsParentNodeOf(this.tryBlock);
        return this;
    }

    public TryStmt setResources(List<VariableDeclarationExpr> resources) {
        this.resources = resources;
        this.setAsParentNodeOf(this.resources);
        return this;
    }
}

