/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class PositionUtils {
    private PositionUtils() {
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes, boolean ignoringAnnotations) {
        Collections.sort(nodes, (o1, o2) -> PositionUtils.compare(o1, o2, ignoringAnnotations));
    }

    public static boolean areInOrder(Node a, Node b) {
        return PositionUtils.areInOrder(a, b, false);
    }

    public static boolean areInOrder(Node a, Node b, boolean ignoringAnnotations) {
        return PositionUtils.compare(a, b, ignoringAnnotations) <= 0;
    }

    private static int compare(Node a, Node b, boolean ignoringAnnotations) {
        if (ignoringAnnotations) {
            int signLine = Integer.signum(PositionUtils.beginLineWithoutConsideringAnnotation(a) - PositionUtils.beginLineWithoutConsideringAnnotation(b));
            if (signLine == 0) {
                return Integer.signum(PositionUtils.beginColumnWithoutConsideringAnnotation(a) - PositionUtils.beginColumnWithoutConsideringAnnotation(b));
            }
            return signLine;
        }
        int signLine = Integer.signum(a.getBegin().line - b.getBegin().line);
        if (signLine == 0) {
            return Integer.signum(a.getBegin().column - b.getBegin().column);
        }
        return signLine;
    }

    public static AnnotationExpr getLastAnnotation(Node node) {
        if (node instanceof NodeWithAnnotations) {
            LinkedList<AnnotationExpr> annotations = new LinkedList<AnnotationExpr>();
            annotations.addAll(((NodeWithAnnotations)((Object)node)).getAnnotations());
            if (annotations.isEmpty()) {
                return null;
            }
            PositionUtils.sortByBeginPosition(annotations);
            return (AnnotationExpr)annotations.get(annotations.size() - 1);
        }
        return null;
    }

    private static int beginLineWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations((Node)node).getBegin().line;
    }

    private static int beginColumnWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations((Node)node).getBegin().column;
    }

    private static Node beginNodeWithoutConsideringAnnotations(Node node) {
        if (node instanceof MethodDeclaration || node instanceof FieldDeclaration) {
            NodeWithElementType casted = (NodeWithElementType)((Object)node);
            return casted.getElementType();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration casted = (ClassOrInterfaceDeclaration)node;
            return casted.getNameExpr();
        }
        return node;
    }

    public static boolean nodeContains(Node container, Node contained, boolean ignoringAnnotations) {
        if (!ignoringAnnotations || PositionUtils.getLastAnnotation(container) == null) {
            return container.contains(contained);
        }
        if (!container.contains(contained)) {
            return false;
        }
        if (container instanceof NodeWithAnnotations) {
            int bl = PositionUtils.beginLineWithoutConsideringAnnotation(container);
            int bc = PositionUtils.beginColumnWithoutConsideringAnnotation(container);
            if (bl > contained.getBegin().line) {
                return false;
            }
            if (bl == contained.getBegin().line && bc > contained.getBegin().column) {
                return false;
            }
            if (container.getEnd().line < contained.getEnd().line) {
                return false;
            }
            return container.getEnd().line != contained.getEnd().line || container.getEnd().column >= contained.getEnd().column;
        }
        return true;
    }
}

