/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public final class ObjectCreationExpr
extends Expression
implements NodeWithTypeArguments<ObjectCreationExpr>,
NodeWithType<ObjectCreationExpr> {
    private Expression scope;
    private ClassOrInterfaceType type;
    private List<Type<?>> typeArguments;
    private List<Expression> args;
    private List<BodyDeclaration<?>> anonymousClassBody;

    public ObjectCreationExpr() {
    }

    public ObjectCreationExpr(Expression scope, ClassOrInterfaceType type, List<Expression> args) {
        this.setScope(scope);
        this.setType((Type)type);
        this.setArgs(args);
    }

    public ObjectCreationExpr(Range range, Expression scope, ClassOrInterfaceType type, List<Type<?>> typeArguments, List<Expression> args, List<BodyDeclaration<?>> anonymousBody) {
        super(range);
        this.setScope(scope);
        this.setType((Type)type);
        this.setTypeArguments((List)typeArguments);
        this.setArgs(args);
        this.setAnonymousClassBody(anonymousBody);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<BodyDeclaration<?>> getAnonymousClassBody() {
        return this.anonymousClassBody;
    }

    public void addAnonymousClassBody(BodyDeclaration<?> body) {
        if (this.anonymousClassBody == null) {
            this.anonymousClassBody = new ArrayList();
        }
        this.anonymousClassBody.add(body);
        body.setParentNode(this);
    }

    public List<Expression> getArgs() {
        this.args = Utils.ensureNotNull(this.args);
        return this.args;
    }

    public Expression getScope() {
        return this.scope;
    }

    public ClassOrInterfaceType getType() {
        return this.type;
    }

    public ObjectCreationExpr setAnonymousClassBody(List<BodyDeclaration<?>> anonymousClassBody) {
        this.anonymousClassBody = anonymousClassBody;
        this.setAsParentNodeOf(this.anonymousClassBody);
        return this;
    }

    public ObjectCreationExpr setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(this.args);
        return this;
    }

    public ObjectCreationExpr setScope(Expression scope) {
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public ObjectCreationExpr setType(Type<?> type) {
        if (!(type instanceof ClassOrInterfaceType)) {
            throw new RuntimeException("You can only add ClassOrInterfaceType to an ObjectCreationExpr");
        }
        this.type = (ClassOrInterfaceType)type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    @Override
    public List<Type<?>> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public ObjectCreationExpr setTypeArguments(List<Type<?>> types) {
        this.typeArguments = types;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

