/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.List;

public final class MethodCallExpr
extends Expression
implements NodeWithTypeArguments<MethodCallExpr> {
    private Expression scope;
    private List<Type<?>> typeArguments;
    private NameExpr name;
    private List<Expression> args;

    public MethodCallExpr() {
    }

    public MethodCallExpr(Expression scope, String name) {
        this.setScope(scope);
        this.setName(name);
    }

    public MethodCallExpr(Expression scope, String name, List<Expression> args) {
        this.setScope(scope);
        this.setName(name);
        this.setArgs(args);
    }

    public MethodCallExpr(Range range, Expression scope, List<Type<?>> typeArguments, String name, List<Expression> args) {
        super(range);
        this.setScope(scope);
        this.setTypeArguments((List)typeArguments);
        this.setName(name);
        this.setArgs(args);
    }

    public MethodCallExpr addArgument(Expression arg) {
        this.getArgs().add(arg);
        arg.setParentNode(this);
        return this;
    }

    public void addArgument(String arg) {
        this.addArgument(new NameExpr(arg));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<Expression> getArgs() {
        this.args = Utils.ensureNotNull(this.args);
        return this.args;
    }

    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    public Expression getScope() {
        return this.scope;
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(this.args);
    }

    public MethodCallExpr setName(String name) {
        this.setNameExpr(new NameExpr(name));
        return this;
    }

    public MethodCallExpr setNameExpr(NameExpr name) {
        this.name = name;
        this.setAsParentNodeOf(this.name);
        return this;
    }

    public MethodCallExpr setScope(Expression scope) {
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public List<Type<?>> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public MethodCallExpr setTypeArguments(List<Type<?>> types) {
        this.typeArguments = types;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

