/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.nodeTypes.NodeWithThrowable;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.List;

public final class MethodDeclaration
extends BodyDeclaration<MethodDeclaration>
implements NodeWithJavaDoc<MethodDeclaration>,
NodeWithDeclaration,
NodeWithName<MethodDeclaration>,
NodeWithType<MethodDeclaration>,
NodeWithElementType<MethodDeclaration>,
NodeWithModifiers<MethodDeclaration>,
NodeWithParameters<MethodDeclaration>,
NodeWithThrowable<MethodDeclaration>,
NodeWithBlockStmt<MethodDeclaration> {
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private List<TypeParameter> typeParameters;
    private Type elementType;
    private NameExpr name;
    private List<Parameter> parameters;
    private List<ReferenceType> throws_;
    private BlockStmt body;
    private boolean isDefault = false;
    private List<ArrayBracketPair> arrayBracketPairsAfterType;
    private List<ArrayBracketPair> arrayBracketPairsAfterParameterList;

    public MethodDeclaration() {
    }

    public MethodDeclaration(EnumSet<Modifier> modifiers, Type elementType, String name) {
        this.setModifiers((EnumSet)modifiers);
        this.setElementType(elementType);
        this.setName(name);
    }

    public MethodDeclaration(EnumSet<Modifier> modifiers, Type elementType, String name, List<Parameter> parameters) {
        this.setModifiers((EnumSet)modifiers);
        this.setElementType(elementType);
        this.setName(name);
        this.setParameters((List)parameters);
    }

    public MethodDeclaration(EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type elementType, List<ArrayBracketPair> arrayBracketPairsAfterElementType, String name, List<Parameter> parameters, List<ArrayBracketPair> arrayBracketPairsAfterParameterList, List<ReferenceType> throws_, BlockStmt body) {
        super(annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters(typeParameters);
        this.setElementType(elementType);
        this.setName(name);
        this.setParameters((List)parameters);
        this.setArrayBracketPairsAfterElementType((List)arrayBracketPairsAfterElementType);
        this.setArrayBracketPairsAfterParameterList(arrayBracketPairsAfterParameterList);
        this.setThrows((List)throws_);
        this.setBody(body);
    }

    public MethodDeclaration(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type elementType, List<ArrayBracketPair> arrayBracketPairsAfterElementType, NameExpr nameExpr, List<Parameter> parameters, List<ArrayBracketPair> arrayBracketPairsAfterParameterList, List<ReferenceType> throws_, BlockStmt body) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters(typeParameters);
        this.setElementType(elementType);
        this.setNameExpr(nameExpr);
        this.setParameters((List)parameters);
        this.setArrayBracketPairsAfterElementType((List)arrayBracketPairsAfterElementType);
        this.setArrayBracketPairsAfterParameterList(arrayBracketPairsAfterParameterList);
        this.setThrows((List)throws_);
        this.setBody(body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public BlockStmt getBody() {
        return this.body;
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    @Override
    public List<Parameter> getParameters() {
        this.parameters = Utils.ensureNotNull(this.parameters);
        return this.parameters;
    }

    @Override
    public List<ReferenceType> getThrows() {
        this.throws_ = Utils.ensureNotNull(this.throws_);
        return this.throws_;
    }

    @Override
    public Type getType() {
        return ArrayType.wrapInArrayTypes(this.getElementType(), this.getArrayBracketPairsAfterElementType(), this.getArrayBracketPairsAfterParameterList());
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    public List<TypeParameter> getTypeParameters() {
        this.typeParameters = Utils.ensureNotNull(this.typeParameters);
        return this.typeParameters;
    }

    @Override
    public MethodDeclaration setBody(BlockStmt body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
        return this;
    }

    @Override
    public MethodDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public MethodDeclaration setName(String name) {
        this.setNameExpr(new NameExpr(name));
        return this;
    }

    public MethodDeclaration setNameExpr(NameExpr name) {
        this.name = name;
        this.setAsParentNodeOf(this.name);
        return this;
    }

    @Override
    public MethodDeclaration setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(this.parameters);
        return this;
    }

    @Override
    public MethodDeclaration setThrows(List<ReferenceType> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(this.throws_);
        return this;
    }

    @Override
    public MethodDeclaration setType(Type type) {
        Pair<Type, List<ArrayBracketPair>> typeListPair = ArrayType.unwrapArrayTypes(type);
        this.setElementType((Type)typeListPair.a);
        this.setArrayBracketPairsAfterElementType((List)typeListPair.b);
        this.setArrayBracketPairsAfterParameterList(null);
        return this;
    }

    @Override
    public MethodDeclaration setElementType(Type elementType) {
        this.elementType = elementType;
        this.setAsParentNodeOf(this.elementType);
        return this;
    }

    public MethodDeclaration setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
        return this;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public MethodDeclaration setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuilder sb = new StringBuilder();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = Modifier.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
            if (this.getModifiers().contains((Object)Modifier.STATIC)) {
                sb.append("static ");
            }
            if (this.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                sb.append("abstract ");
            }
            if (this.getModifiers().contains((Object)Modifier.FINAL)) {
                sb.append("final ");
            }
            if (this.getModifiers().contains((Object)Modifier.NATIVE)) {
                sb.append("native ");
            }
            if (this.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
                sb.append("synchronized ");
            }
        }
        sb.append(this.getElementType().toStringWithoutComments());
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toStringWithoutComments());
                continue;
            }
            sb.append(param.getElementType().toStringWithoutComments());
            if (!param.isVarArgs()) continue;
            sb.append("...");
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toStringWithoutComments());
            }
        }
        return sb.toString();
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    @Override
    public List<ArrayBracketPair> getArrayBracketPairsAfterElementType() {
        this.arrayBracketPairsAfterType = Utils.ensureNotNull(this.arrayBracketPairsAfterType);
        return this.arrayBracketPairsAfterType;
    }

    @Override
    public MethodDeclaration setArrayBracketPairsAfterElementType(List<ArrayBracketPair> arrayBracketPairsAfterType) {
        this.arrayBracketPairsAfterType = arrayBracketPairsAfterType;
        this.setAsParentNodeOf(arrayBracketPairsAfterType);
        return this;
    }

    public List<ArrayBracketPair> getArrayBracketPairsAfterParameterList() {
        this.arrayBracketPairsAfterParameterList = Utils.ensureNotNull(this.arrayBracketPairsAfterParameterList);
        return this.arrayBracketPairsAfterParameterList;
    }

    public MethodDeclaration setArrayBracketPairsAfterParameterList(List<ArrayBracketPair> arrayBracketPairsAfterParameterList) {
        this.arrayBracketPairsAfterParameterList = arrayBracketPairsAfterParameterList;
        this.setAsParentNodeOf(arrayBracketPairsAfterParameterList);
        return this;
    }
}

