/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.nodeTypes.NodeWithThrowable;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.List;

public final class ConstructorDeclaration
extends BodyDeclaration<ConstructorDeclaration>
implements NodeWithJavaDoc<ConstructorDeclaration>,
NodeWithDeclaration,
NodeWithName<ConstructorDeclaration>,
NodeWithModifiers<ConstructorDeclaration>,
NodeWithParameters<ConstructorDeclaration>,
NodeWithThrowable<ConstructorDeclaration>,
NodeWithBlockStmt<ConstructorDeclaration> {
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private List<TypeParameter> typeParameters;
    private NameExpr name;
    private List<Parameter> parameters;
    private List<ReferenceType> throws_;
    private BlockStmt body;

    public ConstructorDeclaration() {
    }

    public ConstructorDeclaration(EnumSet<Modifier> modifiers, String name) {
        this.setModifiers((EnumSet)modifiers);
        this.setName(name);
    }

    public ConstructorDeclaration(EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, String name, List<Parameter> parameters, List<ReferenceType> throws_, BlockStmt block) {
        super(annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters(typeParameters);
        this.setName(name);
        this.setParameters((List)parameters);
        this.setThrows((List)throws_);
        this.setBody(block);
    }

    public ConstructorDeclaration(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, String name, List<Parameter> parameters, List<ReferenceType> throws_, BlockStmt block) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters(typeParameters);
        this.setName(name);
        this.setParameters((List)parameters);
        this.setThrows((List)throws_);
        this.setBody(block);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    @Override
    public List<Parameter> getParameters() {
        this.parameters = Utils.ensureNotNull(this.parameters);
        return this.parameters;
    }

    @Override
    public List<ReferenceType> getThrows() {
        this.throws_ = Utils.ensureNotNull(this.throws_);
        return this.throws_;
    }

    public List<TypeParameter> getTypeParameters() {
        this.typeParameters = Utils.ensureNotNull(this.typeParameters);
        return this.typeParameters;
    }

    @Override
    public ConstructorDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public ConstructorDeclaration setName(String name) {
        this.setNameExpr(new NameExpr(name));
        return this;
    }

    public ConstructorDeclaration setNameExpr(NameExpr name) {
        this.name = name;
        this.setAsParentNodeOf(this.name);
        return this;
    }

    @Override
    public ConstructorDeclaration setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(this.parameters);
        return this;
    }

    @Override
    public ConstructorDeclaration setThrows(List<ReferenceType> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(this.throws_);
        return this;
    }

    public ConstructorDeclaration setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(this.typeParameters);
        return this;
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuilder sb = new StringBuilder();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = Modifier.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
        }
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toStringWithoutComments());
                continue;
            }
            sb.append(param.getElementType().toStringWithoutComments());
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toStringWithoutComments());
            }
        }
        return sb.toString();
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    @Override
    public BlockStmt getBody() {
        return this.body;
    }

    @Override
    public ConstructorDeclaration setBody(BlockStmt body) {
        this.body = body;
        this.setAsParentNodeOf(body);
        return this;
    }
}

