/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.Range;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.ClassUtils;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public final class CompilationUnit
extends Node {
    private PackageDeclaration pakage;
    private List<ImportDeclaration> imports;
    private List<TypeDeclaration<?>> types;

    public CompilationUnit() {
    }

    public CompilationUnit(PackageDeclaration pakage, List<ImportDeclaration> imports, List<TypeDeclaration<?>> types) {
        this.setPackage(pakage);
        this.setImports(imports);
        this.setTypes(types);
    }

    public CompilationUnit(Range range, PackageDeclaration pakage, List<ImportDeclaration> imports, List<TypeDeclaration<?>> types) {
        super(range);
        this.setPackage(pakage);
        this.setImports(imports);
        this.setTypes(types);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<Comment> getComments() {
        return this.getAllContainedComments();
    }

    public List<ImportDeclaration> getImports() {
        this.imports = Utils.ensureNotNull(this.imports);
        return this.imports;
    }

    public PackageDeclaration getPackage() {
        return this.pakage;
    }

    public List<TypeDeclaration<?>> getTypes() {
        this.types = Utils.ensureNotNull(this.types);
        return this.types;
    }

    public CompilationUnit setComments(List<Comment> comments) {
        throw new RuntimeException("Not implemented!");
    }

    public CompilationUnit setImports(List<ImportDeclaration> imports) {
        this.imports = imports;
        this.setAsParentNodeOf(this.imports);
        return this;
    }

    public CompilationUnit setPackage(PackageDeclaration pakage) {
        this.pakage = pakage;
        this.setAsParentNodeOf(this.pakage);
        return this;
    }

    public CompilationUnit setTypes(List<TypeDeclaration<?>> types) {
        this.types = types;
        this.setAsParentNodeOf(this.types);
        return this;
    }

    public CompilationUnit setPackageName(String name) {
        this.setPackage(new PackageDeclaration(NameExpr.name(name)));
        return this;
    }

    public CompilationUnit addImport(String name) {
        return this.addImport(name, false, false);
    }

    public CompilationUnit addImport(Class<?> clazz) {
        if (ClassUtils.isPrimitiveOrWrapper(clazz) || clazz.getName().startsWith("java.lang")) {
            return this;
        }
        if (clazz.isArray() && !ClassUtils.isPrimitiveOrWrapper(clazz.getComponentType()) && !clazz.getComponentType().getName().startsWith("java.lang")) {
            return this.addImport(clazz.getComponentType().getName());
        }
        return this.addImport(clazz.getName());
    }

    public CompilationUnit addImport(String name, boolean isStatic, boolean isAsterisk) {
        if (this.getImports().stream().anyMatch(i -> i.getName().toString().equals(name))) {
            return this;
        }
        ImportDeclaration importDeclaration = new ImportDeclaration(NameExpr.name(name), isStatic, isAsterisk);
        this.getImports().add(importDeclaration);
        importDeclaration.setParentNode(this);
        return this;
    }

    public ClassOrInterfaceDeclaration addClass(String name) {
        return this.addClass(name, Modifier.PUBLIC);
    }

    public ClassOrInterfaceDeclaration addClass(String name, Modifier ... modifiers) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), false, name);
        this.getTypes().add(classOrInterfaceDeclaration);
        classOrInterfaceDeclaration.setParentNode(this);
        return classOrInterfaceDeclaration;
    }

    public ClassOrInterfaceDeclaration addInterface(String name) {
        return this.addInterface(name, Modifier.PUBLIC);
    }

    public ClassOrInterfaceDeclaration addInterface(String name, Modifier ... modifiers) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), true, name);
        this.getTypes().add(classOrInterfaceDeclaration);
        classOrInterfaceDeclaration.setParentNode(this);
        return classOrInterfaceDeclaration;
    }

    public EnumDeclaration addEnum(String name) {
        return this.addEnum(name, Modifier.PUBLIC);
    }

    public EnumDeclaration addEnum(String name, Modifier ... modifiers) {
        EnumDeclaration enumDeclaration = new EnumDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), name);
        this.getTypes().add(enumDeclaration);
        enumDeclaration.setParentNode(this);
        return enumDeclaration;
    }

    public AnnotationDeclaration addAnnotationDeclaration(String name) {
        return this.addAnnotationDeclaration(name, Modifier.PUBLIC);
    }

    public AnnotationDeclaration addAnnotationDeclaration(String name, Modifier ... modifiers) {
        AnnotationDeclaration annotationDeclaration = new AnnotationDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), name);
        this.getTypes().add(annotationDeclaration);
        annotationDeclaration.setParentNode(this);
        return annotationDeclaration;
    }

    public ClassOrInterfaceDeclaration getClassByName(String className) {
        return this.getTypes().stream().filter(type -> type.getName().equals(className) && type instanceof ClassOrInterfaceDeclaration && !((ClassOrInterfaceDeclaration)type).isInterface()).findFirst().orElse(null);
    }

    public ClassOrInterfaceDeclaration getInterfaceByName(String interfaceName) {
        return this.getTypes().stream().filter(type -> type.getName().equals(interfaceName) && type instanceof ClassOrInterfaceDeclaration && ((ClassOrInterfaceDeclaration)type).isInterface()).findFirst().orElse(null);
    }

    public EnumDeclaration getEnumByName(String enumName) {
        return this.getTypes().stream().filter(type -> type.getName().equals(enumName) && type instanceof EnumDeclaration).findFirst().orElse(null);
    }

    public AnnotationDeclaration getAnnotationDeclarationByName(String annotationName) {
        return this.getTypes().stream().filter(type -> type.getName().equals(annotationName) && type instanceof AnnotationDeclaration).findFirst().orElse(null);
    }
}

