/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class ExplicitConstructorInvocationStmt
extends Statement
implements NodeWithTypeArguments<ExplicitConstructorInvocationStmt> {
    private NodeList<Type<?>> typeArguments;
    private boolean isThis;
    private Expression expr;
    private NodeList<Expression> args;

    public ExplicitConstructorInvocationStmt() {
        this(Range.UNKNOWN, new NodeList(), true, null, new NodeList<Expression>());
    }

    public ExplicitConstructorInvocationStmt(boolean isThis, Expression expr, NodeList<Expression> args) {
        this(Range.UNKNOWN, new NodeList(), isThis, expr, args);
    }

    public ExplicitConstructorInvocationStmt(Range range, NodeList<Type<?>> typeArguments, boolean isThis, Expression expr, NodeList<Expression> args) {
        super(range);
        this.setTypeArguments((NodeList)typeArguments);
        this.setThis(isThis);
        this.setExpr(expr);
        this.setArgs(args);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public NodeList<Expression> getArgs() {
        return this.args;
    }

    public Expression getArg(int i) {
        return (Expression)this.getArgs().get(i);
    }

    public Optional<Expression> getExpr() {
        return Optional.ofNullable(this.expr);
    }

    public boolean isThis() {
        return this.isThis;
    }

    public ExplicitConstructorInvocationStmt setArgs(NodeList<Expression> args) {
        this.notifyPropertyChange(ObservableProperty.ARGS, this.args, args);
        this.args = Utils.assertNotNull(args);
        this.setAsParentNodeOf(this.args);
        return this;
    }

    public ExplicitConstructorInvocationStmt setExpr(Expression expr) {
        this.notifyPropertyChange(ObservableProperty.EXPR, this.expr, expr);
        this.expr = expr;
        this.setAsParentNodeOf(this.expr);
        return this;
    }

    public ExplicitConstructorInvocationStmt setThis(boolean isThis) {
        this.notifyPropertyChange(ObservableProperty.IS_THIS, this.isThis, isThis);
        this.isThis = isThis;
        return this;
    }

    @Override
    public Optional<NodeList<Type<?>>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    @Override
    public ExplicitConstructorInvocationStmt setTypeArguments(NodeList<Type<?>> typeArguments) {
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, typeArguments);
        this.typeArguments = typeArguments;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

