/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class ObjectCreationExpr
extends Expression
implements NodeWithTypeArguments<ObjectCreationExpr>,
NodeWithType<ObjectCreationExpr, ClassOrInterfaceType>,
NodeWithArguments<ObjectCreationExpr> {
    private Expression scope;
    private ClassOrInterfaceType type;
    private NodeList<Type<?>> typeArguments;
    private NodeList<Expression> args;
    private NodeList<BodyDeclaration<?>> anonymousClassBody;

    public ObjectCreationExpr() {
        this(Range.UNKNOWN, null, new ClassOrInterfaceType(), new NodeList(), new NodeList<Expression>(), null);
    }

    public ObjectCreationExpr(Expression scope, ClassOrInterfaceType type, NodeList<Expression> args) {
        this(Range.UNKNOWN, scope, type, new NodeList(), args, null);
    }

    public ObjectCreationExpr(Range range, Expression scope, ClassOrInterfaceType type, NodeList<Type<?>> typeArguments, NodeList<Expression> args, NodeList<BodyDeclaration<?>> anonymousBody) {
        super(range);
        this.setScope(scope);
        this.setType(type);
        this.setTypeArguments((NodeList)typeArguments);
        this.setArgs((NodeList)args);
        this.setAnonymousClassBody(anonymousBody);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<NodeList<BodyDeclaration<?>>> getAnonymousClassBody() {
        return Optional.ofNullable(this.anonymousClassBody);
    }

    public void addAnonymousClassBody(BodyDeclaration<?> body) {
        if (this.anonymousClassBody == null) {
            this.anonymousClassBody = new NodeList();
        }
        this.anonymousClassBody.add(body);
    }

    @Override
    public NodeList<Expression> getArgs() {
        return this.args;
    }

    public Optional<Expression> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    public ClassOrInterfaceType getType() {
        return this.type;
    }

    public ObjectCreationExpr setAnonymousClassBody(NodeList<BodyDeclaration<?>> anonymousClassBody) {
        this.notifyPropertyChange(ObservableProperty.ANONYMOUS_CLASS_BODY, this.anonymousClassBody, anonymousClassBody);
        this.anonymousClassBody = anonymousClassBody;
        this.setAsParentNodeOf(this.anonymousClassBody);
        return this;
    }

    @Override
    public ObjectCreationExpr setArgs(NodeList<Expression> args) {
        this.notifyPropertyChange(ObservableProperty.ARGS, this.args, args);
        this.args = Utils.assertNotNull(args);
        this.setAsParentNodeOf(this.args);
        return this;
    }

    public ObjectCreationExpr setScope(Expression scope) {
        this.notifyPropertyChange(ObservableProperty.SCOPE, this.scope, scope);
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public ObjectCreationExpr setType(ClassOrInterfaceType type) {
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        Utils.assertNotNull(type);
        this.type = type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    @Override
    public Optional<NodeList<Type<?>>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    @Override
    public ObjectCreationExpr setTypeArguments(NodeList<Type<?>> typeArguments) {
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, typeArguments);
        this.typeArguments = typeArguments;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

