/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class FieldAccessExpr
extends Expression
implements NodeWithTypeArguments<FieldAccessExpr> {
    private Expression scope;
    private NodeList<Type<?>> typeArguments;
    private SimpleName field;

    public FieldAccessExpr() {
        this(Range.UNKNOWN, new ThisExpr(), new NodeList(), new SimpleName());
    }

    public FieldAccessExpr(Expression scope, String field) {
        this(Range.UNKNOWN, scope, new NodeList(), new SimpleName(field));
    }

    public FieldAccessExpr(Range range, Expression scope, NodeList<Type<?>> typeArguments, SimpleName field) {
        super(range);
        this.setScope(scope);
        this.setTypeArguments((NodeList)typeArguments);
        this.setFieldExpr(field);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public SimpleName getField() {
        return this.field;
    }

    public Optional<Expression> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public FieldAccessExpr setField(String field) {
        this.setFieldExpr(new SimpleName(field));
        return this;
    }

    public FieldAccessExpr setFieldExpr(SimpleName inner) {
        this.notifyPropertyChange(ObservableProperty.FIELD, this.field, inner);
        this.field = Utils.assertNotNull(inner);
        this.setAsParentNodeOf(this.field);
        return this;
    }

    public FieldAccessExpr setScope(Expression scope) {
        this.notifyPropertyChange(ObservableProperty.SCOPE, this.scope, scope);
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public Optional<NodeList<Type<?>>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    @Override
    public FieldAccessExpr setTypeArguments(NodeList<Type<?>> types) {
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, this.typeArguments);
        this.typeArguments = types;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

