/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.List;

public final class EnumDeclaration
extends TypeDeclaration<EnumDeclaration> {
    private List<ClassOrInterfaceType> implementsList;
    private List<EnumConstantDeclaration> entries;

    public EnumDeclaration() {
    }

    public EnumDeclaration(EnumSet<Modifier> modifiers, String name) {
        super(modifiers, name);
    }

    public EnumDeclaration(EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, String name, List<ClassOrInterfaceType> implementsList, List<EnumConstantDeclaration> entries, List<BodyDeclaration<?>> members) {
        super(annotations, modifiers, name, members);
        this.setImplements(implementsList);
        this.setEntries(entries);
    }

    public EnumDeclaration(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, String name, List<ClassOrInterfaceType> implementsList, List<EnumConstantDeclaration> entries, List<BodyDeclaration<?>> members) {
        super(range, annotations, modifiers, name, members);
        this.setImplements(implementsList);
        this.setEntries(entries);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<EnumConstantDeclaration> getEntries() {
        this.entries = Utils.ensureNotNull(this.entries);
        return this.entries;
    }

    public List<ClassOrInterfaceType> getImplements() {
        this.implementsList = Utils.ensureNotNull(this.implementsList);
        return this.implementsList;
    }

    public EnumDeclaration setEntries(List<EnumConstantDeclaration> entries) {
        this.entries = entries;
        this.setAsParentNodeOf(this.entries);
        return this;
    }

    public EnumDeclaration setImplements(List<ClassOrInterfaceType> implementsList) {
        this.implementsList = implementsList;
        this.setAsParentNodeOf(this.implementsList);
        return this;
    }

    public EnumDeclaration addImplements(String name) {
        ClassOrInterfaceType classOrInterfaceType = new ClassOrInterfaceType(name);
        this.getImplements().add(classOrInterfaceType);
        classOrInterfaceType.setParentNode(this);
        return this;
    }

    public EnumDeclaration addImplements(Class<?> clazz) {
        this.tryAddImportToParentCompilationUnit(clazz);
        return this.addImplements(clazz.getSimpleName());
    }

    public EnumConstantDeclaration addEnumConstant(String name) {
        EnumConstantDeclaration enumConstant = new EnumConstantDeclaration(name);
        this.getEntries().add(enumConstant);
        enumConstant.setParentNode(this);
        return enumConstant;
    }
}

