/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.List;

public abstract class BaseParameter<T>
extends Node
implements NodeWithAnnotations<T>,
NodeWithName<T>,
NodeWithModifiers<T> {
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private List<AnnotationExpr> annotations;
    private VariableDeclaratorId id;

    public BaseParameter() {
    }

    public BaseParameter(VariableDeclaratorId id) {
        this.setId(id);
    }

    public BaseParameter(EnumSet<Modifier> modifiers, VariableDeclaratorId id) {
        this.setModifiers(modifiers);
        this.setId(id);
    }

    public BaseParameter(EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, VariableDeclaratorId id) {
        this.setModifiers(modifiers);
        this.setAnnotations(annotations);
        this.setId(id);
    }

    public BaseParameter(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, VariableDeclaratorId id) {
        super(range);
        this.setModifiers(modifiers);
        this.setAnnotations(annotations);
        this.setId(id);
    }

    @Override
    public List<AnnotationExpr> getAnnotations() {
        this.annotations = Utils.ensureNotNull(this.annotations);
        return this.annotations;
    }

    public VariableDeclaratorId getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.getId().getName();
    }

    @Override
    public T setName(String name) {
        if (this.id != null) {
            this.id.setName(name);
        } else {
            this.id = new VariableDeclaratorId(name);
        }
        return (T)this;
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public T setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(this.annotations);
        return (T)this;
    }

    public void setId(VariableDeclaratorId id) {
        this.id = id;
        this.setAsParentNodeOf(this.id);
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return (T)this;
    }
}

