/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.HashMap;

public final class PrimitiveType
extends Type
implements NodeWithAnnotations<PrimitiveType> {
    static final HashMap<String, Primitive> unboxMap = new HashMap();
    private Primitive type;

    public static PrimitiveType booleanType() {
        return new PrimitiveType(Primitive.BOOLEAN);
    }

    public static PrimitiveType charType() {
        return new PrimitiveType(Primitive.CHAR);
    }

    public static PrimitiveType byteType() {
        return new PrimitiveType(Primitive.BYTE);
    }

    public static PrimitiveType shortType() {
        return new PrimitiveType(Primitive.SHORT);
    }

    public static PrimitiveType intType() {
        return new PrimitiveType(Primitive.INT);
    }

    public static PrimitiveType longType() {
        return new PrimitiveType(Primitive.LONG);
    }

    public static PrimitiveType floatType() {
        return new PrimitiveType(Primitive.FLOAT);
    }

    public static PrimitiveType doubleType() {
        return new PrimitiveType(Primitive.DOUBLE);
    }

    public PrimitiveType() {
        this(null, Primitive.INT);
    }

    public PrimitiveType(Primitive type) {
        this(null, type);
    }

    public PrimitiveType(Range range, Primitive type) {
        super(range, new NodeList<AnnotationExpr>());
        this.setType(type);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Primitive getType() {
        return this.type;
    }

    public ClassOrInterfaceType toBoxedType() {
        return this.type.toBoxedType();
    }

    public PrimitiveType setType(Primitive type) {
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = type;
        return this;
    }

    public String asString() {
        return this.type.asString();
    }

    @Override
    public PrimitiveType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (PrimitiveType)super.setAnnotations(annotations);
    }

    static {
        for (Primitive unboxedType : Primitive.values()) {
            unboxMap.put(unboxedType.nameOfBoxedType, unboxedType);
        }
    }

    public static enum Primitive {
        BOOLEAN("Boolean"),
        CHAR("Character"),
        BYTE("Byte"),
        SHORT("Short"),
        INT("Integer"),
        LONG("Long"),
        FLOAT("Float"),
        DOUBLE("Double");

        final String nameOfBoxedType;
        private String codeRepresentation;

        public ClassOrInterfaceType toBoxedType() {
            return new ClassOrInterfaceType(this.nameOfBoxedType);
        }

        public String asString() {
            return this.codeRepresentation;
        }

        private Primitive(String nameOfBoxedType) {
            this.nameOfBoxedType = nameOfBoxedType;
            this.codeRepresentation = this.name().toLowerCase();
        }
    }
}

