/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBody;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public final class ForeachStmt
extends Statement
implements NodeWithBody<ForeachStmt> {
    private VariableDeclarationExpr variable;
    private Expression iterable;
    private Statement body;

    public ForeachStmt() {
        this(null, new VariableDeclarationExpr(), new NameExpr(), new ReturnStmt());
    }

    public ForeachStmt(VariableDeclarationExpr variable, Expression iterable, Statement body) {
        this(null, variable, iterable, body);
    }

    public ForeachStmt(Range range, VariableDeclarationExpr variable, Expression iterable, Statement body) {
        super(range);
        this.setVariable(variable);
        this.setIterable(iterable);
        this.setBody(body);
    }

    public ForeachStmt(VariableDeclarationExpr variable, String iterable, BlockStmt body) {
        this(null, variable, new NameExpr(iterable), body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    public Expression getIterable() {
        return this.iterable;
    }

    public VariableDeclarationExpr getVariable() {
        return this.variable;
    }

    @Override
    public ForeachStmt setBody(Statement body) {
        this.notifyPropertyChange(ObservableProperty.BODY, this.body, body);
        this.body = Utils.assertNotNull(body);
        this.setAsParentNodeOf(this.body);
        return this;
    }

    public ForeachStmt setIterable(Expression iterable) {
        this.notifyPropertyChange(ObservableProperty.ITERABLE, this.iterable, iterable);
        this.iterable = Utils.assertNotNull(iterable);
        this.setAsParentNodeOf(this.iterable);
        return this;
    }

    public ForeachStmt setVariable(VariableDeclarationExpr var) {
        this.notifyPropertyChange(ObservableProperty.VARIABLE, this.variable, var);
        this.variable = Utils.assertNotNull(var);
        this.setAsParentNodeOf(this.variable);
        return this;
    }
}

