/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class ExplicitConstructorInvocationStmt
extends Statement
implements NodeWithTypeArguments<ExplicitConstructorInvocationStmt> {
    private NodeList<Type> typeArguments;
    private boolean isThis;
    private Expression expression;
    private NodeList<Expression> arguments;

    public ExplicitConstructorInvocationStmt() {
        this(null, new NodeList<Type>(), true, null, new NodeList<Expression>());
    }

    public ExplicitConstructorInvocationStmt(boolean isThis, Expression expression, NodeList<Expression> arguments) {
        this(null, new NodeList<Type>(), isThis, expression, arguments);
    }

    public ExplicitConstructorInvocationStmt(Range range, NodeList<Type> typeArguments, boolean isThis, Expression expression, NodeList<Expression> arguments) {
        super(range);
        this.setTypeArguments((NodeList)typeArguments);
        this.setThis(isThis);
        this.setExpression(expression);
        this.setArguments(arguments);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public NodeList<Expression> getArguments() {
        return this.arguments;
    }

    public Expression getArgument(int i) {
        return (Expression)this.getArguments().get(i);
    }

    public Optional<Expression> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    public boolean isThis() {
        return this.isThis;
    }

    public ExplicitConstructorInvocationStmt setArguments(NodeList<Expression> arguments) {
        this.notifyPropertyChange(ObservableProperty.ARGUMENTS, this.arguments, arguments);
        this.arguments = Utils.assertNotNull(arguments);
        this.setAsParentNodeOf(this.arguments);
        return this;
    }

    public ExplicitConstructorInvocationStmt setExpression(Expression expression) {
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expression);
        this.expression = expression;
        this.setAsParentNodeOf(this.expression);
        return this;
    }

    public ExplicitConstructorInvocationStmt setThis(boolean isThis) {
        this.notifyPropertyChange(ObservableProperty.IS_THIS, this.isThis, isThis);
        this.isThis = isThis;
        return this;
    }

    @Override
    public Optional<NodeList<Type>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    @Override
    public ExplicitConstructorInvocationStmt setTypeArguments(NodeList<Type> typeArguments) {
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, typeArguments);
        this.typeArguments = typeArguments;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

