/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Range;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public class Problem {
    private final String message;
    private final Range range;
    private final Throwable cause;

    Problem(String message, Range range, Throwable cause) {
        this.message = message;
        this.range = range;
        this.cause = cause;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.message);
        if (this.range != null) {
            str.append(" ").append(this.range);
        }
        if (this.cause != null) {
            str.append(Utils.EOL).append("Problem stacktrace : ").append(Utils.EOL);
            for (int i = 0; i < this.cause.getStackTrace().length; ++i) {
                StackTraceElement ste = this.cause.getStackTrace()[i];
                str.append("  ").append(ste.toString());
                if (i + 1 == this.cause.getStackTrace().length) continue;
                str.append(Utils.EOL);
            }
        }
        return str.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<Range> getRange() {
        return Optional.ofNullable(this.range);
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }
}

