/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import java.util.Collections;
import java.util.List;

public final class PositionUtils {
    private PositionUtils() {
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(NodeList<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes, boolean ignoringAnnotations) {
        Collections.sort(nodes, (o1, o2) -> PositionUtils.compare(o1, o2, ignoringAnnotations));
    }

    public static <T extends Node> void sortByBeginPosition(NodeList<T> nodes, boolean ignoringAnnotations) {
        nodes.sort((o1, o2) -> PositionUtils.compare(o1, o2, ignoringAnnotations));
    }

    public static boolean areInOrder(Node a, Node b) {
        return PositionUtils.areInOrder(a, b, false);
    }

    public static boolean areInOrder(Node a, Node b, boolean ignoringAnnotations) {
        return PositionUtils.compare(a, b, ignoringAnnotations) <= 0;
    }

    private static int compare(Node a, Node b, boolean ignoringAnnotations) {
        if (!a.getRange().isPresent() || !b.getRange().isPresent()) {
            return -1;
        }
        if (ignoringAnnotations) {
            int signLine = Integer.signum(PositionUtils.beginLineWithoutConsideringAnnotation(a) - PositionUtils.beginLineWithoutConsideringAnnotation(b));
            if (signLine == 0) {
                return Integer.signum(PositionUtils.beginColumnWithoutConsideringAnnotation(a) - PositionUtils.beginColumnWithoutConsideringAnnotation(b));
            }
            return signLine;
        }
        Position aBegin = a.getBegin().get();
        Position bBegin = b.getBegin().get();
        int signLine = Integer.signum(aBegin.line - bBegin.line);
        if (signLine == 0) {
            return Integer.signum(aBegin.column - bBegin.column);
        }
        return signLine;
    }

    public static AnnotationExpr getLastAnnotation(Node node) {
        if (node instanceof NodeWithAnnotations) {
            NodeList<AnnotationExpr> annotations = NodeList.nodeList(((NodeWithAnnotations)((Object)node)).getAnnotations());
            if (annotations.isEmpty()) {
                return null;
            }
            PositionUtils.sortByBeginPosition(annotations);
            return (AnnotationExpr)annotations.get(annotations.size() - 1);
        }
        return null;
    }

    private static int beginLineWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations((Node)node).getRange().get().begin.line;
    }

    private static int beginColumnWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations((Node)node).getRange().get().begin.column;
    }

    private static Node beginNodeWithoutConsideringAnnotations(Node node) {
        if (node instanceof MethodDeclaration || node instanceof FieldDeclaration) {
            NodeWithElementType casted = (NodeWithElementType)((Object)node);
            return casted.getElementType();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration casted = (ClassOrInterfaceDeclaration)node;
            return casted.getName();
        }
        return node;
    }

    public static boolean nodeContains(Node container, Node contained, boolean ignoringAnnotations) {
        Range containedRange = contained.getRange().get();
        Range containerRange = container.getRange().get();
        if (containerRange == null || containedRange == null) {
            return false;
        }
        if (!ignoringAnnotations || PositionUtils.getLastAnnotation(container) == null) {
            return container.containsWithin(contained);
        }
        if (!container.containsWithin(contained)) {
            return false;
        }
        if (container instanceof NodeWithAnnotations) {
            int bl = PositionUtils.beginLineWithoutConsideringAnnotation(container);
            int bc = PositionUtils.beginColumnWithoutConsideringAnnotation(container);
            if (bl > containedRange.begin.line) {
                return false;
            }
            if (bl == containedRange.begin.line && bc > containedRange.begin.column) {
                return false;
            }
            if (containerRange.end.line < containedRange.end.line) {
                return false;
            }
            return containerRange.end.line != containedRange.end.line || containerRange.end.column >= containedRange.end.column;
        }
        return true;
    }
}

