/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;

public class ArrayType
extends ReferenceType<ArrayType>
implements NodeWithAnnotations<ArrayType> {
    private Type componentType;

    public ArrayType(Type<?> componentType, NodeList<AnnotationExpr> annotations) {
        this(null, componentType, annotations);
    }

    public ArrayType(Range range, Type<?> componentType, NodeList<AnnotationExpr> annotations) {
        super(range);
        this.setComponentType(componentType);
        this.setAnnotations((NodeList)annotations);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public ArrayType setComponentType(Type<?> type) {
        this.notifyPropertyChange(ObservableProperty.COMPONENT_TYPE, this.componentType, this.componentType);
        this.componentType = Utils.assertNotNull(type);
        this.setAsParentNodeOf(this.componentType);
        return this;
    }

    @SafeVarargs
    public static Type wrapInArrayTypes(Type type, NodeList<ArrayBracketPair> ... arrayBracketPairLists) {
        for (int i = arrayBracketPairLists.length - 1; i >= 0; --i) {
            NodeList<ArrayBracketPair> arrayBracketPairList = arrayBracketPairLists[i];
            if (arrayBracketPairList == null) continue;
            for (int j = arrayBracketPairList.size() - 1; j >= 0; --j) {
                ArrayBracketPair pair = (ArrayBracketPair)arrayBracketPairList.get(j);
                type = new ArrayType(pair.getRange().orElse(null), type, pair.getAnnotations());
            }
        }
        return type;
    }

    public static Pair<Type<?>, NodeList<ArrayBracketPair>> unwrapArrayTypes(Type<?> type) {
        NodeList<ArrayBracketPair> arrayBracketPairs = new NodeList<ArrayBracketPair>();
        while (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayBracketPairs.add(new ArrayBracketPair(type.getRange().orElse(null), arrayType.getAnnotations()));
            type = arrayType.getComponentType();
        }
        return new Pair(type, arrayBracketPairs);
    }

    public static ArrayType arrayOf(Type type, AnnotationExpr ... annotations) {
        return new ArrayType(type, (NodeList<AnnotationExpr>)NodeList.nodeList((Node[])annotations));
    }
}

