/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class BinaryExpr
extends Expression {
    private Expression left;
    private Expression right;
    private Operator op;

    public BinaryExpr() {
    }

    public BinaryExpr(Expression left, Expression right, Operator op) {
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(op);
    }

    @Deprecated
    public BinaryExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression left, Expression right, Operator op) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), left, right, op);
    }

    public BinaryExpr(Range range, Expression left, Expression right, Operator op) {
        super(range);
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(op);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setLeft(Expression left) {
        this.left = left;
        this.setAsParentNodeOf(this.left);
    }

    public void setOperator(Operator op) {
        this.op = op;
    }

    public void setRight(Expression right) {
        this.right = right;
        this.setAsParentNodeOf(this.right);
    }

    public static enum Operator {
        or,
        and,
        binOr,
        binAnd,
        xor,
        equals,
        notEquals,
        less,
        greater,
        lessEquals,
        greaterEquals,
        lShift,
        rSignedShift,
        rUnsignedShift,
        plus,
        minus,
        times,
        divide,
        remainder;

    }
}

