/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ASTParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.Provider;
import com.github.javaparser.StreamProvider;
import com.github.javaparser.Token;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class InstanceJavaParser {
    private final ASTParser astParser;
    private final Provider provider;

    public InstanceJavaParser(Provider provider) {
        this.provider = provider;
        this.astParser = new ASTParser(provider);
    }

    public InstanceJavaParser(Reader reader) {
        this(new StreamProvider(reader));
    }

    public InstanceJavaParser(InputStream input) throws IOException {
        this(new StreamProvider(input));
    }

    public InstanceJavaParser(InputStream input, String encoding) throws IOException {
        this(new StreamProvider(input, encoding));
    }

    public InstanceJavaParser(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public InstanceJavaParser(File file, String encoding) throws IOException {
        this(new FileInputStream(file), encoding);
    }

    public InstanceJavaParser(String source) {
        this(new StringReader(source));
    }

    public List<Token> getTokens() {
        return this.astParser.getTokens();
    }

    public CompilationUnit parse() throws ParseException {
        try {
            CompilationUnit compilationUnit = this.astParser.CompilationUnit();
            return compilationUnit;
        }
        finally {
            this.closeProvider();
        }
    }

    private void closeProvider() {
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BlockStmt parseBlock() throws ParseException {
        try {
            BlockStmt blockStmt = this.astParser.Block();
            return blockStmt;
        }
        finally {
            this.closeProvider();
        }
    }

    public List<?> parseStatements() throws ParseException {
        try {
            List list = this.astParser.Statements();
            return list;
        }
        finally {
            this.closeProvider();
        }
    }

    public Statement parseStatement() throws ParseException {
        try {
            Statement statement = this.astParser.Statement();
            return statement;
        }
        finally {
            this.closeProvider();
        }
    }

    public ImportDeclaration parseImport() throws ParseException {
        try {
            ImportDeclaration importDeclaration = this.astParser.ImportDeclaration();
            return importDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }

    public Expression parseExpression() throws ParseException {
        try {
            Expression expression = this.astParser.Expression();
            return expression;
        }
        finally {
            this.closeProvider();
        }
    }

    public AnnotationExpr parseAnnotation() throws ParseException {
        try {
            AnnotationExpr annotationExpr = this.astParser.Annotation();
            return annotationExpr;
        }
        finally {
            this.closeProvider();
        }
    }

    public BodyDeclaration parseBodyDeclaration() throws ParseException {
        try {
            BodyDeclaration bodyDeclaration = this.astParser.AnnotationBodyDeclaration();
            return bodyDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }

    public BodyDeclaration parseClassOrInterfaceBodyDeclaration(boolean isInterface) throws ParseException {
        try {
            BodyDeclaration bodyDeclaration = this.astParser.ClassOrInterfaceBodyDeclaration(isInterface);
            return bodyDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }
}

