/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.PositionUtils;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.comments.CommentsParser;
import com.github.javaparser.ast.comments.LineComment;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class CommentsInserter {
    private boolean doNotAssignCommentsPreceedingEmptyLines = true;
    private boolean doNotConsiderAnnotationsAsNodeStartForCodeAttribution = false;

    CommentsInserter() {
    }

    public void insertComments(CompilationUnit cu, String cuSourceCode) throws IOException {
        CommentsParser commentsParser = new CommentsParser();
        CommentsCollection allComments = commentsParser.parse(cuSourceCode);
        this.insertCommentsInCu(cu, allComments);
    }

    public boolean getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution() {
        return this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public void setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(boolean newValue) {
        this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution = newValue;
    }

    public boolean getDoNotAssignCommentsPreceedingEmptyLines() {
        return this.doNotAssignCommentsPreceedingEmptyLines;
    }

    public void setDoNotAssignCommentsPreceedingEmptyLines(boolean newValue) {
        this.doNotAssignCommentsPreceedingEmptyLines = newValue;
    }

    private void insertCommentsInCu(CompilationUnit cu, CommentsCollection commentsCollection) {
        if (commentsCollection.size() == 0) {
            return;
        }
        List<Comment> comments = commentsCollection.getAll();
        PositionUtils.sortByBeginPosition(comments);
        List<Node> children = cu.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        if (cu.getPackage() != null && (children.isEmpty() || PositionUtils.areInOrder(comments.get(0), children.get(0)))) {
            cu.setComment(comments.get(0));
            comments.remove(0);
        }
        this.insertCommentsInNode(cu, comments);
    }

    /*
     * WARNING - void declaration
     */
    private void insertCommentsInNode(Node node, List<Comment> commentsToAttribute) {
        if (commentsToAttribute.isEmpty()) {
            return;
        }
        List<Node> children = node.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        for (Node node2 : children) {
            LinkedList<Comment> commentsInsideChild = new LinkedList<Comment>();
            for (Comment c : commentsToAttribute) {
                if (!PositionUtils.nodeContains(node2, c, this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution)) continue;
                commentsInsideChild.add(c);
            }
            commentsToAttribute.removeAll(commentsInsideChild);
            this.insertCommentsInNode(node2, commentsInsideChild);
        }
        LinkedList<Object> attributedComments = new LinkedList<Object>();
        for (Comment comment : commentsToAttribute) {
            if (!comment.isLineComment()) continue;
            for (Node child : children) {
                if (child.getEnd().line != comment.getBegin().line || !this.attributeLineCommentToNodeOrChild(child, comment.asLineComment())) continue;
                attributedComments.add(comment);
            }
        }
        Object var5_7 = null;
        attributedComments = new LinkedList();
        LinkedList<Node> childrenAndComments = new LinkedList<Node>();
        childrenAndComments.addAll(children);
        childrenAndComments.addAll(commentsToAttribute);
        PositionUtils.sortByBeginPosition(childrenAndComments, this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution);
        for (Node thing : childrenAndComments) {
            void var5_8;
            if (thing instanceof Comment) {
                Comment comment = (Comment)thing;
                if (comment.isOrphan()) continue;
                Object var5_10 = null;
                continue;
            }
            if (var5_8 == null || thing.hasComment() || this.doNotAssignCommentsPreceedingEmptyLines && this.thereAreLinesBetween((Node)var5_8, thing)) continue;
            thing.setComment((Comment)var5_8);
            attributedComments.add(var5_8);
            Object var5_11 = null;
        }
        commentsToAttribute.removeAll(attributedComments);
        for (Comment c : commentsToAttribute) {
            if (!c.isOrphan()) continue;
            node.addOrphanComment(c);
        }
    }

    private boolean attributeLineCommentToNodeOrChild(Node node, LineComment lineComment) {
        if (node.getBegin().line == lineComment.getBegin().line && !node.hasComment()) {
            node.setComment(lineComment);
            return true;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        children.addAll(node.getChildrenNodes());
        PositionUtils.sortByBeginPosition(children);
        Collections.reverse(children);
        for (Node child : children) {
            if (!this.attributeLineCommentToNodeOrChild(child, lineComment)) continue;
            return true;
        }
        return false;
    }

    private boolean thereAreLinesBetween(Node a, Node b) {
        if (!PositionUtils.areInOrder(a, b)) {
            return this.thereAreLinesBetween(b, a);
        }
        int endOfA = a.getEnd().line;
        return b.getBegin().line > endOfA + 1;
    }
}

