/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.serialization;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.metamodel.BaseNodeMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.PropertyMetaModel;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.Objects;
import javax.json.stream.JsonGenerator;

public class JavaParserJsonSerializer {
    public void serialize(Node node, JsonGenerator generator) {
        Objects.requireNonNull(node);
        Log.info((String)"Serializing Node to JSON.", (Object[])new Object[0]);
        this.serialize(null, node, generator);
    }

    private void serialize(String nodeName, Node node, JsonGenerator generator) {
        Objects.requireNonNull(node);
        BaseNodeMetaModel nodeMetaModel = (BaseNodeMetaModel)JavaParserMetaModel.getNodeMetaModel(node.getClass()).orElseThrow(() -> new IllegalStateException("Unknown Node: " + node.getClass()));
        if (nodeName == null) {
            generator.writeStartObject();
        } else {
            generator.writeStartObject(nodeName);
        }
        generator.write(JsonNode.CLASS.propertyKey, node.getClass().getName());
        this.writeNonMetaProperties(node, generator);
        for (PropertyMetaModel propertyMetaModel : nodeMetaModel.getAllPropertyMetaModels()) {
            String name = propertyMetaModel.getName();
            Object value = propertyMetaModel.getValue(node);
            if (value == null) continue;
            if (propertyMetaModel.isNodeList()) {
                NodeList list = (NodeList)value;
                generator.writeStartArray(name);
                for (Object n : list) {
                    this.serialize(null, (Node)n, generator);
                }
                generator.writeEnd();
                continue;
            }
            if (propertyMetaModel.isEnumSet()) {
                EnumSet set = (EnumSet)value;
                generator.writeStartArray(name);
                for (Object n : set) {
                    generator.write(((Enum)n).name());
                }
                generator.writeEnd();
                continue;
            }
            if (propertyMetaModel.isNode()) {
                this.serialize(name, (Node)value, generator);
                continue;
            }
            generator.write(name, value.toString());
        }
        generator.writeEnd();
    }

    protected void writeNonMetaProperties(Node node, JsonGenerator generator) {
        this.writeRange(node, generator);
        this.writeTokens(node, generator);
    }

    protected void writeRange(Node node, JsonGenerator generator) {
        if (node.getRange().isPresent()) {
            Range range = (Range)node.getRange().get();
            generator.writeStartObject(JsonNode.RANGE.propertyKey);
            generator.write(JsonRange.BEGIN_LINE.propertyKey, range.begin.line);
            generator.write(JsonRange.BEGIN_COLUMN.propertyKey, range.begin.column);
            generator.write(JsonRange.END_LINE.propertyKey, range.end.line);
            generator.write(JsonRange.END_COLUMN.propertyKey, range.end.column);
            generator.writeEnd();
        }
    }

    protected void writeTokens(Node node, JsonGenerator generator) {
        if (node.getTokenRange().isPresent()) {
            TokenRange tokenRange = (TokenRange)node.getTokenRange().get();
            generator.writeStartObject(JsonNode.TOKEN_RANGE.propertyKey);
            this.writeToken(JsonTokenRange.BEGIN_TOKEN.propertyKey, tokenRange.getBegin(), generator);
            this.writeToken(JsonTokenRange.END_TOKEN.propertyKey, tokenRange.getEnd(), generator);
            generator.writeEnd();
        }
    }

    protected void writeToken(String name, JavaToken token, JsonGenerator generator) {
        generator.writeStartObject(name);
        generator.write(JsonToken.KIND.propertyKey, token.getKind());
        generator.write(JsonToken.TEXT.propertyKey, token.getText());
        generator.writeEnd();
    }

    public static enum JsonToken {
        TEXT("text"),
        KIND("kind");

        final String propertyKey;

        private JsonToken(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }

    public static enum JsonTokenRange {
        BEGIN_TOKEN("beginToken"),
        END_TOKEN("endToken");

        final String propertyKey;

        private JsonTokenRange(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }

    public static enum JsonRange {
        BEGIN_LINE("beginLine"),
        BEGIN_COLUMN("beginColumn"),
        END_LINE("endLine"),
        END_COLUMN("endColumn");

        final String propertyKey;

        private JsonRange(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }

    public static enum JsonNode {
        RANGE("range"),
        TOKEN_RANGE("tokenRange"),
        COMMENT(Utils.decapitalize((String)JavaParserMetaModel.commentMetaModel.getTypeName())),
        CLASS("!");

        final String propertyKey;

        private JsonNode(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }
}

