/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.serialization;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.metamodel.BaseNodeMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.PropertyMetaModel;
import com.github.javaparser.utils.Log;
import java.util.EnumSet;
import java.util.Objects;
import javax.json.stream.JsonGenerator;

public class JavaParserJsonSerializer {
    public static final String SERIALIZED_CLASS_KEY = "!";

    public void serialize(Node node, JsonGenerator generator) {
        Objects.requireNonNull(node);
        Log.info((String)"Serializing Node to JSON.", (Object[])new Object[0]);
        this.serialize(null, node, generator);
    }

    private void serialize(String nodeName, Node node, JsonGenerator generator) {
        Objects.requireNonNull(node);
        BaseNodeMetaModel nodeMetaModel = (BaseNodeMetaModel)JavaParserMetaModel.getNodeMetaModel(node.getClass()).orElseThrow(() -> new IllegalStateException("Unknown Node: " + node.getClass()));
        if (nodeName == null) {
            generator.writeStartObject();
        } else {
            generator.writeStartObject(nodeName);
        }
        generator.write(SERIALIZED_CLASS_KEY, node.getClass().getName());
        this.writeNonMetaProperties(node, generator);
        for (PropertyMetaModel propertyMetaModel : nodeMetaModel.getAllPropertyMetaModels()) {
            String name = propertyMetaModel.getName();
            Object value = propertyMetaModel.getValue(node);
            if (value == null) continue;
            if (propertyMetaModel.isNodeList()) {
                NodeList list = (NodeList)value;
                generator.writeStartArray(name);
                for (Object n : list) {
                    this.serialize(null, (Node)n, generator);
                }
                generator.writeEnd();
                continue;
            }
            if (propertyMetaModel.isEnumSet()) {
                EnumSet set = (EnumSet)value;
                generator.writeStartArray(name);
                for (Object n : set) {
                    generator.write(((Enum)n).name());
                }
                generator.writeEnd();
                continue;
            }
            if (propertyMetaModel.isNode()) {
                this.serialize(name, (Node)value, generator);
                continue;
            }
            generator.write(name, value.toString());
        }
        generator.writeEnd();
    }

    protected void writeNonMetaProperties(Node node, JsonGenerator generator) {
        this.writeRange(node, generator);
        this.writeTokens(node, generator);
    }

    protected void writeRange(Node node, JsonGenerator generator) {
        if (node.getRange().isPresent()) {
            Range range = (Range)node.getRange().get();
            generator.writeStartObject("range");
            generator.write("beginLine", range.begin.line);
            generator.write("beginColumn", range.begin.column);
            generator.write("endLine", range.end.line);
            generator.write("endColumn", range.end.column);
            generator.writeEnd();
        }
    }

    protected void writeTokens(Node node, JsonGenerator generator) {
        if (node.getTokenRange().isPresent()) {
            TokenRange tokenRange = (TokenRange)node.getTokenRange().get();
            generator.writeStartObject("tokenRange");
            this.writeToken("beginToken", tokenRange.getBegin(), generator);
            this.writeToken("endToken", tokenRange.getEnd(), generator);
            generator.writeEnd();
        }
    }

    protected void writeToken(String name, JavaToken token, JsonGenerator generator) {
        generator.writeStartObject(name);
        generator.write("kind", token.getKind());
        generator.write("text", token.getText());
        generator.writeEnd();
    }
}

