/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JavaParserTypeSolver
implements TypeSolver {
    private File srcDir;
    private TypeSolver parent;
    private Cache<String, Optional<CompilationUnit>> parsedFiles = CacheBuilder.newBuilder().softValues().build();
    private Cache<String, List<CompilationUnit>> parsedDirectories = CacheBuilder.newBuilder().softValues().build();
    private Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> foundTypes = CacheBuilder.newBuilder().softValues().build();

    public JavaParserTypeSolver(File srcDir) {
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            throw new IllegalStateException("SrcDir does not exist or is not a directory: " + srcDir.getAbsolutePath());
        }
        this.srcDir = srcDir;
    }

    public String toString() {
        return "JavaParserTypeSolver{srcDir=" + this.srcDir + ", parent=" + this.parent + '}';
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    private Optional<CompilationUnit> parse(File srcFile) {
        try {
            return (Optional)this.parsedFiles.get((Object)srcFile.getAbsolutePath(), () -> {
                Optional<Object> cu;
                try {
                    cu = Optional.of(JavaParser.parse((File)srcFile));
                }
                catch (FileNotFoundException e) {
                    cu = Optional.empty();
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Issue while parsing " + srcFile.getAbsolutePath(), e);
                }
                return cu;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<CompilationUnit> parseDirectory(File srcDirectory) {
        try {
            return (List)this.parsedDirectories.get((Object)srcDirectory.getAbsolutePath(), () -> {
                ArrayList<CompilationUnit> units = new ArrayList<CompilationUnit>();
                File[] files = srcDirectory.listFiles();
                if (files != null) {
                    for (File file : files) {
                        Optional<CompilationUnit> unit;
                        if (!file.getName().toLowerCase().endsWith(".java") || !(unit = this.parse(file)).isPresent()) continue;
                        units.add(unit.get());
                    }
                }
                return units;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        try {
            return (SymbolReference)this.foundTypes.get((Object)name, () -> {
                SymbolReference<ResolvedReferenceTypeDeclaration> result = this.tryToSolveTypeUncached(name);
                if (result.isSolved()) {
                    return SymbolReference.solved((ResolvedDeclaration)result.getCorrespondingDeclaration());
                }
                return result;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveTypeUncached(String name) {
        String[] nameElements = name.split("\\.");
        for (int i = nameElements.length; i > 0; --i) {
            Optional<TypeDeclaration<?>> astTypeDeclaration;
            String filePath = this.srcDir.getAbsolutePath();
            for (int j = 0; j < i; ++j) {
                filePath = filePath + "/" + nameElements[j];
            }
            filePath = filePath + ".java";
            String typeName = "";
            for (int j = i - 1; j < nameElements.length; ++j) {
                if (j != i - 1) {
                    typeName = typeName + ".";
                }
                typeName = typeName + nameElements[j];
            }
            File srcFile = new File(filePath);
            Optional<CompilationUnit> compilationUnit = this.parse(srcFile);
            if (compilationUnit.isPresent() && (astTypeDeclaration = Navigator.findType(compilationUnit.get(), typeName)).isPresent()) {
                return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration.get()));
            }
            List<CompilationUnit> compilationUnits = this.parseDirectory(srcFile.getParentFile());
            for (CompilationUnit compilationUnit2 : compilationUnits) {
                Optional<TypeDeclaration<?>> astTypeDeclaration2 = Navigator.findType(compilationUnit2, typeName);
                if (!astTypeDeclaration2.isPresent()) continue;
                return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration2.get()));
            }
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }
}

