/*
 * Decompiled with CFR 0.152.
 */
package com.jaouan.compoundlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import com.jaouan.compoundlayout.CompoundLayout;
import com.jaouan.compoundlayout.R;
import com.jaouan.compoundlayout.RadioLayout;

public class RadioLayoutGroup
extends LinearLayout {
    private int mCheckedId = -1;
    private CompoundLayout.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;

    public RadioLayoutGroup(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioLayoutGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RadioLayoutGroup, R.attr.radioButtonStyle, 0);
        int value = attributes.getResourceId(R.styleable.RadioLayoutGroup_checkedButton, -1);
        if (value != -1) {
            this.mCheckedId = value;
        }
        int index = attributes.getInt(R.styleable.RadioLayoutGroup_orientation, 1);
        this.setOrientation(index);
        attributes.recycle();
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        RadioLayout button;
        if (child instanceof RadioLayout && (button = (RadioLayout)child).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(button.getId());
        }
        super.addView(child, index, params);
    }

    public void check(int id) {
        if (id != -1 && id == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id != -1) {
            this.setCheckedStateForView(id, true);
        }
        this.setCheckedId(id);
    }

    private void setCheckedId(int id) {
        this.mCheckedId = id;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof RadioLayout) {
            ((RadioLayout)checkedView).setChecked(checked);
        }
    }

    public int getCheckedRadioLayoutId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)RadioLayoutGroup.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)RadioLayoutGroup.class.getName());
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == RadioLayoutGroup.this && child instanceof RadioLayout) {
                int id = child.getId();
                if (id == -1) {
                    id = View.generateViewId();
                    child.setId(id);
                }
                ((RadioLayout)child).setOnCheckedChangeWidgetListener(RadioLayoutGroup.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == RadioLayoutGroup.this && child instanceof RadioLayout) {
                ((RadioLayout)child).setOnCheckedChangeWidgetListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundLayout.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        @Override
        public void onCheckedChanged(CompoundLayout buttonView, boolean isChecked) {
            if (RadioLayoutGroup.this.mProtectFromCheckedChange) {
                return;
            }
            RadioLayoutGroup.this.mProtectFromCheckedChange = true;
            if (RadioLayoutGroup.this.mCheckedId != -1) {
                RadioLayoutGroup.this.setCheckedStateForView(RadioLayoutGroup.this.mCheckedId, false);
            }
            RadioLayoutGroup.this.mProtectFromCheckedChange = false;
            int id = buttonView.getId();
            RadioLayoutGroup.this.setCheckedId(id);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioLayoutGroup var1, int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

