/*
 * Decompiled with CFR 0.152.
 */
package at.grabner.circleprogress;

import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import at.grabner.circleprogress.AnimationHandler;
import at.grabner.circleprogress.AnimationMsg;
import at.grabner.circleprogress.AnimationState;
import at.grabner.circleprogress.AnimationStateChangedListener;
import at.grabner.circleprogress.BarStartEndLine;
import at.grabner.circleprogress.ColorUtils;
import at.grabner.circleprogress.Direction;
import at.grabner.circleprogress.R;
import at.grabner.circleprogress.StrokeCap;
import at.grabner.circleprogress.TextMode;
import at.grabner.circleprogress.UnitPosition;
import java.text.DecimalFormat;

public class CircleProgressView
extends View {
    private final int mBarColorStandard = -16738680;
    protected int mLayoutHeight = 0;
    protected int mLayoutWidth = 0;
    protected RectF mCircleBounds = new RectF();
    protected RectF mInnerCircleBound = new RectF();
    protected PointF mCenter;
    protected RectF mOuterTextBounds = new RectF();
    protected RectF mActualTextBounds = new RectF();
    protected RectF mUnitBounds = new RectF();
    protected RectF mCircleOuterContour = new RectF();
    protected RectF mCircleInnerContour = new RectF();
    Direction mDirection = Direction.CW;
    float mCurrentValue = 0.0f;
    float mValueTo = 0.0f;
    float mValueFrom = 0.0f;
    float mMaxValue = 100.0f;
    float mMinValueAllowed = 0.0f;
    float mMaxValueAllowed = -1.0f;
    float mSpinningBarLengthCurrent = 0.0f;
    float mSpinningBarLengthOrig = 42.0f;
    float mCurrentSpinnerDegreeValue = 0.0f;
    float mSpinSpeed = 2.8f;
    boolean mSpin = false;
    double mAnimationDuration = 900.0;
    int mFrameDelayMillis = 10;
    boolean mDrawBarWhileSpinning;
    AnimationHandler mAnimationHandler = new AnimationHandler(this);
    AnimationState mAnimationState = AnimationState.IDLE;
    AnimationStateChangedListener mAnimationStateChangedListener;
    private int mBarWidth = 40;
    private int mRimWidth = 40;
    private int mStartAngle = 270;
    private float mOuterContourSize = 1.0f;
    private float mInnerContourSize = 1.0f;
    private int mBarStartEndLineWidth = 0;
    private BarStartEndLine mBarStartEndLine = BarStartEndLine.NONE;
    private int mBarStartEndLineColor = -1442840576;
    private float mBarStartEndLineSweep = 10.0f;
    private int mUnitTextSize = 10;
    private int mTextSize = 10;
    private float mTextScale = 1.0f;
    private float mUnitScale = 1.0f;
    private int mOuterContourColor = -1442840576;
    private int mInnerContourColor = -1442840576;
    private int mSpinnerColor = -16738680;
    private int mBackgroundCircleColor = 0;
    private int mRimColor = -1434201911;
    private int mTextColor = -16777216;
    private int mUnitColor = -16777216;
    private boolean mIsAutoColorEnabled = false;
    private int[] mBarColors = new int[]{-16738680};
    private Paint.Cap mBarStrokeCap = Paint.Cap.BUTT;
    private Paint.Cap mSpinnerStrokeCap = Paint.Cap.BUTT;
    private Paint mBarPaint = new Paint();
    private Paint mShaderlessBarPaint;
    private Paint mBarSpinnerPaint = new Paint();
    private Paint mBarStartEndLinePaint = new Paint();
    private Paint mBackgroundCirclePaint = new Paint();
    private Paint mRimPaint = new Paint();
    private Paint mTextPaint = new Paint();
    private Paint mUnitTextPaint = new Paint();
    private Paint mOuterContourPaint = new Paint();
    private Paint mInnerContourPaint = new Paint();
    private String mText = "";
    private int mTextLength;
    private String mUnit = "";
    private UnitPosition mUnitPosition = UnitPosition.RIGHT_TOP;
    private TextMode mTextMode = TextMode.PERCENT;
    private boolean mIsAutoTextSize;
    private boolean mShowUnit = false;
    private Bitmap mClippingBitmap;
    private Paint mMaskPaint;
    private float mRelativeUniteSize = 1.0f;
    private boolean mSeekModeEnabled = false;
    private boolean mShowTextWhileSpinning = false;
    private boolean mShowBlock = false;
    private int mBlockCount = 18;
    private float mBlockScale = 0.9f;
    private float mBlockDegree = 360 / this.mBlockCount;
    private float mBlockScaleDegree = this.mBlockDegree * this.mBlockScale;
    private boolean mRoundToBlock = false;
    private boolean mRoundToWholeNumber = false;
    private int mTouchEventCount;
    private OnProgressChangedListener onProgressChangedListener;
    private float previousProgressChangedValue;
    private DecimalFormat decimalFormat = new DecimalFormat("0");
    private Typeface textTypeface;
    private Typeface unitTextTypeface;

    public CircleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView);
        CircleProgressView circleProgressView = this;
        circleProgressView.setBarWidth((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_barWidth, (float)circleProgressView.mBarWidth));
        circleProgressView.setRimWidth((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_rimWidth, (float)circleProgressView.mRimWidth));
        circleProgressView.setSpinSpeed((int)typedArray.getFloat(R.styleable.CircleProgressView_cpv_spinSpeed, circleProgressView.mSpinSpeed));
        circleProgressView.setSpin(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_spin, circleProgressView.mSpin));
        circleProgressView.setDirection(Direction.values()[typedArray.getInt(R.styleable.CircleProgressView_cpv_direction, 0)]);
        float f = typedArray.getFloat(R.styleable.CircleProgressView_cpv_value, circleProgressView.mCurrentValue);
        circleProgressView.setValue(f);
        circleProgressView.mCurrentValue = f;
        circleProgressView.mBarColors = typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor1) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor2) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor3) ? new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor1, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor2, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor3, -16738680)} : (typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor1) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor2) ? new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor1, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor2, -16738680)} : (typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor1) ? new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor1, -16738680)} : new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680)}));
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_barStrokeCap)) {
            circleProgressView.setBarStrokeCap(StrokeCap.values()[typedArray.getInt((int)R.styleable.CircleProgressView_cpv_barStrokeCap, (int)0)].paintCap);
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_barStartEndLineWidth) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barStartEndLine)) {
            circleProgressView.setBarStartEndLine((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_barStartEndLineWidth, 0.0f), BarStartEndLine.values()[typedArray.getInt(R.styleable.CircleProgressView_cpv_barStartEndLine, 3)], typedArray.getColor(R.styleable.CircleProgressView_cpv_barStartEndLineColor, circleProgressView.mBarStartEndLineColor), typedArray.getFloat(R.styleable.CircleProgressView_cpv_barStartEndLineSweep, circleProgressView.mBarStartEndLineSweep));
        }
        circleProgressView.setSpinBarColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_spinColor, circleProgressView.mSpinnerColor));
        circleProgressView.setSpinningBarLength(typedArray.getFloat(R.styleable.CircleProgressView_cpv_spinBarLength, circleProgressView.mSpinningBarLengthOrig));
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textSize)) {
            circleProgressView.setTextSize((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_textSize, (float)circleProgressView.mTextSize));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_unitSize)) {
            circleProgressView.setUnitSize((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_unitSize, (float)circleProgressView.mUnitTextSize));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textColor)) {
            circleProgressView.setTextColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_textColor, circleProgressView.mTextColor));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_unitColor)) {
            circleProgressView.setUnitColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_unitColor, circleProgressView.mUnitColor));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_autoTextColor)) {
            circleProgressView.setTextColorAuto(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_autoTextColor, circleProgressView.mIsAutoColorEnabled));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_autoTextSize)) {
            circleProgressView.setAutoTextSize(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_autoTextSize, circleProgressView.mIsAutoTextSize));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textMode)) {
            circleProgressView.setTextMode(TextMode.values()[typedArray.getInt(R.styleable.CircleProgressView_cpv_textMode, 0)]);
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_unitPosition)) {
            circleProgressView.setUnitPosition(UnitPosition.values()[typedArray.getInt(R.styleable.CircleProgressView_cpv_unitPosition, 3)]);
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_text)) {
            circleProgressView.setText(typedArray.getString(R.styleable.CircleProgressView_cpv_text));
        }
        circleProgressView.setUnitToTextScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_unitToTextScale, 1.0f));
        circleProgressView.setRimColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_rimColor, circleProgressView.mRimColor));
        circleProgressView.setFillCircleColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_fillColor, circleProgressView.mBackgroundCircleColor));
        circleProgressView.setOuterContourColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_outerContourColor, circleProgressView.mOuterContourColor));
        circleProgressView.setOuterContourSize(typedArray.getDimension(R.styleable.CircleProgressView_cpv_outerContourSize, circleProgressView.mOuterContourSize));
        circleProgressView.setInnerContourColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_innerContourColor, circleProgressView.mInnerContourColor));
        circleProgressView.setInnerContourSize(typedArray.getDimension(R.styleable.CircleProgressView_cpv_innerContourSize, circleProgressView.mInnerContourSize));
        circleProgressView.setMaxValue(typedArray.getFloat(R.styleable.CircleProgressView_cpv_maxValue, circleProgressView.mMaxValue));
        circleProgressView.setMinValueAllowed(typedArray.getFloat(R.styleable.CircleProgressView_cpv_minValueAllowed, circleProgressView.mMinValueAllowed));
        circleProgressView.setMaxValueAllowed(typedArray.getFloat(R.styleable.CircleProgressView_cpv_maxValueAllowed, circleProgressView.mMaxValueAllowed));
        circleProgressView.setRoundToBlock(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_roundToBlock, circleProgressView.mRoundToBlock));
        circleProgressView.setRoundToWholeNumber(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_roundToWholeNumber, circleProgressView.mRoundToWholeNumber));
        circleProgressView.setUnit(typedArray.getString(R.styleable.CircleProgressView_cpv_unit));
        circleProgressView.setUnitVisible(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_showUnit, circleProgressView.mShowUnit));
        circleProgressView.setTextScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_textScale, circleProgressView.mTextScale));
        circleProgressView.setUnitScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_unitScale, circleProgressView.mUnitScale));
        circleProgressView.setSeekModeEnabled(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_seekMode, circleProgressView.mSeekModeEnabled));
        circleProgressView.setStartAngle(typedArray.getInt(R.styleable.CircleProgressView_cpv_startAngle, circleProgressView.mStartAngle));
        circleProgressView.setShowTextWhileSpinning(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_showTextInSpinningMode, circleProgressView.mShowTextWhileSpinning));
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_blockCount)) {
            circleProgressView.setBlockCount(typedArray.getInt(R.styleable.CircleProgressView_cpv_blockCount, 1));
            circleProgressView.setBlockScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_blockScale, 0.9f));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textTypeface)) {
            try {
                circleProgressView.textTypeface = Typeface.createFromAsset((AssetManager)circleProgressView.getContext().getAssets(), (String)typedArray.getString(R.styleable.CircleProgressView_cpv_textTypeface));
            }
            catch (Exception exception) {}
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_unitTypeface)) {
            try {
                circleProgressView.unitTextTypeface = Typeface.createFromAsset((AssetManager)circleProgressView.getContext().getAssets(), (String)typedArray.getString(R.styleable.CircleProgressView_cpv_unitTypeface));
            }
            catch (Exception exception) {}
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_decimalFormat)) {
            try {
                String string = typedArray.getString(R.styleable.CircleProgressView_cpv_decimalFormat);
                if (string != null) {
                    circleProgressView.decimalFormat = new DecimalFormat(string);
                }
            }
            catch (Exception exception) {
                Log.w((String)"CircleView", (String)exception.getMessage());
            }
        }
        typedArray.recycle();
        if (!this.isInEditMode() && Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        this.mMaskPaint = new Paint(1);
        this.mMaskPaint.setFilterBitmap(false);
        this.mMaskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.setupPaints();
        if (this.mSpin) {
            this.spin();
        }
    }

    private static float calcTextSizeForRect(String _text, Paint _textPaint, RectF _rectBounds) {
        Matrix matrix = new Matrix();
        Rect textBoundsTmp = new Rect();
        String text = _text.replace('1', '0');
        _textPaint.getTextBounds(text, 0, text.length(), textBoundsTmp);
        RectF textBoundsTmpF = new RectF(textBoundsTmp);
        matrix.setRectToRect(textBoundsTmpF, _rectBounds, Matrix.ScaleToFit.CENTER);
        float[] values = new float[9];
        matrix.getValues(values);
        return _textPaint.getTextSize() * values[0];
    }

    private static float normalizeAngle(float _angle) {
        return (_angle % 360.0f + 360.0f) % 360.0f;
    }

    public static double calcRotationAngleInDegrees(PointF centerPt, PointF targetPt) {
        double d;
        double angle = Math.toDegrees(Math.atan2(targetPt.y - centerPt.y, targetPt.x - centerPt.x));
        if (d < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public BarStartEndLine getBarStartEndLine() {
        return this.mBarStartEndLine;
    }

    public void setBarStartEndLine(int _barWidth, BarStartEndLine _barStartEndLine, @ColorInt int _lineColor, float _sweepWidth) {
        this.mBarStartEndLineWidth = _barWidth;
        this.mBarStartEndLine = _barStartEndLine;
        this.mBarStartEndLineColor = _lineColor;
        this.mBarStartEndLineSweep = _sweepWidth;
    }

    public int[] getBarColors() {
        return this.mBarColors;
    }

    public Paint.Cap getBarStrokeCap() {
        return this.mBarStrokeCap;
    }

    public void setBarStrokeCap(Paint.Cap _barStrokeCap) {
        this.mBarStrokeCap = _barStrokeCap;
        this.mBarPaint.setStrokeCap(_barStrokeCap);
        if (this.mBarStrokeCap != Paint.Cap.BUTT) {
            this.mShaderlessBarPaint = new Paint(this.mBarPaint);
            this.mShaderlessBarPaint.setShader(null);
            this.mShaderlessBarPaint.setColor(this.mBarColors[0]);
        }
    }

    public int getBarWidth() {
        return this.mBarWidth;
    }

    public void setBarWidth(@IntRange(from=0L) int barWidth) {
        this.mBarWidth = barWidth;
        this.mBarPaint.setStrokeWidth((float)barWidth);
        this.mBarSpinnerPaint.setStrokeWidth((float)barWidth);
    }

    public int getBlockCount() {
        return this.mBlockCount;
    }

    public void setBlockCount(int blockCount) {
        if (blockCount > 1) {
            this.mShowBlock = true;
            this.mBlockCount = blockCount;
            this.mBlockDegree = 360.0f / (float)blockCount;
            this.mBlockScaleDegree = this.mBlockDegree * this.mBlockScale;
            return;
        }
        this.mShowBlock = false;
    }

    public void setRoundToBlock(boolean _roundToBlock) {
        this.mRoundToBlock = _roundToBlock;
    }

    public boolean getRoundToBlock() {
        return this.mRoundToBlock;
    }

    public void setRoundToWholeNumber(boolean roundToWholeNumber) {
        this.mRoundToWholeNumber = roundToWholeNumber;
    }

    public boolean getRoundToWholeNumber() {
        return this.mRoundToWholeNumber;
    }

    public float getBlockScale() {
        return this.mBlockScale;
    }

    public void setBlockScale(@FloatRange(from=0.0, to=1.0) float blockScale) {
        if (blockScale >= 0.0f && blockScale <= 1.0f) {
            this.mBlockScale = blockScale;
            this.mBlockScaleDegree = this.mBlockDegree * blockScale;
        }
    }

    public int getOuterContourColor() {
        return this.mOuterContourColor;
    }

    public void setOuterContourColor(@ColorInt int _contourColor) {
        this.mOuterContourColor = _contourColor;
        this.mOuterContourPaint.setColor(_contourColor);
    }

    public float getOuterContourSize() {
        return this.mOuterContourSize;
    }

    public void setOuterContourSize(@FloatRange(from=0.0) float _contourSize) {
        this.mOuterContourSize = _contourSize;
        this.mOuterContourPaint.setStrokeWidth(_contourSize);
    }

    public int getInnerContourColor() {
        return this.mInnerContourColor;
    }

    public void setInnerContourColor(@ColorInt int _contourColor) {
        this.mInnerContourColor = _contourColor;
        this.mInnerContourPaint.setColor(_contourColor);
    }

    public float getInnerContourSize() {
        return this.mInnerContourSize;
    }

    public void setInnerContourSize(@FloatRange(from=0.0) float _contourSize) {
        this.mInnerContourSize = _contourSize;
        this.mInnerContourPaint.setStrokeWidth(_contourSize);
    }

    public int getDelayMillis() {
        return this.mFrameDelayMillis;
    }

    public void setDelayMillis(int delayMillis) {
        this.mFrameDelayMillis = delayMillis;
    }

    public int getFillColor() {
        return this.mBackgroundCirclePaint.getColor();
    }

    public float getCurrentValue() {
        return this.mCurrentValue;
    }

    public float getMinValueAllowed() {
        return this.mMinValueAllowed;
    }

    public float getMaxValueAllowed() {
        return this.mMaxValueAllowed;
    }

    public float getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(@FloatRange(from=0.0) float _maxValue) {
        this.mMaxValue = _maxValue;
    }

    public void setMinValueAllowed(@FloatRange(from=0.0) float _minValueAllowed) {
        this.mMinValueAllowed = _minValueAllowed;
    }

    public void setMaxValueAllowed(@FloatRange(from=0.0) float _maxValueAllowed) {
        this.mMaxValueAllowed = _maxValueAllowed;
    }

    public float getRelativeUniteSize() {
        return this.mRelativeUniteSize;
    }

    public int getRimColor() {
        return this.mRimColor;
    }

    public void setRimColor(@ColorInt int rimColor) {
        this.mRimColor = rimColor;
        this.mRimPaint.setColor(rimColor);
    }

    public Shader getRimShader() {
        return this.mRimPaint.getShader();
    }

    public void setRimShader(Shader shader) {
        this.mRimPaint.setShader(shader);
    }

    public int getRimWidth() {
        return this.mRimWidth;
    }

    public void setRimWidth(@IntRange(from=0L) int rimWidth) {
        this.mRimWidth = rimWidth;
        this.mRimPaint.setStrokeWidth((float)rimWidth);
    }

    public float getSpinSpeed() {
        return this.mSpinSpeed;
    }

    public void setSpinSpeed(float spinSpeed) {
        this.mSpinSpeed = spinSpeed;
    }

    public Paint.Cap getSpinnerStrokeCap() {
        return this.mSpinnerStrokeCap;
    }

    public void setSpinnerStrokeCap(Paint.Cap _spinnerStrokeCap) {
        this.mSpinnerStrokeCap = _spinnerStrokeCap;
        this.mBarSpinnerPaint.setStrokeCap(_spinnerStrokeCap);
    }

    public int getStartAngle() {
        return this.mStartAngle;
    }

    public void setStartAngle(@IntRange(from=0L, to=360L) int _startAngle) {
        this.mStartAngle = (int)CircleProgressView.normalizeAngle(_startAngle);
    }

    public int calcTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(textColor);
    }

    public float getTextScale() {
        return this.mTextScale;
    }

    public void setTextScale(@FloatRange(from=0.0) float _textScale) {
        this.mTextScale = _textScale;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(@IntRange(from=0L) int textSize) {
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextSize = textSize;
        this.mIsAutoTextSize = false;
    }

    public String getUnit() {
        return this.mUnit;
    }

    public void setUnit(String _unit) {
        this.mUnit = _unit == null ? "" : _unit;
        this.invalidate();
    }

    public float getUnitScale() {
        return this.mUnitScale;
    }

    public void setUnitScale(@FloatRange(from=0.0) float _unitScale) {
        this.mUnitScale = _unitScale;
    }

    public int getUnitSize() {
        return this.mUnitTextSize;
    }

    public void setUnitSize(@IntRange(from=0L) int unitSize) {
        this.mUnitTextSize = unitSize;
        this.mUnitTextPaint.setTextSize((float)unitSize);
    }

    public boolean isAutoTextSize() {
        return this.mIsAutoTextSize;
    }

    public void setAutoTextSize(boolean _autoTextSize) {
        this.mIsAutoTextSize = _autoTextSize;
    }

    public boolean isSeekModeEnabled() {
        return this.mSeekModeEnabled;
    }

    public void setSeekModeEnabled(boolean _seekModeEnabled) {
        this.mSeekModeEnabled = _seekModeEnabled;
    }

    public boolean isShowBlock() {
        return this.mShowBlock;
    }

    public void setShowBlock(boolean showBlock) {
        this.mShowBlock = showBlock;
    }

    public boolean isShowTextWhileSpinning() {
        return this.mShowTextWhileSpinning;
    }

    public void setShowTextWhileSpinning(boolean shouldDrawTextWhileSpinning) {
        this.mShowTextWhileSpinning = shouldDrawTextWhileSpinning;
    }

    public boolean isUnitVisible() {
        return this.mShowUnit;
    }

    public void setUnitVisible(boolean _showUnit) {
        if (_showUnit != this.mShowUnit) {
            this.mShowUnit = _showUnit;
            this.triggerReCalcTextSizesAndPositions();
        }
    }

    public void setBarColor(int ... barColors) {
        this.mBarColors = barColors;
        this.setupBarPaint();
    }

    @TargetApi(value=11)
    public void setClippingBitmap(Bitmap _clippingBitmap) {
        this.mClippingBitmap = this.getWidth() > 0 && this.getHeight() > 0 ? Bitmap.createScaledBitmap((Bitmap)_clippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false) : _clippingBitmap;
        if (this.mClippingBitmap == null) {
            this.setLayerType(2, null);
            return;
        }
        this.setLayerType(1, null);
    }

    public void setFillCircleColor(@ColorInt int circleColor) {
        this.mBackgroundCircleColor = circleColor;
        this.mBackgroundCirclePaint.setColor(circleColor);
    }

    public void setOnAnimationStateChangedListener(AnimationStateChangedListener _animationStateChangedListener) {
        this.mAnimationStateChangedListener = _animationStateChangedListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener listener) {
        this.onProgressChangedListener = listener;
    }

    public void setSpinBarColor(@ColorInt int _color) {
        this.mSpinnerColor = _color;
        this.mBarSpinnerPaint.setColor(this.mSpinnerColor);
    }

    public void setSpinningBarLength(@FloatRange(from=0.0) float barLength) {
        this.mSpinningBarLengthCurrent = this.mSpinningBarLengthOrig = barLength;
    }

    public void setText(String text) {
        this.mText = text != null ? text : "";
        this.invalidate();
    }

    public void setTextColorAuto(boolean isEnabled) {
        this.mIsAutoColorEnabled = isEnabled;
    }

    public void setTextMode(TextMode _textValue) {
        this.mTextMode = _textValue;
    }

    public void setTextTypeface(Typeface typeface) {
        this.mTextPaint.setTypeface(typeface);
    }

    public void setUnitColor(@ColorInt int unitColor) {
        this.mUnitColor = unitColor;
        this.mUnitTextPaint.setColor(unitColor);
        this.mIsAutoColorEnabled = false;
    }

    public void setUnitPosition(UnitPosition _unitPosition) {
        this.mUnitPosition = _unitPosition;
        this.triggerReCalcTextSizesAndPositions();
    }

    public void setUnitTextTypeface(Typeface typeface) {
        this.mUnitTextPaint.setTypeface(typeface);
    }

    public void setUnitToTextScale(@FloatRange(from=0.0) float _relativeUniteSize) {
        this.mRelativeUniteSize = _relativeUniteSize;
        this.triggerReCalcTextSizesAndPositions();
    }

    public void setDirection(Direction direction) {
        this.mDirection = direction;
    }

    public void setValue(float _value) {
        if (this.mShowBlock && this.mRoundToBlock) {
            float value_per_block = this.mMaxValue / (float)this.mBlockCount;
            _value = (float)Math.round(_value / value_per_block) * value_per_block;
        } else if (this.mRoundToWholeNumber) {
            _value = Math.round(_value);
        }
        _value = Math.max(this.mMinValueAllowed, _value);
        if (this.mMaxValueAllowed >= 0.0f) {
            _value = Math.min(this.mMaxValueAllowed, _value);
        }
        Message msg = new Message();
        new Message().what = AnimationMsg.SET_VALUE$48cb079c - 1;
        msg.obj = new float[]{_value, _value};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_value);
    }

    public void setValueAnimated(float _valueTo) {
        this.setValueAnimated(_valueTo, 1200L);
    }

    public void setValueAnimated(float _valueTo, long _animationDuration) {
        this.setValueAnimated(this.mCurrentValue, _valueTo, _animationDuration);
    }

    public void setValueAnimated(float _valueFrom, float _valueTo, long _animationDuration) {
        if (this.mShowBlock && this.mRoundToBlock) {
            float value_per_block = this.mMaxValue / (float)this.mBlockCount;
            _valueTo = (float)Math.round(_valueTo / value_per_block) * value_per_block;
        } else if (this.mRoundToWholeNumber) {
            _valueTo = Math.round(_valueTo);
        }
        _valueTo = Math.max(this.mMinValueAllowed, _valueTo);
        if (this.mMaxValueAllowed >= 0.0f) {
            _valueTo = Math.min(this.mMaxValueAllowed, _valueTo);
        }
        this.mAnimationDuration = _animationDuration;
        Message msg = new Message();
        new Message().what = AnimationMsg.SET_VALUE_ANIMATED$48cb079c - 1;
        msg.obj = new float[]{_valueFrom, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_valueTo);
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            throw new IllegalArgumentException("decimalFormat must not be null!");
        }
        this.decimalFormat = decimalFormat;
    }

    public void setValueInterpolator(TimeInterpolator interpolator) {
        this.mAnimationHandler.setValueInterpolator(interpolator);
    }

    public void setLengthChangeInterpolator(TimeInterpolator interpolator) {
        this.mAnimationHandler.setLengthChangeInterpolator(interpolator);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heightWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        int size = widthWithoutPadding > heightWithoutPadding ? heightWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mLayoutWidth = w;
        this.mLayoutHeight = h;
        CircleProgressView circleProgressView = this;
        int n = Math.min(circleProgressView.mLayoutWidth, circleProgressView.mLayoutHeight);
        int n2 = circleProgressView.mLayoutWidth - n;
        int n3 = circleProgressView.mLayoutHeight - n;
        float f = circleProgressView.getPaddingTop() + n3 / 2;
        float f2 = circleProgressView.getPaddingBottom() + n3 / 2;
        float f3 = circleProgressView.getPaddingLeft() + n2 / 2;
        float f4 = circleProgressView.getPaddingRight() + n2 / 2;
        int n4 = circleProgressView.getWidth();
        int n5 = circleProgressView.getHeight();
        float f5 = (float)circleProgressView.mBarWidth / 2.0f > (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mOuterContourSize ? (float)circleProgressView.mBarWidth / 2.0f : (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mOuterContourSize;
        circleProgressView.mCircleBounds = new RectF(f3 + f5, f + f5, (float)n4 - f4 - f5, (float)n5 - f2 - f5);
        circleProgressView.mInnerCircleBound = new RectF(f3 + (float)circleProgressView.mBarWidth, f + (float)circleProgressView.mBarWidth, (float)n4 - f4 - (float)circleProgressView.mBarWidth, (float)n5 - f2 - (float)circleProgressView.mBarWidth);
        circleProgressView.mOuterTextBounds = circleProgressView.getInnerCircleRect(circleProgressView.mCircleBounds);
        circleProgressView.mCircleInnerContour = new RectF(circleProgressView.mCircleBounds.left + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mInnerContourSize / 2.0f, circleProgressView.mCircleBounds.top + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mInnerContourSize / 2.0f, circleProgressView.mCircleBounds.right - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mInnerContourSize / 2.0f, circleProgressView.mCircleBounds.bottom - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mInnerContourSize / 2.0f);
        circleProgressView.mCircleOuterContour = new RectF(circleProgressView.mCircleBounds.left - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mOuterContourSize / 2.0f, circleProgressView.mCircleBounds.top - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mOuterContourSize / 2.0f, circleProgressView.mCircleBounds.right + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mOuterContourSize / 2.0f, circleProgressView.mCircleBounds.bottom + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mOuterContourSize / 2.0f);
        circleProgressView.mCenter = new PointF(circleProgressView.mCircleBounds.centerX(), circleProgressView.mCircleBounds.centerY());
        this.setupBarPaint();
        if (this.mClippingBitmap != null) {
            this.mClippingBitmap = Bitmap.createScaledBitmap((Bitmap)this.mClippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false);
        }
        this.invalidate();
    }

    private RectF getInnerCircleRect(RectF _circleBounds) {
        double width = (double)(_circleBounds.width() - (float)Math.max(this.mBarWidth, this.mRimWidth) - this.mOuterContourSize - this.mInnerContourSize) / 2.0 * Math.sqrt(2.0);
        float widthDelta = (_circleBounds.width() - (float)width) / 2.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (this.isUnitVisible()) {
            switch (this.mUnitPosition) {
                case TOP: 
                case BOTTOM: {
                    scaleX = 1.1f;
                    scaleY = 0.88f;
                    break;
                }
                case LEFT_TOP: 
                case RIGHT_TOP: 
                case LEFT_BOTTOM: 
                case RIGHT_BOTTOM: {
                    scaleX = 0.77f;
                    scaleY = 1.33f;
                }
            }
        }
        return new RectF(_circleBounds.left + widthDelta * scaleX, _circleBounds.top + widthDelta * scaleY, _circleBounds.right - widthDelta * scaleX, _circleBounds.bottom - widthDelta * scaleY);
    }

    private void triggerOnProgressChanged(float value) {
        if (this.onProgressChangedListener != null && value != this.previousProgressChangedValue) {
            this.onProgressChangedListener.onProgressChanged(value);
            this.previousProgressChangedValue = value;
        }
    }

    private void triggerReCalcTextSizesAndPositions() {
        this.mTextLength = -1;
        this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
        this.invalidate();
    }

    private int calcTextColor(double value) {
        if (this.mBarColors.length > 1) {
            double percent = (double)(1.0f / this.getMaxValue()) * value;
            int low = (int)Math.floor((double)(this.mBarColors.length - 1) * percent);
            int high = low + 1;
            if (low < 0) {
                low = 0;
                high = 1;
            } else if (high >= this.mBarColors.length) {
                low = this.mBarColors.length - 2;
                high = this.mBarColors.length - 1;
            }
            return ColorUtils.getRGBGradient(this.mBarColors[low], this.mBarColors[high], (float)(1.0 - (double)(this.mBarColors.length - 1) * percent % 1.0));
        }
        if (this.mBarColors.length == 1) {
            return this.mBarColors[0];
        }
        return -16777216;
    }

    private void setTextSizeAndTextBoundsWithFixedTextSize(String text) {
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mActualTextBounds = CircleProgressView.calcTextBounds(text, this.mTextPaint, this.mCircleBounds);
    }

    private static RectF calcTextBounds(String _text, Paint _textPaint, RectF _textBounds) {
        Rect textBoundsTmp = new Rect();
        _textPaint.getTextBounds(_text, 0, _text.length(), textBoundsTmp);
        float width = textBoundsTmp.left + textBoundsTmp.width();
        float height = (float)textBoundsTmp.bottom + (float)textBoundsTmp.height() * 0.93f;
        RectF textRect = new RectF();
        new RectF().left = _textBounds.left + (_textBounds.width() - width) / 2.0f;
        textRect.top = _textBounds.top + (_textBounds.height() - height) / 2.0f;
        textRect.right = textRect.left + width;
        textRect.bottom = textRect.top + height;
        return textRect;
    }

    private void setupBarPaint() {
        if (this.mBarColors.length > 1) {
            this.mBarPaint.setShader((Shader)new SweepGradient(this.mCircleBounds.centerX(), this.mCircleBounds.centerY(), this.mBarColors, null));
            Matrix matrix = new Matrix();
            this.mBarPaint.getShader().getLocalMatrix(matrix);
            matrix.postTranslate(-this.mCircleBounds.centerX(), -this.mCircleBounds.centerY());
            matrix.postRotate((float)this.mStartAngle);
            matrix.postTranslate(this.mCircleBounds.centerX(), this.mCircleBounds.centerY());
            this.mBarPaint.getShader().setLocalMatrix(matrix);
            this.mBarPaint.setColor(this.mBarColors[0]);
        } else if (this.mBarColors.length == 1) {
            this.mBarPaint.setColor(this.mBarColors[0]);
            this.mBarPaint.setShader(null);
        } else {
            this.mBarPaint.setColor(-16738680);
            this.mBarPaint.setShader(null);
        }
        this.mBarPaint.setAntiAlias(true);
        this.mBarPaint.setStrokeCap(this.mBarStrokeCap);
        this.mBarPaint.setStyle(Paint.Style.STROKE);
        this.mBarPaint.setStrokeWidth((float)this.mBarWidth);
        if (this.mBarStrokeCap != Paint.Cap.BUTT) {
            this.mShaderlessBarPaint = new Paint(this.mBarPaint);
            this.mShaderlessBarPaint.setShader(null);
            this.mShaderlessBarPaint.setColor(this.mBarColors[0]);
        }
    }

    public void setupPaints() {
        this.setupBarPaint();
        CircleProgressView circleProgressView = this;
        circleProgressView.mBarSpinnerPaint.setAntiAlias(true);
        circleProgressView.mBarSpinnerPaint.setStrokeCap(circleProgressView.mSpinnerStrokeCap);
        circleProgressView.mBarSpinnerPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mBarSpinnerPaint.setStrokeWidth((float)circleProgressView.mBarWidth);
        circleProgressView.mBarSpinnerPaint.setColor(circleProgressView.mSpinnerColor);
        circleProgressView = this;
        circleProgressView.mOuterContourPaint.setColor(circleProgressView.mOuterContourColor);
        circleProgressView.mOuterContourPaint.setAntiAlias(true);
        circleProgressView.mOuterContourPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mOuterContourPaint.setStrokeWidth(circleProgressView.mOuterContourSize);
        circleProgressView = this;
        circleProgressView.mInnerContourPaint.setColor(circleProgressView.mInnerContourColor);
        circleProgressView.mInnerContourPaint.setAntiAlias(true);
        circleProgressView.mInnerContourPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mInnerContourPaint.setStrokeWidth(circleProgressView.mInnerContourSize);
        circleProgressView = this;
        circleProgressView.mUnitTextPaint.setStyle(Paint.Style.FILL);
        circleProgressView.mUnitTextPaint.setAntiAlias(true);
        if (circleProgressView.unitTextTypeface != null) {
            circleProgressView.mUnitTextPaint.setTypeface(circleProgressView.unitTextTypeface);
        }
        circleProgressView = this;
        circleProgressView.mTextPaint.setSubpixelText(true);
        circleProgressView.mTextPaint.setLinearText(true);
        circleProgressView.mTextPaint.setTypeface(Typeface.MONOSPACE);
        circleProgressView.mTextPaint.setColor(circleProgressView.mTextColor);
        circleProgressView.mTextPaint.setStyle(Paint.Style.FILL);
        circleProgressView.mTextPaint.setAntiAlias(true);
        circleProgressView.mTextPaint.setTextSize((float)circleProgressView.mTextSize);
        if (circleProgressView.textTypeface != null) {
            circleProgressView.mTextPaint.setTypeface(circleProgressView.textTypeface);
        } else {
            circleProgressView.mTextPaint.setTypeface(Typeface.MONOSPACE);
        }
        circleProgressView = this;
        circleProgressView.mBackgroundCirclePaint.setColor(circleProgressView.mBackgroundCircleColor);
        circleProgressView.mBackgroundCirclePaint.setAntiAlias(true);
        circleProgressView.mBackgroundCirclePaint.setStyle(Paint.Style.FILL);
        circleProgressView = this;
        circleProgressView.mRimPaint.setColor(circleProgressView.mRimColor);
        circleProgressView.mRimPaint.setAntiAlias(true);
        circleProgressView.mRimPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mRimPaint.setStrokeWidth((float)circleProgressView.mRimWidth);
        circleProgressView = this;
        circleProgressView.mBarStartEndLinePaint.setColor(circleProgressView.mBarStartEndLineColor);
        circleProgressView.mBarStartEndLinePaint.setAntiAlias(true);
        circleProgressView.mBarStartEndLinePaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mBarStartEndLinePaint.setStrokeWidth((float)circleProgressView.mBarStartEndLineWidth);
    }

    protected void onDraw(Canvas canvas) {
        float degrees;
        block60: {
            CircleProgressView circleProgressView;
            float f;
            float f2;
            float f3;
            float f4;
            String string;
            float f5;
            float f6;
            block61: {
                float f7;
                block62: {
                    block59: {
                        super.onDraw(canvas);
                        degrees = 360.0f / this.mMaxValue * this.mCurrentValue;
                        if (this.mBackgroundCircleColor != 0) {
                            canvas.drawArc(this.mInnerCircleBound, 360.0f, 360.0f, false, this.mBackgroundCirclePaint);
                        }
                        if (this.mRimWidth > 0) {
                            if (!this.mShowBlock) {
                                canvas.drawArc(this.mCircleBounds, 360.0f, 360.0f, false, this.mRimPaint);
                            } else {
                                this.drawBlocks$28c3c058(canvas, this.mCircleBounds, this.mStartAngle, 360.0f, this.mRimPaint);
                            }
                        }
                        if (this.mOuterContourSize > 0.0f) {
                            canvas.drawArc(this.mCircleOuterContour, 360.0f, 360.0f, false, this.mOuterContourPaint);
                        }
                        if (this.mInnerContourSize > 0.0f) {
                            canvas.drawArc(this.mCircleInnerContour, 360.0f, 360.0f, false, this.mInnerContourPaint);
                        }
                        if (this.mAnimationState != AnimationState.SPINNING && this.mAnimationState != AnimationState.END_SPINNING) break block59;
                        this.drawSpinner(canvas);
                        if (!this.mShowTextWhileSpinning) break block60;
                        break block61;
                    }
                    if (this.mAnimationState != AnimationState.END_SPINNING_START_ANIMATING) break block62;
                    this.drawSpinner(canvas);
                    if (this.mDrawBarWhileSpinning) break block62;
                    if (!this.mShowTextWhileSpinning) break block60;
                    break block61;
                }
                Canvas canvas2 = canvas;
                CircleProgressView circleProgressView2 = this;
                float f8 = f7 = circleProgressView2.mDirection == Direction.CW ? (float)circleProgressView2.mStartAngle : (float)circleProgressView2.mStartAngle - degrees;
                if (!circleProgressView2.mShowBlock) {
                    if (circleProgressView2.mBarStrokeCap != Paint.Cap.BUTT && degrees > 0.0f && circleProgressView2.mBarColors.length > 1) {
                        if (degrees > 180.0f) {
                            canvas2.drawArc(circleProgressView2.mCircleBounds, f7, degrees / 2.0f, false, circleProgressView2.mBarPaint);
                            canvas2.drawArc(circleProgressView2.mCircleBounds, f7, 1.0f, false, circleProgressView2.mShaderlessBarPaint);
                            canvas2.drawArc(circleProgressView2.mCircleBounds, f7 + degrees / 2.0f, degrees / 2.0f, false, circleProgressView2.mBarPaint);
                        } else {
                            canvas2.drawArc(circleProgressView2.mCircleBounds, f7, degrees, false, circleProgressView2.mBarPaint);
                            canvas2.drawArc(circleProgressView2.mCircleBounds, f7, 1.0f, false, circleProgressView2.mShaderlessBarPaint);
                        }
                    } else {
                        canvas2.drawArc(circleProgressView2.mCircleBounds, f7, degrees, false, circleProgressView2.mBarPaint);
                    }
                } else {
                    circleProgressView2.drawBlocks$28c3c058(canvas2, circleProgressView2.mCircleBounds, f7, degrees, circleProgressView2.mBarPaint);
                }
            }
            Canvas canvas3 = canvas;
            CircleProgressView circleProgressView3 = this;
            switch (circleProgressView3.mUnitPosition) {
                case TOP: 
                case BOTTOM: {
                    f6 = 0.25f * circleProgressView3.mRelativeUniteSize;
                    f5 = 0.4f * circleProgressView3.mRelativeUniteSize;
                    break;
                }
                default: {
                    f6 = 0.55f * circleProgressView3.mRelativeUniteSize;
                    f5 = 0.3f * circleProgressView3.mRelativeUniteSize;
                }
            }
            float f9 = circleProgressView3.mOuterTextBounds.width() * 0.05f / 2.0f;
            float f10 = circleProgressView3.mOuterTextBounds.width() * f5;
            float f11 = circleProgressView3.mOuterTextBounds.height() * 0.025f / 2.0f;
            float f12 = circleProgressView3.mOuterTextBounds.height() * f6;
            boolean bl = false;
            if (circleProgressView3.mIsAutoColorEnabled) {
                circleProgressView3.mTextPaint.setColor(circleProgressView3.calcTextColor(circleProgressView3.mCurrentValue));
            }
            switch (circleProgressView3.mTextMode) {
                default: {
                    string = circleProgressView3.mText != null ? circleProgressView3.mText : "";
                    break;
                }
                case PERCENT: {
                    string = circleProgressView3.decimalFormat.format(100.0f / circleProgressView3.mMaxValue * circleProgressView3.mCurrentValue);
                    break;
                }
                case VALUE: {
                    string = circleProgressView3.decimalFormat.format(circleProgressView3.mCurrentValue);
                }
            }
            if (circleProgressView3.mTextLength != string.length()) {
                bl = true;
                circleProgressView3.mTextLength = string.length();
                if (circleProgressView3.mTextLength == 1) {
                    circleProgressView3.mOuterTextBounds = circleProgressView3.getInnerCircleRect(circleProgressView3.mCircleBounds);
                    circleProgressView3.mOuterTextBounds = new RectF(circleProgressView3.mOuterTextBounds.left + circleProgressView3.mOuterTextBounds.width() * 0.1f, circleProgressView3.mOuterTextBounds.top, circleProgressView3.mOuterTextBounds.right - circleProgressView3.mOuterTextBounds.width() * 0.1f, circleProgressView3.mOuterTextBounds.bottom);
                } else {
                    circleProgressView3.mOuterTextBounds = circleProgressView3.getInnerCircleRect(circleProgressView3.mCircleBounds);
                }
                if (circleProgressView3.mIsAutoTextSize) {
                    String string2 = string;
                    f4 = f12;
                    f3 = f11;
                    f2 = f10;
                    f = f9;
                    circleProgressView = circleProgressView3;
                    RectF rectF = circleProgressView.mOuterTextBounds;
                    if (circleProgressView.mShowUnit) {
                        switch (circleProgressView.mUnitPosition) {
                            case TOP: {
                                rectF = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.top + f4 + f3, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.bottom);
                                break;
                            }
                            case BOTTOM: {
                                rectF = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.bottom - f4 - f3);
                                break;
                            }
                            case LEFT_TOP: 
                            case LEFT_BOTTOM: {
                                rectF = new RectF(circleProgressView.mOuterTextBounds.left + f2 + f, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.bottom);
                                break;
                            }
                            default: {
                                rectF = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right - f2 - f, circleProgressView.mOuterTextBounds.bottom);
                            }
                        }
                    }
                    circleProgressView.mTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(string2, circleProgressView.mTextPaint, rectF) * circleProgressView.mTextScale);
                    circleProgressView.mActualTextBounds = CircleProgressView.calcTextBounds(string2, circleProgressView.mTextPaint, rectF);
                } else {
                    circleProgressView3.setTextSizeAndTextBoundsWithFixedTextSize(string);
                }
            }
            canvas3.drawText(string, circleProgressView3.mActualTextBounds.left - circleProgressView3.mTextPaint.getTextSize() * 0.02f, circleProgressView3.mActualTextBounds.bottom, circleProgressView3.mTextPaint);
            if (circleProgressView3.mShowUnit) {
                if (circleProgressView3.mIsAutoColorEnabled) {
                    circleProgressView3.mUnitTextPaint.setColor(circleProgressView3.calcTextColor(circleProgressView3.mCurrentValue));
                }
                if (bl) {
                    if (circleProgressView3.mIsAutoTextSize) {
                        f4 = f12;
                        f3 = f11;
                        f2 = f10;
                        f = f9;
                        circleProgressView = circleProgressView3;
                        switch (circleProgressView.mUnitPosition) {
                            case TOP: {
                                circleProgressView.mUnitBounds = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.top + f4 - f3);
                                break;
                            }
                            case BOTTOM: {
                                circleProgressView.mUnitBounds = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.bottom - f4 + f3, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.bottom);
                                break;
                            }
                            case LEFT_TOP: 
                            case LEFT_BOTTOM: {
                                circleProgressView.mUnitBounds = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.left + f2 - f, circleProgressView.mOuterTextBounds.top + f4);
                                break;
                            }
                            default: {
                                circleProgressView.mUnitBounds = new RectF(circleProgressView.mOuterTextBounds.right - f2 + f, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.top + f4);
                            }
                        }
                        circleProgressView.mUnitTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mUnitBounds) * circleProgressView.mUnitScale);
                        circleProgressView.mUnitBounds = CircleProgressView.calcTextBounds(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mUnitBounds);
                        switch (circleProgressView.mUnitPosition) {
                            case LEFT_TOP: 
                            case RIGHT_TOP: {
                                float f13 = circleProgressView.mActualTextBounds.top - circleProgressView.mUnitBounds.top;
                                circleProgressView.mUnitBounds.offset(0.0f, f13);
                                break;
                            }
                            case LEFT_BOTTOM: 
                            case RIGHT_BOTTOM: {
                                float f14 = circleProgressView.mActualTextBounds.bottom - circleProgressView.mUnitBounds.bottom;
                                circleProgressView.mUnitBounds.offset(0.0f, f14);
                            }
                        }
                    } else {
                        f2 = f11 * 2.0f;
                        f = f9 * 2.0f;
                        circleProgressView = circleProgressView3;
                        circleProgressView.mUnitTextPaint.setTextSize((float)circleProgressView.mUnitTextSize);
                        circleProgressView.mUnitBounds = CircleProgressView.calcTextBounds(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mOuterTextBounds);
                        switch (circleProgressView.mUnitPosition) {
                            case TOP: {
                                circleProgressView.mUnitBounds.offsetTo(circleProgressView.mUnitBounds.left, circleProgressView.mActualTextBounds.top - f2 - circleProgressView.mUnitBounds.height());
                                break;
                            }
                            case BOTTOM: {
                                circleProgressView.mUnitBounds.offsetTo(circleProgressView.mUnitBounds.left, circleProgressView.mActualTextBounds.bottom + f2);
                                break;
                            }
                            case LEFT_TOP: 
                            case LEFT_BOTTOM: {
                                circleProgressView.mUnitBounds.offsetTo(circleProgressView.mActualTextBounds.left - f - circleProgressView.mUnitBounds.width(), circleProgressView.mUnitBounds.top);
                                break;
                            }
                            default: {
                                circleProgressView.mUnitBounds.offsetTo(circleProgressView.mActualTextBounds.right + f, circleProgressView.mUnitBounds.top);
                            }
                        }
                        switch (circleProgressView.mUnitPosition) {
                            case LEFT_TOP: 
                            case RIGHT_TOP: {
                                f3 = circleProgressView.mActualTextBounds.top - circleProgressView.mUnitBounds.top;
                                circleProgressView.mUnitBounds.offset(0.0f, f3);
                                break;
                            }
                            case LEFT_BOTTOM: 
                            case RIGHT_BOTTOM: {
                                f3 = circleProgressView.mActualTextBounds.bottom - circleProgressView.mUnitBounds.bottom;
                                circleProgressView.mUnitBounds.offset(0.0f, f3);
                            }
                        }
                    }
                }
                canvas3.drawText(circleProgressView3.mUnit, circleProgressView3.mUnitBounds.left - circleProgressView3.mUnitTextPaint.getTextSize() * 0.02f, circleProgressView3.mUnitBounds.bottom, circleProgressView3.mUnitTextPaint);
            }
        }
        if (this.mClippingBitmap != null) {
            canvas.drawBitmap(this.mClippingBitmap, 0.0f, 0.0f, this.mMaskPaint);
        }
        if (this.mBarStartEndLineWidth > 0 && this.mBarStartEndLine != BarStartEndLine.NONE) {
            Canvas canvas4 = canvas;
            CircleProgressView circleProgressView = this;
            if (degrees != 0.0f) {
                float f = (circleProgressView.mDirection == Direction.CW ? (float)circleProgressView.mStartAngle : (float)circleProgressView.mStartAngle - degrees) - circleProgressView.mBarStartEndLineSweep / 2.0f;
                if (circleProgressView.mBarStartEndLine == BarStartEndLine.START || circleProgressView.mBarStartEndLine == BarStartEndLine.BOTH) {
                    canvas4.drawArc(circleProgressView.mCircleBounds, f, circleProgressView.mBarStartEndLineSweep, false, circleProgressView.mBarStartEndLinePaint);
                }
                if (circleProgressView.mBarStartEndLine == BarStartEndLine.END || circleProgressView.mBarStartEndLine == BarStartEndLine.BOTH) {
                    canvas4.drawArc(circleProgressView.mCircleBounds, f + degrees, circleProgressView.mBarStartEndLineSweep, false, circleProgressView.mBarStartEndLinePaint);
                }
            }
        }
    }

    private void drawBlocks$28c3c058(Canvas _canvas, RectF circleBounds, float startAngle, float _degrees, Paint paint) {
        for (float tmpDegree = 0.0f; tmpDegree < _degrees; tmpDegree += this.mBlockDegree) {
            _canvas.drawArc(circleBounds, startAngle + tmpDegree, Math.min(this.mBlockScaleDegree, _degrees - tmpDegree), false, paint);
        }
    }

    private void drawSpinner(Canvas canvas) {
        if (this.mSpinningBarLengthCurrent < 0.0f) {
            this.mSpinningBarLengthCurrent = 1.0f;
        }
        float startAngle = this.mDirection == Direction.CW ? (float)this.mStartAngle + this.mCurrentSpinnerDegreeValue - this.mSpinningBarLengthCurrent : (float)this.mStartAngle - this.mCurrentSpinnerDegreeValue;
        canvas.drawArc(this.mCircleBounds, startAngle, this.mSpinningBarLengthCurrent, false, this.mBarSpinnerPaint);
    }

    public void stopSpinning() {
        this.setSpin(false);
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.STOP_SPINNING$48cb079c - 1);
    }

    public void spin() {
        this.setSpin(true);
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.START_SPINNING$48cb079c - 1);
    }

    private void setSpin(boolean spin) {
        this.mSpin = spin;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.mSeekModeEnabled) {
            return super.onTouchEvent(event);
        }
        switch (event.getActionMasked()) {
            case 0: 
            case 1: {
                this.mTouchEventCount = 0;
                PointF point = new PointF(event.getX(), event.getY());
                float angle = this.getRotationAngleForPointFromStart(point);
                this.setValueAnimated(this.mMaxValue / 360.0f * angle, 800L);
                return true;
            }
            case 2: {
                ++this.mTouchEventCount;
                if (this.mTouchEventCount > 5) {
                    PointF point = new PointF(event.getX(), event.getY());
                    float angle = this.getRotationAngleForPointFromStart(point);
                    this.setValue(this.mMaxValue / 360.0f * angle);
                    return true;
                }
                return false;
            }
            case 3: {
                this.mTouchEventCount = 0;
                return false;
            }
        }
        return super.onTouchEvent(event);
    }

    private float getRotationAngleForPointFromStart(PointF point) {
        long angle = Math.round(CircleProgressView.calcRotationAngleInDegrees(this.mCenter, point));
        return CircleProgressView.normalizeAngle(this.mDirection == Direction.CW ? (float)(angle - (long)this.mStartAngle) : (float)((long)this.mStartAngle - angle));
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(float var1);
    }
}

