/*
 * Decompiled with CFR 0.152.
 */
package at.grabner.circleprogress;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import at.grabner.circleprogress.AnimationHandler;
import at.grabner.circleprogress.AnimationMsg;
import at.grabner.circleprogress.AnimationState;
import at.grabner.circleprogress.AnimationStateChangedListener;
import at.grabner.circleprogress.ColorUtils;
import at.grabner.circleprogress.R;
import at.grabner.circleprogress.TextMode;

public class CircleProgressView
extends View {
    float mCurrentValue = 42.0f;
    float mValueTo = 0.0f;
    float mValueFrom = 0.0f;
    float mMaxValue = 100.0f;
    float mSpinningBarLengthCurrent = 0.0f;
    float mSpinningBarLengthOrig = 42.0f;
    float mCurrentSpinnerDegreeValue = 0.0f;
    private int mLayoutHeight = 0;
    private int mLayoutWidth = 0;
    private int mBarWidth = 40;
    private int mRimWidth = 40;
    private int mStartAngle = 270;
    private float mContourSize = 1.0f;
    private int mUnitSize = 10;
    private int mTextSize = 10;
    private float mTextScale = 1.0f;
    private float mUnitScale = 1.0f;
    private int mBarColorStandard = -16738680;
    private int mContourColor = -1442840576;
    private int mSpinnerColor = this.mBarColorStandard;
    private int mBackgroundCircleColor = 0;
    private int mRimColor = -1434201911;
    private int mTextColor = -16777216;
    private int mUnitColor = -16777216;
    private boolean mIsAutoColorEnabled = false;
    private int[] mBarColors = new int[]{this.mBarColorStandard};
    private Paint.Cap mBarStrokeCap = Paint.Cap.BUTT;
    private Paint.Cap mSpinnerStrokeCap = Paint.Cap.BUTT;
    private Paint mBarPaint = new Paint();
    private Paint mBarSpinnerPaint = new Paint();
    private Paint mBackgroundCirclePaint = new Paint();
    private Paint mRimPaint = new Paint();
    private Paint mTextPaint = new Paint();
    private Paint mUnitTextPaint = new Paint();
    private Paint mContourPaint = new Paint();
    private RectF mCircleBounds = new RectF();
    private RectF mInnerCircleBound = new RectF();
    private PointF mCenter;
    private RectF mOuterTextBounds = new RectF();
    private RectF mActualTextBounds = new RectF();
    private RectF mUnitBounds = new RectF();
    private RectF mCircleOuterContour = new RectF();
    private RectF mCircleInnerContour = new RectF();
    float mSpinSpeed = 2.8f;
    double mAnimationDuration = 900.0;
    int mFrameDelayMillis = 10;
    boolean mDrawBarWhileSpinning;
    Handler mAnimationHandler = new AnimationHandler(this);
    AnimationState mAnimationState = AnimationState.IDLE;
    private String mText = "";
    private String mUnit = "";
    private int mTextLength;
    private TextMode mTextMode = TextMode.PERCENT;
    private boolean mIsAutoTextSize;
    private boolean mShowUnit = false;
    private Bitmap mClippingBitmap;
    private Paint mMaskPaint;
    private float mRelativeUniteSize = 0.3f;
    private boolean mSeekModeEnabled = false;
    private boolean mShowTextWhileSpinning = false;
    AnimationStateChangedListener mAnimationStateChangedListener;
    private boolean mShowBlock = false;
    private int mBlockCount = 18;
    private float mBlockScale = 0.9f;
    private float mBlockDegree = 360 / this.mBlockCount;
    private float mBlockScaleDegree = this.mBlockDegree * this.mBlockScale;
    private int mTouchEventCount;
    private OnProgressChangedListener onProgressChangedListener;
    private float previousProgressChangedValue;

    public CircleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView);
        CircleProgressView circleProgressView = this;
        circleProgressView.setBarWidth((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_barWidth, (float)circleProgressView.mBarWidth));
        circleProgressView.setRimWidth((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_rimWidth, (float)circleProgressView.mRimWidth));
        circleProgressView.setSpinSpeed((int)typedArray.getFloat(R.styleable.CircleProgressView_cpv_spinSpeed, circleProgressView.mSpinSpeed));
        float f = typedArray.getFloat(R.styleable.CircleProgressView_cpv_value, circleProgressView.mCurrentValue);
        circleProgressView.setValue(f);
        circleProgressView.mCurrentValue = f;
        circleProgressView.mBarColors = typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor1) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor2) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor3) ? new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor1, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor2, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor3, circleProgressView.mBarColorStandard)} : (typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor1) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor2) ? new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor1, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor2, circleProgressView.mBarColorStandard)} : (typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor) && typedArray.hasValue(R.styleable.CircleProgressView_cpv_barColor1) ? new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor1, circleProgressView.mBarColorStandard)} : new int[]{typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, circleProgressView.mBarColorStandard), typedArray.getColor(R.styleable.CircleProgressView_cpv_barColor, circleProgressView.mBarColorStandard)}));
        circleProgressView.setSpinBarColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_spinColor, circleProgressView.mSpinnerColor));
        circleProgressView.setSpinningBarLength(typedArray.getFloat(R.styleable.CircleProgressView_cpv_spinBarLength, circleProgressView.mSpinningBarLengthOrig));
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textSize)) {
            circleProgressView.setTextSize((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_textSize, (float)circleProgressView.mTextSize));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_unitSize)) {
            circleProgressView.setUnitSize((int)typedArray.getDimension(R.styleable.CircleProgressView_cpv_unitSize, (float)circleProgressView.mUnitSize));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textColor)) {
            circleProgressView.setTextColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_textColor, circleProgressView.mTextColor));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_unitColor)) {
            circleProgressView.setUnitColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_unitColor, circleProgressView.mUnitColor));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_autoTextColor)) {
            circleProgressView.setAutoTextColor(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_autoTextColor, circleProgressView.mIsAutoColorEnabled));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_autoTextSize)) {
            circleProgressView.setAutoTextSize(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_autoTextSize, circleProgressView.mIsAutoTextSize));
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_textMode)) {
            circleProgressView.setTextMode(TextMode.values()[typedArray.getInt(R.styleable.CircleProgressView_cpv_textMode, 0)]);
        }
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_text)) {
            circleProgressView.setText(typedArray.getString(R.styleable.CircleProgressView_cpv_text));
        }
        circleProgressView.setRimColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_rimColor, circleProgressView.mRimColor));
        circleProgressView.setFillCircleColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_fillColor, circleProgressView.mBackgroundCircleColor));
        circleProgressView.setContourColor(typedArray.getColor(R.styleable.CircleProgressView_cpv_contourColor, circleProgressView.mContourColor));
        circleProgressView.setContourSize(typedArray.getDimension(R.styleable.CircleProgressView_cpv_contourSize, circleProgressView.mContourSize));
        circleProgressView.setMaxValue(typedArray.getFloat(R.styleable.CircleProgressView_cpv_maxValue, circleProgressView.mMaxValue));
        circleProgressView.setUnit(typedArray.getString(R.styleable.CircleProgressView_cpv_unit));
        circleProgressView.setShowUnit(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_showUnit, circleProgressView.mShowUnit));
        circleProgressView.setTextScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_textScale, circleProgressView.mTextScale));
        circleProgressView.setUnitScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_unitScale, circleProgressView.mUnitScale));
        circleProgressView.setSeekModeEnabled(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_seekMode, circleProgressView.mSeekModeEnabled));
        circleProgressView.setStartAngle(typedArray.getInt(R.styleable.CircleProgressView_cpv_startAngle, circleProgressView.mStartAngle));
        circleProgressView.setShowTextWhileSpinning(typedArray.getBoolean(R.styleable.CircleProgressView_cpv_showTextInSpinningMode, circleProgressView.mShowTextWhileSpinning));
        if (typedArray.hasValue(R.styleable.CircleProgressView_cpv_blockCount)) {
            circleProgressView.setBlockCount(typedArray.getInt(R.styleable.CircleProgressView_cpv_blockCount, 1));
            circleProgressView.setBlockScale(typedArray.getFloat(R.styleable.CircleProgressView_cpv_blockScale, 0.9f));
        }
        typedArray.recycle();
        if (!this.isInEditMode() && Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        this.mMaskPaint = new Paint(1);
        this.mMaskPaint.setFilterBitmap(false);
        this.mMaskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.setupPaints();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heightWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        int size = widthWithoutPadding > heightWithoutPadding ? heightWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    private RectF getInnerCircleRect(RectF _circleBounds) {
        double width = (double)(_circleBounds.width() - (float)Math.max(this.mBarWidth, this.mRimWidth) - this.mContourSize * 2.0f) / 2.0 * Math.sqrt(2.0);
        float widthDelta = (_circleBounds.width() - (float)width) / 2.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (this.isShowUnit()) {
            scaleX = 0.77f;
            scaleY = 1.33f;
        }
        return new RectF(_circleBounds.left + widthDelta * scaleX, _circleBounds.top + widthDelta * scaleY, _circleBounds.right - widthDelta * scaleX, _circleBounds.bottom - widthDelta * scaleY);
    }

    private static float calcTextSizeForRect(String _text, Paint _textPaint, RectF _rectBounds) {
        Matrix matrix = new Matrix();
        Rect textBoundsTmp = new Rect();
        String text = _text.replace('1', '0');
        _textPaint.getTextBounds(text, 0, text.length(), textBoundsTmp);
        RectF textBoundsTmpF = new RectF(textBoundsTmp);
        matrix.setRectToRect(textBoundsTmpF, _rectBounds, Matrix.ScaleToFit.CENTER);
        float[] values = new float[9];
        matrix.getValues(values);
        return _textPaint.getTextSize() * values[0];
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mLayoutWidth = w;
        this.mLayoutHeight = h;
        CircleProgressView circleProgressView = this;
        int n = Math.min(circleProgressView.mLayoutWidth, circleProgressView.mLayoutHeight);
        int n2 = circleProgressView.mLayoutWidth - n;
        int n3 = circleProgressView.mLayoutHeight - n;
        float f = circleProgressView.getPaddingTop() + n3 / 2;
        float f2 = circleProgressView.getPaddingBottom() + n3 / 2;
        float f3 = circleProgressView.getPaddingLeft() + n2 / 2;
        float f4 = circleProgressView.getPaddingRight() + n2 / 2;
        int n4 = circleProgressView.getWidth();
        int n5 = circleProgressView.getHeight();
        float f5 = (float)circleProgressView.mBarWidth / 2.0f > (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mContourSize ? (float)circleProgressView.mBarWidth / 2.0f : (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mContourSize;
        circleProgressView.mCircleBounds = new RectF(f3 + f5, f + f5, (float)n4 - f4 - f5, (float)n5 - f2 - f5);
        circleProgressView.mInnerCircleBound = new RectF(f3 + (float)circleProgressView.mBarWidth, f + (float)circleProgressView.mBarWidth, (float)n4 - f4 - (float)circleProgressView.mBarWidth, (float)n5 - f2 - (float)circleProgressView.mBarWidth);
        circleProgressView.mOuterTextBounds = circleProgressView.getInnerCircleRect(circleProgressView.mCircleBounds);
        circleProgressView.mCircleInnerContour = new RectF(circleProgressView.mCircleBounds.left + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mContourSize / 2.0f, circleProgressView.mCircleBounds.top + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mContourSize / 2.0f, circleProgressView.mCircleBounds.right - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mContourSize / 2.0f, circleProgressView.mCircleBounds.bottom - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mContourSize / 2.0f);
        circleProgressView.mCircleOuterContour = new RectF(circleProgressView.mCircleBounds.left - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mContourSize / 2.0f, circleProgressView.mCircleBounds.top - (float)circleProgressView.mRimWidth / 2.0f - circleProgressView.mContourSize / 2.0f, circleProgressView.mCircleBounds.right + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mContourSize / 2.0f, circleProgressView.mCircleBounds.bottom + (float)circleProgressView.mRimWidth / 2.0f + circleProgressView.mContourSize / 2.0f);
        Math.round(((float)n4 - f4 - (float)circleProgressView.mBarWidth) / 2.0f);
        circleProgressView.mCenter = new PointF(circleProgressView.mCircleBounds.centerX(), circleProgressView.mCircleBounds.centerY());
        this.setupBarPaint();
        if (this.mClippingBitmap != null) {
            this.mClippingBitmap = Bitmap.createScaledBitmap((Bitmap)this.mClippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false);
        }
        this.invalidate();
    }

    public void setAnimationStateChangedListener(AnimationStateChangedListener _animationStateChangedListener) {
        this.mAnimationStateChangedListener = _animationStateChangedListener;
    }

    public int getUnitSize() {
        return this.mUnitSize;
    }

    public void setUnitSize(@IntRange(from=0L) int unitSize) {
        this.mUnitSize = unitSize;
        this.mUnitTextPaint.setTextSize((float)unitSize);
    }

    public boolean isSeekModeEnabled() {
        return this.mSeekModeEnabled;
    }

    public void setSeekModeEnabled(boolean _seekModeEnabled) {
        this.mSeekModeEnabled = _seekModeEnabled;
    }

    public Paint.Cap getSpinnerStrokeCap() {
        return this.mSpinnerStrokeCap;
    }

    public void setSpinnerStrokeCap(Paint.Cap _spinnerStrokeCap) {
        this.mSpinnerStrokeCap = _spinnerStrokeCap;
        this.mBarSpinnerPaint.setStrokeCap(_spinnerStrokeCap);
    }

    public Paint.Cap getBarStrokeCap() {
        return this.mBarStrokeCap;
    }

    public void setBarStrokeCap(Paint.Cap _barStrokeCap) {
        this.mBarStrokeCap = _barStrokeCap;
        this.mBarPaint.setStrokeCap(_barStrokeCap);
    }

    public int getContourColor() {
        return this.mContourColor;
    }

    public void setContourColor(@ColorInt int _contourColor) {
        this.mContourColor = _contourColor;
        this.mContourPaint.setColor(_contourColor);
    }

    public float getContourSize() {
        return this.mContourSize;
    }

    public void setContourSize(@FloatRange(from=0.0) float _contourSize) {
        this.mContourSize = _contourSize;
        this.mContourPaint.setStrokeWidth(_contourSize);
    }

    public void setText(String text) {
        this.mText = text != null ? text : "";
        this.invalidate();
    }

    public void setTextMode(TextMode _autoTextValue) {
        this.mTextMode = _autoTextValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    public void setUnit(String _unit) {
        this.mUnit = _unit == null ? "" : _unit;
        this.invalidate();
    }

    private static RectF getTextBounds(String _text, Paint _textPaint, RectF _textBounds) {
        Rect textBoundsTmp = new Rect();
        _textPaint.getTextBounds(_text, 0, _text.length(), textBoundsTmp);
        RectF textRect = new RectF();
        new RectF().left = _textBounds.left + (_textBounds.width() - (float)textBoundsTmp.width()) / 2.0f;
        textRect.top = _textBounds.top + (_textBounds.height() - (float)textBoundsTmp.height()) / 2.0f;
        textRect.right = textRect.left + (float)textBoundsTmp.width();
        textRect.bottom = textRect.top + (float)textBoundsTmp.height();
        return textRect;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(@IntRange(from=0L) int textSize) {
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextSize = textSize;
        this.mIsAutoTextSize = false;
    }

    public boolean isAutoTextSize() {
        return this.mIsAutoTextSize;
    }

    public void setAutoTextSize(boolean _autoTextSize) {
        this.mIsAutoTextSize = _autoTextSize;
    }

    public boolean isShowUnit() {
        return this.mShowUnit;
    }

    public void setShowUnit(boolean _showUnit) {
        if (_showUnit != this.mShowUnit) {
            this.mShowUnit = _showUnit;
            this.mTextLength = 0;
            this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
            this.invalidate();
        }
    }

    public float getUnitScale() {
        return this.mUnitScale;
    }

    public void setUnitScale(@FloatRange(from=0.0) float _unitScale) {
        this.mUnitScale = _unitScale;
    }

    public float getTextScale() {
        return this.mTextScale;
    }

    public void setTextScale(@FloatRange(from=0.0) float _textScale) {
        this.mTextScale = _textScale;
    }

    public void setSpinningBarLength(@FloatRange(from=0.0) float barLength) {
        this.mSpinningBarLengthCurrent = this.mSpinningBarLengthOrig = barLength;
    }

    public int getBarWidth() {
        return this.mBarWidth;
    }

    public void setBarWidth(@FloatRange(from=0.0) int barWidth) {
        this.mBarWidth = barWidth;
        this.mBarPaint.setStrokeWidth((float)barWidth);
        this.mBarSpinnerPaint.setStrokeWidth((float)barWidth);
    }

    public int[] getBarColors() {
        return this.mBarColors;
    }

    public void setBarColor(int ... barColors) {
        this.mBarColors = barColors;
        if (this.mBarColors.length > 1) {
            this.mBarPaint.setShader((Shader)new SweepGradient(this.mCircleBounds.centerX(), this.mCircleBounds.centerY(), this.mBarColors, null));
            Matrix matrix = new Matrix();
            this.mBarPaint.getShader().getLocalMatrix(matrix);
            matrix.postTranslate(-this.mCircleBounds.centerX(), -this.mCircleBounds.centerY());
            matrix.postRotate((float)this.mStartAngle);
            matrix.postTranslate(this.mCircleBounds.centerX(), this.mCircleBounds.centerY());
            this.mBarPaint.getShader().setLocalMatrix(matrix);
            this.mBarPaint.setColor(barColors[0]);
            return;
        }
        if (this.mBarColors.length == 0) {
            this.mBarPaint.setColor(this.mBarColors[0]);
            this.mBarPaint.setShader(null);
            return;
        }
        this.mBarPaint.setColor(this.mBarColorStandard);
        this.mBarPaint.setShader(null);
    }

    public void setSpinBarColor(@ColorInt int _color) {
        this.mSpinnerColor = _color;
        this.mBarSpinnerPaint.setColor(this.mSpinnerColor);
    }

    public int getBackgroundCircleColor() {
        return this.mBackgroundCirclePaint.getColor();
    }

    public void setFillCircleColor(@ColorInt int circleColor) {
        this.mBackgroundCircleColor = circleColor;
        this.mBackgroundCirclePaint.setColor(circleColor);
    }

    public int getRimColor() {
        return this.mRimColor;
    }

    public void setRimColor(@ColorInt int rimColor) {
        this.mRimColor = rimColor;
        this.mRimPaint.setColor(rimColor);
    }

    public Shader getRimShader() {
        return this.mRimPaint.getShader();
    }

    public void setRimShader(Shader shader) {
        this.mRimPaint.setShader(shader);
    }

    private int getTextColor(double value) {
        if (this.mBarColors.length > 1) {
            double percent = 1.0 / this.getMaxValue() * value;
            int low = (int)Math.floor((double)(this.mBarColors.length - 1) * percent);
            int high = low + 1;
            if (low < 0) {
                low = 0;
                high = 1;
            } else if (high >= this.mBarColors.length) {
                low = this.mBarColors.length - 2;
                high = this.mBarColors.length - 1;
            }
            return ColorUtils.getRGBGradient(this.mBarColors[low], this.mBarColors[high], (float)(1.0 - (double)(this.mBarColors.length - 1) * percent % 1.0));
        }
        if (this.mBarColors.length == 1) {
            return this.mBarColors[0];
        }
        return -16777216;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(@FloatRange(from=0.0) float _maxValue) {
        this.mMaxValue = _maxValue;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(textColor);
    }

    public void setAutoTextColor(boolean isEnabled) {
        this.mIsAutoColorEnabled = isEnabled;
    }

    public void setUnitColor(@ColorInt int unitColor) {
        this.mUnitColor = unitColor;
        this.mUnitTextPaint.setColor(unitColor);
        this.mIsAutoColorEnabled = false;
    }

    public float getSpinSpeed() {
        return this.mSpinSpeed;
    }

    public void setSpinSpeed(float spinSpeed) {
        this.mSpinSpeed = spinSpeed;
    }

    public int getRimWidth() {
        return this.mRimWidth;
    }

    public void setRimWidth(@IntRange(from=0L) int rimWidth) {
        this.mRimWidth = rimWidth;
        this.mRimPaint.setStrokeWidth((float)rimWidth);
    }

    public int getDelayMillis() {
        return this.mFrameDelayMillis;
    }

    public void setDelayMillis(int delayMillis) {
        this.mFrameDelayMillis = delayMillis;
    }

    @TargetApi(value=11)
    public void setClippingBitmap(Bitmap _clippingBitmap) {
        this.mClippingBitmap = this.getWidth() > 0 && this.getHeight() > 0 ? Bitmap.createScaledBitmap((Bitmap)_clippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false) : _clippingBitmap;
        if (this.mClippingBitmap == null) {
            this.setLayerType(2, null);
            return;
        }
        this.setLayerType(1, null);
    }

    public void setTextTypeface(Typeface typeface) {
        this.mTextPaint.setTypeface(typeface);
    }

    public void setUnitTextTypeface(Typeface typeface) {
        this.mUnitTextPaint.setTypeface(typeface);
    }

    public float getRelativeUniteSize() {
        return this.mRelativeUniteSize;
    }

    public void setRelativeUniteSize(@FloatRange(from=0.0) float _relativeUniteSize) {
        this.mRelativeUniteSize = _relativeUniteSize;
    }

    public boolean isShowTextWhileSpinning() {
        return this.mShowTextWhileSpinning;
    }

    public void setShowTextWhileSpinning(boolean shouldDrawTextWhileSpinning) {
        this.mShowTextWhileSpinning = shouldDrawTextWhileSpinning;
    }

    public int getStartAngle() {
        return this.mStartAngle;
    }

    public void setStartAngle(int _startAngle) {
        this.mStartAngle = (int)CircleProgressView.normalizeAngle(_startAngle);
    }

    public void setShowBlock(boolean showBlock) {
        this.mShowBlock = showBlock;
    }

    public void setBlockCount(int blockCount) {
        if (blockCount > 1) {
            this.mShowBlock = true;
            this.mBlockCount = blockCount;
            this.mBlockDegree = 360.0f / (float)blockCount;
            this.mBlockScaleDegree = this.mBlockDegree * this.mBlockScale;
            return;
        }
        this.mShowBlock = false;
    }

    public void setBlockScale(float blockScale) {
        if (blockScale >= 0.0f && blockScale <= 1.0f) {
            this.mBlockScale = blockScale;
            this.mBlockScaleDegree = this.mBlockDegree * blockScale;
        }
    }

    public boolean isShowBlock() {
        return this.mShowBlock;
    }

    public int getBlockCount() {
        return this.mBlockCount;
    }

    public float getBlockScale() {
        return this.mBlockScale;
    }

    public void setupPaints() {
        this.setupBarPaint();
        CircleProgressView circleProgressView = this;
        circleProgressView.mBarSpinnerPaint.setAntiAlias(true);
        circleProgressView.mBarSpinnerPaint.setStrokeCap(circleProgressView.mSpinnerStrokeCap);
        circleProgressView.mBarSpinnerPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mBarSpinnerPaint.setStrokeWidth((float)circleProgressView.mBarWidth);
        circleProgressView.mBarSpinnerPaint.setColor(circleProgressView.mSpinnerColor);
        circleProgressView = this;
        circleProgressView.mContourPaint.setColor(circleProgressView.mContourColor);
        circleProgressView.mContourPaint.setAntiAlias(true);
        circleProgressView.mContourPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mContourPaint.setStrokeWidth(circleProgressView.mContourSize);
        circleProgressView = this;
        circleProgressView.mUnitTextPaint.setStyle(Paint.Style.FILL);
        circleProgressView.mUnitTextPaint.setAntiAlias(true);
        circleProgressView = this;
        circleProgressView.mTextPaint.setSubpixelText(true);
        circleProgressView.mTextPaint.setLinearText(true);
        circleProgressView.mTextPaint.setTypeface(Typeface.MONOSPACE);
        circleProgressView.mTextPaint.setColor(circleProgressView.mTextColor);
        circleProgressView.mTextPaint.setStyle(Paint.Style.FILL);
        circleProgressView.mTextPaint.setAntiAlias(true);
        circleProgressView.mTextPaint.setTextSize((float)circleProgressView.mTextSize);
        circleProgressView = this;
        circleProgressView.mBackgroundCirclePaint.setColor(circleProgressView.mBackgroundCircleColor);
        circleProgressView.mBackgroundCirclePaint.setAntiAlias(true);
        circleProgressView.mBackgroundCirclePaint.setStyle(Paint.Style.FILL);
        circleProgressView = this;
        circleProgressView.mRimPaint.setColor(circleProgressView.mRimColor);
        circleProgressView.mRimPaint.setAntiAlias(true);
        circleProgressView.mRimPaint.setStyle(Paint.Style.STROKE);
        circleProgressView.mRimPaint.setStrokeWidth((float)circleProgressView.mRimWidth);
    }

    private void setupBarPaint() {
        if (this.mBarColors.length > 1) {
            this.mBarPaint.setShader((Shader)new SweepGradient(this.mCircleBounds.centerX(), this.mCircleBounds.centerY(), this.mBarColors, null));
            Matrix matrix = new Matrix();
            this.mBarPaint.getShader().getLocalMatrix(matrix);
            matrix.postTranslate(-this.mCircleBounds.centerX(), -this.mCircleBounds.centerY());
            matrix.postRotate((float)this.mStartAngle);
            matrix.postTranslate(this.mCircleBounds.centerX(), this.mCircleBounds.centerY());
            this.mBarPaint.getShader().setLocalMatrix(matrix);
        } else {
            this.mBarPaint.setColor(this.mBarColors[0]);
            this.mBarPaint.setShader(null);
        }
        this.mBarPaint.setAntiAlias(true);
        this.mBarPaint.setStrokeCap(this.mBarStrokeCap);
        this.mBarPaint.setStyle(Paint.Style.STROKE);
        this.mBarPaint.setStrokeWidth((float)this.mBarWidth);
    }

    protected void onDraw(Canvas canvas) {
        block25: {
            String string;
            block26: {
                float degrees;
                block27: {
                    block24: {
                        super.onDraw(canvas);
                        degrees = 360.0f / this.mMaxValue * this.mCurrentValue;
                        if (this.mBackgroundCircleColor != 0) {
                            canvas.drawArc(this.mInnerCircleBound, 360.0f, 360.0f, false, this.mBackgroundCirclePaint);
                        }
                        if (this.mRimWidth > 0) {
                            if (!this.mShowBlock) {
                                canvas.drawArc(this.mCircleBounds, 360.0f, 360.0f, false, this.mRimPaint);
                            } else {
                                this.drawBlocks$28c3c058(canvas, this.mCircleBounds, this.mStartAngle, 360.0f, this.mRimPaint);
                            }
                        }
                        if (this.mContourSize > 0.0f) {
                            canvas.drawArc(this.mCircleOuterContour, 360.0f, 360.0f, false, this.mContourPaint);
                            canvas.drawArc(this.mCircleInnerContour, 360.0f, 360.0f, false, this.mContourPaint);
                        }
                        if (this.mAnimationState != AnimationState.SPINNING && this.mAnimationState != AnimationState.END_SPINNING) break block24;
                        this.drawSpinner(canvas);
                        if (!this.mShowTextWhileSpinning) break block25;
                        break block26;
                    }
                    if (this.mAnimationState != AnimationState.END_SPINNING_START_ANIMATING) break block27;
                    this.drawSpinner(canvas);
                    if (this.mDrawBarWhileSpinning) break block27;
                    if (!this.mShowTextWhileSpinning) break block25;
                    break block26;
                }
                Canvas canvas2 = canvas;
                CircleProgressView circleProgressView = this;
                if (!circleProgressView.mShowBlock) {
                    canvas2.drawArc(circleProgressView.mCircleBounds, (float)circleProgressView.mStartAngle, degrees, false, circleProgressView.mBarPaint);
                } else {
                    circleProgressView.drawBlocks$28c3c058(canvas2, circleProgressView.mCircleBounds, circleProgressView.mStartAngle, degrees, circleProgressView.mBarPaint);
                }
            }
            Canvas canvas3 = canvas;
            CircleProgressView circleProgressView = this;
            boolean bl = false;
            if (circleProgressView.mIsAutoColorEnabled) {
                circleProgressView.mTextPaint.setColor(circleProgressView.getTextColor(circleProgressView.mCurrentValue));
            }
            switch (circleProgressView.mTextMode) {
                default: {
                    string = circleProgressView.mText != null ? circleProgressView.mText : "";
                    break;
                }
                case PERCENT: {
                    string = String.valueOf(Math.round(100.0f / circleProgressView.mMaxValue * circleProgressView.mCurrentValue));
                    break;
                }
                case VALUE: {
                    string = String.valueOf(Math.round(circleProgressView.mCurrentValue));
                }
            }
            if (circleProgressView.mIsAutoTextSize) {
                if (circleProgressView.mTextLength != string.length()) {
                    bl = true;
                    circleProgressView.mTextLength = string.length();
                    circleProgressView.mOuterTextBounds = circleProgressView.mTextLength == 1 ? new RectF(circleProgressView.mOuterTextBounds.left + circleProgressView.mOuterTextBounds.width() * 0.1f, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right - circleProgressView.mOuterTextBounds.width() * 0.1f, circleProgressView.mOuterTextBounds.bottom) : circleProgressView.getInnerCircleRect(circleProgressView.mCircleBounds);
                    RectF rectF = circleProgressView.mOuterTextBounds;
                    if (circleProgressView.mShowUnit) {
                        rectF = new RectF(circleProgressView.mOuterTextBounds.left, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right - circleProgressView.mOuterTextBounds.width() * circleProgressView.mRelativeUniteSize * 1.03f, circleProgressView.mOuterTextBounds.bottom);
                    }
                    circleProgressView.mTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(string, circleProgressView.mTextPaint, rectF) * circleProgressView.mTextScale);
                    circleProgressView.mActualTextBounds = CircleProgressView.getTextBounds(string, circleProgressView.mTextPaint, rectF);
                }
            } else if (circleProgressView.mTextLength != string.length()) {
                bl = true;
                circleProgressView.mTextPaint.setTextSize((float)circleProgressView.mTextSize);
                circleProgressView.mActualTextBounds = circleProgressView.mOuterTextBounds = CircleProgressView.getTextBounds(string, circleProgressView.mTextPaint, circleProgressView.mCircleBounds);
                if (circleProgressView.mShowUnit) {
                    circleProgressView.mUnitTextPaint.setTextSize((float)circleProgressView.mUnitSize);
                    circleProgressView.mUnitBounds = CircleProgressView.getTextBounds(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mCircleBounds);
                    float f = circleProgressView.mInnerCircleBound.width() * 0.045f / 2.0f;
                    circleProgressView.mOuterTextBounds = new RectF(circleProgressView.mOuterTextBounds.left - circleProgressView.mUnitBounds.width() / 2.0f - f, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right + circleProgressView.mUnitBounds.width() / 2.0f + f, circleProgressView.mOuterTextBounds.bottom);
                    circleProgressView.mActualTextBounds.offset(-(circleProgressView.mUnitBounds.width() / 2.0f) - f, 0.0f);
                }
            }
            canvas3.drawText(string, circleProgressView.mActualTextBounds.left - circleProgressView.mTextPaint.getTextSize() * 0.09f, circleProgressView.mActualTextBounds.bottom, circleProgressView.mTextPaint);
            if (circleProgressView.mShowUnit) {
                if (circleProgressView.mIsAutoColorEnabled) {
                    circleProgressView.mUnitTextPaint.setColor(circleProgressView.getTextColor(circleProgressView.mCurrentValue));
                }
                if (bl) {
                    if (circleProgressView.mIsAutoTextSize) {
                        circleProgressView.mUnitBounds = new RectF(circleProgressView.mOuterTextBounds.left + circleProgressView.mOuterTextBounds.width() * (1.0f - circleProgressView.mRelativeUniteSize) * 1.03f, circleProgressView.mOuterTextBounds.top, circleProgressView.mOuterTextBounds.right, circleProgressView.mOuterTextBounds.bottom);
                        circleProgressView.mUnitTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mUnitBounds) * circleProgressView.mUnitScale);
                        circleProgressView.mUnitBounds = CircleProgressView.getTextBounds(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mUnitBounds);
                    } else {
                        float f = circleProgressView.mInnerCircleBound.width() * 0.045f;
                        circleProgressView.mUnitTextPaint.setTextSize((float)circleProgressView.mUnitSize);
                        circleProgressView.mUnitBounds = CircleProgressView.getTextBounds(circleProgressView.mUnit, circleProgressView.mUnitTextPaint, circleProgressView.mCircleBounds);
                        float f2 = circleProgressView.mActualTextBounds.right - circleProgressView.mUnitBounds.left + f;
                        circleProgressView.mUnitBounds.offset(f2, 0.0f);
                    }
                    float f = circleProgressView.mActualTextBounds.top - circleProgressView.mUnitBounds.top;
                    circleProgressView.mUnitBounds.offset(0.0f, f);
                }
                canvas3.drawText(circleProgressView.mUnit, circleProgressView.mUnitBounds.left, circleProgressView.mUnitBounds.bottom, circleProgressView.mUnitTextPaint);
            }
        }
        if (this.mClippingBitmap != null) {
            canvas.drawBitmap(this.mClippingBitmap, 0.0f, 0.0f, this.mMaskPaint);
        }
    }

    private void drawSpinner(Canvas canvas) {
        if (this.mSpinningBarLengthCurrent < 0.0f) {
            this.mSpinningBarLengthCurrent = 1.0f;
        }
        float startAngle = (float)this.mStartAngle + this.mCurrentSpinnerDegreeValue - this.mSpinningBarLengthCurrent;
        canvas.drawArc(this.mCircleBounds, startAngle, this.mSpinningBarLengthCurrent, false, this.mBarSpinnerPaint);
    }

    private void drawBlocks$28c3c058(Canvas _canvas, RectF circleBounds, float startAngle, float _degrees, Paint paint) {
        for (float tmpDegree = 0.0f; tmpDegree < _degrees; tmpDegree += this.mBlockDegree) {
            _canvas.drawArc(circleBounds, startAngle + tmpDegree, Math.min(this.mBlockScaleDegree, _degrees - tmpDegree), false, paint);
        }
    }

    public void stopSpinning() {
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.STOP_SPINNING$48cb079c - 1);
    }

    public void spin() {
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.START_SPINNING$48cb079c - 1);
    }

    public void setValue(float _value) {
        Message msg = new Message();
        new Message().what = AnimationMsg.SET_VALUE$48cb079c - 1;
        msg.obj = new float[]{_value, _value};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_value);
    }

    public void setValueAnimated(float _valueFrom, float _valueTo, long _animationDuration) {
        this.mAnimationDuration = _animationDuration;
        Message msg = new Message();
        new Message().what = AnimationMsg.SET_VALUE_ANIMATED$48cb079c - 1;
        msg.obj = new float[]{_valueFrom, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_valueTo);
    }

    public void setValueAnimated(float _valueTo, long _animationDuration) {
        this.mAnimationDuration = _animationDuration;
        Message msg = new Message();
        new Message().what = AnimationMsg.SET_VALUE_ANIMATED$48cb079c - 1;
        msg.obj = new float[]{this.mCurrentValue, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_valueTo);
    }

    public void setValueAnimated(float _valueTo) {
        this.mAnimationDuration = 1200.0;
        Message msg = new Message();
        new Message().what = AnimationMsg.SET_VALUE_ANIMATED$48cb079c - 1;
        msg.obj = new float[]{this.mCurrentValue, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_valueTo);
    }

    private void triggerOnProgressChanged(float value) {
        if (this.onProgressChangedListener != null && value != this.previousProgressChangedValue) {
            this.onProgressChangedListener.onProgressChanged(value);
            this.previousProgressChangedValue = value;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.mSeekModeEnabled) {
            return super.onTouchEvent(event);
        }
        switch (event.getActionMasked()) {
            case 0: 
            case 1: {
                this.mTouchEventCount = 0;
                PointF point = new PointF(event.getX(), event.getY());
                float angle = CircleProgressView.normalizeAngle(Math.round(CircleProgressView.calcRotationAngleInDegrees(this.mCenter, point) - (double)this.mStartAngle));
                this.setValueAnimated(this.mMaxValue / 360.0f * angle, 800L);
                return true;
            }
            case 2: {
                ++this.mTouchEventCount;
                if (this.mTouchEventCount > 5) {
                    PointF point = new PointF(event.getX(), event.getY());
                    float angle = CircleProgressView.normalizeAngle(Math.round(CircleProgressView.calcRotationAngleInDegrees(this.mCenter, point) - (double)this.mStartAngle));
                    this.setValue(this.mMaxValue / 360.0f * angle);
                    return true;
                }
                return false;
            }
            case 3: {
                this.mTouchEventCount = 0;
                return false;
            }
        }
        return super.onTouchEvent(event);
    }

    public static float normalizeAngle(float _angle) {
        return (_angle % 360.0f + 360.0f) % 360.0f;
    }

    public static double calcRotationAngleInDegrees(PointF centerPt, PointF targetPt) {
        double d;
        double angle = Math.toDegrees(Math.atan2(targetPt.y - centerPt.y, targetPt.x - centerPt.x));
        if (d < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener listener) {
        this.onProgressChangedListener = listener;
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(float var1);
    }
}

