/*
 * Decompiled with CFR 0.152.
 */
package at.grabner.circleprogress;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import at.grabner.circleprogress.R;
import java.lang.ref.WeakReference;

public class CircleProgressView
extends View {
    private static final String TAG = "CircleView";
    private static final boolean DEBUG = false;
    private float mCurrentValue = 42.0f;
    private float mValueTo = 0.0f;
    private float mValueFrom = 0.0f;
    private float mMaxValue = 100.0f;
    private float mSpinningBarLengthCurrent = 0.0f;
    private float mSpinningBarLengthOrig = 42.0f;
    private float mCurrentSpinnerDegreeValue = 0.0f;
    private int mLayoutHeight = 0;
    private int mLayoutWidth = 0;
    private int mFullRadius = 100;
    private int mCircleRadius = 80;
    private int mBarWidth = 40;
    private int mRimWidth = 40;
    private int mTextSize = -1;
    private int mUnitSize = -1;
    private float mContourSize = 1.0f;
    private float mTextScale = 1.0f;
    private float mUnitScale = 1.0f;
    private int mPaddingTop = 5;
    private int mPaddingBottom = 5;
    private int mPaddingLeft = 5;
    private int mPaddingRight = 5;
    private final int mBarColorStandard = -16738680;
    private int mContourColor = -1442840576;
    private int mSpinnerColor = -16738680;
    private int mBackgroundCircleColor = 0;
    private int mRimColor = -1434201911;
    private int mTextColor = -16777216;
    private int mUnitColor = -16777216;
    private int[] mBarColors = new int[]{-16738680, -16738680};
    private Paint.Cap mBarStrokeCap = Paint.Cap.BUTT;
    private Paint.Cap mSpinnerStrokeCap = Paint.Cap.BUTT;
    private Paint mBarPaint = new Paint();
    private Paint mBarSpinnerPaint = new Paint();
    private Paint mBackgroundCirclePaint = new Paint();
    private Paint mRimPaint = new Paint();
    private Paint mTextPaint = new Paint();
    private Paint mUnitTextPaint = new Paint();
    private Paint mContourPaint = new Paint();
    private RectF mCircleBounds = new RectF();
    private RectF mInnerCircleBound = new RectF();
    private RectF mOuterTextBounds = new RectF();
    private RectF mActualTextBounds = new RectF();
    private RectF mUnitBounds = new RectF();
    private RectF mCircleOuterContour = new RectF();
    private RectF mCircleInnerContour = new RectF();
    private float mSpinSpeed = 2.8f;
    private double mAnimationDuration = 900.0;
    private int mDelayMillis = 15;
    private boolean mDrawArcWhileSpinning;
    private Handler mAnimationHandler = new AnimationHandler(this);
    private AnimationState mAnimationState = AnimationState.IDLE;
    private TimeInterpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private String mText = "";
    private String mUnit = "";
    private int mTextLength;
    private boolean mAutoTextValue;
    private boolean mAutoTextSize;
    private boolean mShowPercentAsAutoValue = true;
    private boolean mShowUnit = false;
    private Bitmap mClippingBitmap;
    private Paint mMaskPaint;
    private float mRelativeUniteSize = 0.3f;

    public CircleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributes(context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView));
        this.mMaskPaint = new Paint(1);
        this.mMaskPaint.setFilterBitmap(false);
        this.mMaskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    private void parseAttributes(TypedArray a) {
        this.setBarWidth((int)a.getDimension(R.styleable.CircleProgressView_barWidth, (float)this.mBarWidth));
        this.setRimWidth((int)a.getDimension(R.styleable.CircleProgressView_rimWidth, (float)this.mRimWidth));
        this.setSpinSpeed((int)a.getDimension(R.styleable.CircleProgressView_spinSpeed, this.mSpinSpeed));
        this.mBarColors = a.hasValue(R.styleable.CircleProgressView_barColor) && a.hasValue(R.styleable.CircleProgressView_barColor1) && a.hasValue(R.styleable.CircleProgressView_barColor2) && a.hasValue(R.styleable.CircleProgressView_barColor3) ? new int[]{a.getColor(R.styleable.CircleProgressView_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_barColor1, -16738680), a.getColor(R.styleable.CircleProgressView_barColor2, -16738680), a.getColor(R.styleable.CircleProgressView_barColor3, -16738680)} : (a.hasValue(R.styleable.CircleProgressView_barColor) && a.hasValue(R.styleable.CircleProgressView_barColor1) && a.hasValue(R.styleable.CircleProgressView_barColor2) ? new int[]{a.getColor(R.styleable.CircleProgressView_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_barColor1, -16738680), a.getColor(R.styleable.CircleProgressView_barColor2, -16738680)} : (a.hasValue(R.styleable.CircleProgressView_barColor) && a.hasValue(R.styleable.CircleProgressView_barColor1) ? new int[]{a.getColor(R.styleable.CircleProgressView_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_barColor1, -16738680)} : new int[]{a.getColor(R.styleable.CircleProgressView_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_barColor, -16738680)}));
        this.setSpinBarColor(a.getColor(R.styleable.CircleProgressView_spinColor, this.mSpinnerColor));
        this.mSpinningBarLengthOrig = a.getDimension(R.styleable.CircleProgressView_spinBarLength, this.mSpinningBarLengthOrig);
        this.setSpinningBarLength(this.mSpinningBarLengthOrig);
        this.setTextSize((int)a.getDimension(R.styleable.CircleProgressView_textSize, (float)this.mTextSize));
        this.setUnitSize((int)a.getDimension(R.styleable.CircleProgressView_unitSize, (float)this.mUnitSize));
        this.setTextColor(a.getColor(R.styleable.CircleProgressView_textColor, -1));
        this.setUnitColor(a.getColor(R.styleable.CircleProgressView_unitColor, -1));
        this.setText(a.getString(R.styleable.CircleProgressView_text));
        this.setRimColor(a.getColor(R.styleable.CircleProgressView_rimColor, this.mRimColor));
        this.setBackgroundCircleColor(a.getColor(R.styleable.CircleProgressView_fillColor, this.mBackgroundCircleColor));
        this.setContourColor(a.getColor(R.styleable.CircleProgressView_contourColor, this.mContourColor));
        this.setContourSize(a.getDimension(R.styleable.CircleProgressView_contourSize, this.mContourSize));
        this.setMaxValue(a.getDimension(R.styleable.CircleProgressView_maxValue, this.mMaxValue));
        this.setUnit(a.getString(R.styleable.CircleProgressView_unit));
        this.setShowUnit(a.getBoolean(R.styleable.CircleProgressView_showUnit, this.mShowUnit));
        this.setTextScale(a.getDimension(R.styleable.CircleProgressView_textScale, this.mTextScale));
        this.setUnitScale(a.getDimension(R.styleable.CircleProgressView_unitScale, this.mUnitScale));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = 0;
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heightWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        size = widthWithoutPadding > heightWithoutPadding ? heightWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    private RectF getInnerCircleRect(RectF _circleBounds) {
        double circleWidth = _circleBounds.width() - (float)Math.max(this.mBarWidth, this.mRimWidth) - this.mContourSize * 2.0f;
        double width = circleWidth / 2.0 * Math.sqrt(2.0);
        float widthDelta = (_circleBounds.width() - (float)width) / 2.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (this.isShowUnit()) {
            scaleX = 0.77f;
            scaleY = 1.33f;
        }
        return new RectF(_circleBounds.left + widthDelta * scaleX, _circleBounds.top + widthDelta * scaleY, _circleBounds.right - widthDelta * scaleX, _circleBounds.bottom - widthDelta * scaleY);
    }

    private float calcTextSizeForCircle(String _text, Paint _textPaint, RectF _circleBounds) {
        RectF innerCircleBounds = this.getInnerCircleRect(_circleBounds);
        return CircleProgressView.calcTextSizeForRect(_text, _textPaint, innerCircleBounds);
    }

    private static float calcTextSizeForRect(String _text, Paint _textPaint, RectF _rectBounds) {
        Matrix matrix = new Matrix();
        Rect textBoundsTmp = new Rect();
        _textPaint.getTextBounds(_text, 0, _text.length(), textBoundsTmp);
        RectF textBoundsTmpF = new RectF(textBoundsTmp);
        matrix.setRectToRect(textBoundsTmpF, _rectBounds, Matrix.ScaleToFit.CENTER);
        float[] values = new float[9];
        matrix.getValues(values);
        return _textPaint.getTextSize() * values[0];
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mLayoutWidth = w;
        this.mLayoutHeight = h;
        this.setupBounds();
        this.setupBarPaint();
        if (this.mClippingBitmap != null) {
            this.mClippingBitmap = Bitmap.createScaledBitmap((Bitmap)this.mClippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false);
        }
        this.invalidate();
    }

    public int getUnitSize() {
        return this.mUnitSize;
    }

    public void setRelativeUniteSize(float _relativeUniteSize) {
        this.mRelativeUniteSize = _relativeUniteSize;
    }

    public Paint.Cap getSpinnerStrokeCap() {
        return this.mSpinnerStrokeCap;
    }

    public void setSpinnerStrokeCap(Paint.Cap _spinnerStrokeCap) {
        this.mSpinnerStrokeCap = _spinnerStrokeCap;
    }

    public Paint.Cap getBarStrokeCap() {
        return this.mBarStrokeCap;
    }

    public void setBarStrokeCap(Paint.Cap _barStrokeCap) {
        this.mBarStrokeCap = _barStrokeCap;
    }

    public int getContourColor() {
        return this.mContourColor;
    }

    public void setContourColor(int _contourColor) {
        this.mContourColor = _contourColor;
        this.setupContourPaint();
    }

    public float getContourSize() {
        return this.mContourSize;
    }

    public void setContourSize(float _contourSize) {
        this.mContourSize = _contourSize;
        this.setupContourPaint();
    }

    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.mText = "";
            this.mAutoTextValue = true;
        } else {
            this.mText = text;
            this.mAutoTextValue = false;
        }
        this.invalidate();
    }

    public String getUnit() {
        return this.mUnit;
    }

    public void setUnit(String _unit) {
        this.mUnit = _unit == null ? "" : _unit;
        this.invalidate();
    }

    private RectF getTextBounds(String _text, Paint _textPaint, RectF _textBounds) {
        Rect textBoundsTmp = new Rect();
        _textPaint.getTextBounds(_text, 0, _text.length(), textBoundsTmp);
        RectF textRect = new RectF();
        textRect.left = _textBounds.left + (_textBounds.width() - (float)textBoundsTmp.width()) / 2.0f;
        textRect.top = _textBounds.top + (_textBounds.height() - (float)textBoundsTmp.height()) / 2.0f;
        textRect.right = textRect.left + (float)textBoundsTmp.width();
        textRect.bottom = textRect.top + (float)textBoundsTmp.height();
        return textRect;
    }

    public boolean isShowPercentAsAutoValue() {
        return this.mShowPercentAsAutoValue;
    }

    public void setShowPercentAsAutoValue(boolean _showPercentAsAutoValue) {
        this.mShowPercentAsAutoValue = _showPercentAsAutoValue;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        if (textSize > 0) {
            this.mTextSize = textSize;
            this.mAutoTextSize = false;
        } else {
            this.mAutoTextSize = true;
        }
    }

    public void setUnitSize(int unitSize) {
        this.mUnitSize = unitSize > 0 ? unitSize : 1;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(float _maxValue) {
        this.mMaxValue = _maxValue;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.mPaddingTop = paddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.mPaddingBottom = paddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.mPaddingLeft = paddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.mPaddingRight = paddingRight;
    }

    public int getCircleRadius() {
        return this.mCircleRadius;
    }

    public boolean isShowUnit() {
        return this.mShowUnit;
    }

    public void setShowUnit(boolean _showUnit) {
        this.mShowUnit = _showUnit;
        this.mTextLength = 0;
        this.invalidate();
        this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
    }

    public float getUnitScale() {
        return this.mUnitScale;
    }

    public void setUnitScale(float _unitScale) {
        this.mUnitScale = _unitScale;
    }

    public float getTextScale() {
        return this.mTextScale;
    }

    public void setTextScale(float _textScale) {
        this.mTextScale = _textScale;
    }

    public void setSpinningBarLength(float barLength) {
        this.mSpinningBarLengthCurrent = this.mSpinningBarLengthOrig = barLength;
    }

    public int getBarWidth() {
        return this.mBarWidth;
    }

    public void setBarWidth(int barWidth) {
        this.mBarWidth = barWidth;
        this.setupBarSpinnerPaint();
        this.setupBarPaint();
    }

    public int[] getBarColors() {
        return this.mBarColors;
    }

    public void setBarColor(int ... barColors) {
        this.mBarColors = barColors.length == 1 ? new int[]{barColors[0], barColors[0]} : barColors;
        this.setupBarPaint();
    }

    public void setSpinBarColor(int _color) {
        this.mSpinnerColor = _color;
        this.setupBarSpinnerPaint();
    }

    public int getBackgroundCircleColor() {
        return this.mBackgroundCircleColor;
    }

    public void setBackgroundCircleColor(int circleColor) {
        this.mBackgroundCircleColor = circleColor;
        this.setupBackgroundCirclePaint();
    }

    public int getRimColor() {
        return this.mRimColor;
    }

    public void setRimColor(int rimColor) {
        this.mRimColor = rimColor;
        this.setupRimPaint();
    }

    public Shader getRimShader() {
        return this.mRimPaint.getShader();
    }

    public void setRimShader(Shader shader) {
        this.mRimPaint.setShader(shader);
    }

    public int getTextColor(double value) {
        double percent = 1.0 / this.getMaxValue() * value;
        int index = (int)((double)this.mBarColors.length * percent);
        return this.mBarColors[index >= this.mBarColors.length ? this.mBarColors.length - 1 : index];
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.setupTextPaint();
    }

    public void setUnitColor(int unitColor) {
        this.mUnitColor = unitColor;
        this.setupUnitTextPaint();
    }

    public float getSpinSpeed() {
        return this.mSpinSpeed;
    }

    public void setSpinSpeed(float spinSpeed) {
        this.mSpinSpeed = spinSpeed;
    }

    public int getRimWidth() {
        return this.mRimWidth;
    }

    public void setRimWidth(int rimWidth) {
        this.mRimWidth = rimWidth;
        this.setupRimPaint();
    }

    public int getDelayMillis() {
        return this.mDelayMillis;
    }

    public void setDelayMillis(int delayMillis) {
        this.mDelayMillis = delayMillis;
    }

    public void setClippingBitmap(Bitmap _clippingBitmap) {
        this.mClippingBitmap = this.getWidth() > 0 && this.getHeight() > 0 ? Bitmap.createScaledBitmap((Bitmap)_clippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false) : _clippingBitmap;
        if (this.mClippingBitmap == null) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
        }
    }

    public float getRelativeUniteSize() {
        return this.mRelativeUniteSize;
    }

    private void setupContourPaint() {
        this.mContourPaint.setColor(this.mContourColor);
        this.mContourPaint.setAntiAlias(true);
        this.mContourPaint.setStyle(Paint.Style.STROKE);
        this.mContourPaint.setStrokeWidth(this.mContourSize);
    }

    private void setupUnitTextPaint() {
        this.mUnitTextPaint.setColor(this.mUnitColor);
        this.mUnitTextPaint.setStyle(Paint.Style.FILL);
        this.mUnitTextPaint.setAntiAlias(true);
        if (this.mUnitSize > 0) {
            this.mUnitTextPaint.setTextSize((float)this.mUnitSize);
        }
    }

    private void setupTextPaint() {
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setAntiAlias(true);
        if (this.mTextSize > 0) {
            this.mTextPaint.setTextSize((float)this.mTextSize);
        }
    }

    private void setupBackgroundCirclePaint() {
        this.mBackgroundCirclePaint.setColor(this.mBackgroundCircleColor);
        this.mBackgroundCirclePaint.setAntiAlias(true);
        this.mBackgroundCirclePaint.setStyle(Paint.Style.FILL);
    }

    private void setupRimPaint() {
        this.mRimPaint.setColor(this.mRimColor);
        this.mRimPaint.setAntiAlias(true);
        this.mRimPaint.setStyle(Paint.Style.STROKE);
        this.mRimPaint.setStrokeWidth((float)this.mRimWidth);
    }

    private void setupBarSpinnerPaint() {
        this.mBarSpinnerPaint.setAntiAlias(true);
        this.mBarSpinnerPaint.setStrokeCap(this.mSpinnerStrokeCap);
        this.mBarSpinnerPaint.setStyle(Paint.Style.STROKE);
        this.mBarSpinnerPaint.setStrokeWidth((float)this.mBarWidth);
        this.mBarSpinnerPaint.setColor(this.mSpinnerColor);
    }

    private void setupBarPaint() {
        this.mBarPaint.setShader((Shader)new SweepGradient(this.mCircleBounds.centerX(), this.mCircleBounds.centerY(), this.mBarColors, null));
        Matrix matrix = new Matrix();
        this.mBarPaint.getShader().getLocalMatrix(matrix);
        matrix.postTranslate(-this.mCircleBounds.centerX(), -this.mCircleBounds.centerY());
        matrix.postRotate(-90.0f);
        matrix.postTranslate(this.mCircleBounds.centerX(), this.mCircleBounds.centerY());
        this.mBarPaint.getShader().setLocalMatrix(matrix);
        this.mBarPaint.setAntiAlias(true);
        this.mBarPaint.setStrokeCap(this.mBarStrokeCap);
        this.mBarPaint.setStyle(Paint.Style.STROKE);
        this.mBarPaint.setStrokeWidth((float)this.mBarWidth);
    }

    private void setupBounds() {
        int minValue = Math.min(this.mLayoutWidth, this.mLayoutHeight);
        int xOffset = this.mLayoutWidth - minValue;
        int yOffset = this.mLayoutHeight - minValue;
        this.mPaddingTop = this.getPaddingTop() + yOffset / 2;
        this.mPaddingBottom = this.getPaddingBottom() + yOffset / 2;
        this.mPaddingLeft = this.getPaddingLeft() + xOffset / 2;
        this.mPaddingRight = this.getPaddingRight() + xOffset / 2;
        int width = this.getWidth();
        int height = this.getHeight();
        this.mCircleBounds = new RectF((float)(this.mPaddingLeft + this.mBarWidth), (float)(this.mPaddingTop + this.mBarWidth), (float)(width - this.mPaddingRight - this.mBarWidth), (float)(height - this.mPaddingBottom - this.mBarWidth));
        this.mInnerCircleBound = new RectF((float)this.mPaddingLeft + (float)this.mBarWidth * 1.5f, (float)this.mPaddingTop + (float)this.mBarWidth * 1.5f, (float)(width - this.mPaddingRight) - (float)this.mBarWidth * 1.5f, (float)(height - this.mPaddingBottom) - (float)this.mBarWidth * 1.5f);
        this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
        this.mCircleInnerContour = new RectF(this.mCircleBounds.left + (float)this.mRimWidth / 2.0f + this.mContourSize / 2.0f, this.mCircleBounds.top + (float)this.mRimWidth / 2.0f + this.mContourSize / 2.0f, this.mCircleBounds.right - (float)this.mRimWidth / 2.0f - this.mContourSize / 2.0f, this.mCircleBounds.bottom - (float)this.mRimWidth / 2.0f - this.mContourSize / 2.0f);
        this.mCircleOuterContour = new RectF(this.mCircleBounds.left - (float)this.mRimWidth / 2.0f - this.mContourSize / 2.0f, this.mCircleBounds.top - (float)this.mRimWidth / 2.0f - this.mContourSize / 2.0f, this.mCircleBounds.right + (float)this.mRimWidth / 2.0f + this.mContourSize / 2.0f, this.mCircleBounds.bottom + (float)this.mRimWidth / 2.0f + this.mContourSize / 2.0f);
        this.mFullRadius = (width - this.mPaddingRight - this.mBarWidth) / 2;
        this.mCircleRadius = this.mFullRadius - this.mBarWidth + 1;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float degrees = 360.0f / this.mMaxValue * this.mCurrentValue;
        canvas.drawArc(this.mInnerCircleBound, 360.0f, 360.0f, false, this.mBackgroundCirclePaint);
        if (this.mRimWidth > 0) {
            canvas.drawArc(this.mCircleBounds, 360.0f, 360.0f, false, this.mRimPaint);
        }
        if (this.mContourSize > 0.0f) {
            canvas.drawArc(this.mCircleOuterContour, 360.0f, 360.0f, false, this.mContourPaint);
            canvas.drawArc(this.mCircleInnerContour, 360.0f, 360.0f, false, this.mContourPaint);
        }
        if (this.mAnimationState == AnimationState.SPINNING || this.mAnimationState == AnimationState.END_SPINNING) {
            this.drawSpinner(canvas);
        } else if (this.mAnimationState == AnimationState.END_SPINNING_START_ANIMATING) {
            this.drawSpinner(canvas);
            if (this.mDrawArcWhileSpinning) {
                this.drawCircleWithNumber(canvas, degrees);
            }
        } else {
            this.drawCircleWithNumber(canvas, degrees);
            this.drawCircleWithNumber(canvas, degrees);
        }
        if (this.mClippingBitmap != null) {
            canvas.drawBitmap(this.mClippingBitmap, 0.0f, 0.0f, this.mMaskPaint);
        }
    }

    private void drawSpinner(Canvas canvas) {
        if (this.mSpinningBarLengthCurrent < 0.0f) {
            this.mSpinningBarLengthCurrent = 1.0f;
        }
        float startAngle = this.mCurrentSpinnerDegreeValue - 90.0f - this.mSpinningBarLengthCurrent;
        canvas.drawArc(this.mCircleBounds, startAngle, this.mSpinningBarLengthCurrent, false, this.mBarSpinnerPaint);
    }

    private void drawDebug(Canvas canvas) {
        Paint innerRectPaint = new Paint();
        innerRectPaint.setColor(-256);
        canvas.drawRect(this.mCircleBounds, innerRectPaint);
        innerRectPaint.setColor(-65281);
        canvas.drawRect(this.mOuterTextBounds, innerRectPaint);
    }

    private void drawCircleWithNumber(Canvas canvas, float _degrees) {
        float relativeGap = 1.03f;
        boolean update = false;
        canvas.drawArc(this.mCircleBounds, -90.0f, _degrees, false, this.mBarPaint);
        this.mTextPaint.setSubpixelText(true);
        this.mTextPaint.setLinearText(true);
        this.mTextPaint.setTypeface(Typeface.MONOSPACE);
        if (this.mTextColor == -1) {
            this.mTextPaint.setColor(this.getTextColor(this.mCurrentValue));
        }
        String text = this.mText;
        if (this.mAutoTextValue) {
            if (this.mShowPercentAsAutoValue) {
                int percent = (int)(100.0f / this.mMaxValue * this.mCurrentValue);
                text = String.valueOf(percent);
            } else {
                text = String.valueOf((int)this.mCurrentValue);
            }
        }
        if (this.mAutoTextSize) {
            if (this.mTextLength != text.length()) {
                update = true;
                this.mTextLength = text.length();
                this.mOuterTextBounds = this.mTextLength == 1 ? new RectF(this.mOuterTextBounds.left + this.mOuterTextBounds.width() * 0.1f, this.mOuterTextBounds.top, this.mOuterTextBounds.right - this.mOuterTextBounds.width() * 0.1f, this.mOuterTextBounds.bottom) : this.getInnerCircleRect(this.mCircleBounds);
                RectF textRect = this.mOuterTextBounds;
                if (this.mShowUnit) {
                    textRect = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.top, this.mOuterTextBounds.right - this.mOuterTextBounds.width() * this.mRelativeUniteSize * 1.03f, this.mOuterTextBounds.bottom);
                }
                this.mTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(text, this.mTextPaint, textRect) * this.mTextScale);
                this.mActualTextBounds = this.getTextBounds(text, this.mTextPaint, textRect);
            }
        } else if (this.mTextLength != text.length()) {
            update = true;
            this.mTextLength = text.length();
            this.mTextPaint.setTextSize((float)this.mTextSize);
            this.mActualTextBounds = this.mOuterTextBounds = this.getTextBounds(text, this.mTextPaint, this.mCircleBounds);
            if (this.mShowUnit) {
                this.mUnitTextPaint.setTextSize((float)this.mUnitSize);
                this.mUnitBounds = this.getTextBounds(this.mUnit, this.mUnitTextPaint, this.mCircleBounds);
                float gapWidthHalf = this.mInnerCircleBound.width() * 0.05f / 2.0f;
                this.mOuterTextBounds = new RectF(this.mOuterTextBounds.left - this.mUnitBounds.width() / 2.0f - gapWidthHalf, this.mOuterTextBounds.top, this.mOuterTextBounds.right + this.mUnitBounds.width() / 2.0f + gapWidthHalf, this.mOuterTextBounds.bottom);
                this.mActualTextBounds.offset(-(this.mUnitBounds.width() / 2.0f) - gapWidthHalf, 0.0f);
            }
        }
        canvas.drawText(text, this.mActualTextBounds.left - this.mTextPaint.getTextSize() * 0.09f, this.mActualTextBounds.bottom, this.mTextPaint);
        if (this.mShowUnit) {
            if (this.mUnitColor == -1) {
                this.mUnitTextPaint.setColor(this.getTextColor(this.mCurrentValue));
            }
            if (update) {
                if (this.mAutoTextSize) {
                    this.mUnitTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(this.mUnit, this.mUnitTextPaint, this.mUnitBounds) * this.mUnitScale);
                    this.mUnitBounds = new RectF(this.mOuterTextBounds.left + this.mOuterTextBounds.width() * (1.0f - this.mRelativeUniteSize) * 1.03f, this.mOuterTextBounds.top, this.mOuterTextBounds.right, this.mOuterTextBounds.bottom);
                    this.mUnitBounds = this.getTextBounds(this.mUnit, this.mUnitTextPaint, this.mUnitBounds);
                } else {
                    float gapWidth = this.mInnerCircleBound.width() * 0.05f;
                    this.mUnitTextPaint.setTextSize((float)this.mUnitSize);
                    this.mUnitBounds = this.getTextBounds(this.mUnit, this.mUnitTextPaint, this.mCircleBounds);
                    float dx = this.mActualTextBounds.right - this.mUnitBounds.left + gapWidth;
                    this.mUnitBounds.offset(dx, 0.0f);
                }
                float dy = this.mActualTextBounds.top - this.mUnitBounds.top;
                this.mUnitBounds.offset(0.0f, dy);
            }
            canvas.drawText(this.mUnit, this.mUnitBounds.left, this.mUnitBounds.bottom, this.mUnitTextPaint);
        }
    }

    public void stopSpinning() {
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.STOP_SPINNING.ordinal());
    }

    public void spin() {
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.START_SPINNING.ordinal());
    }

    public void setValue(float _value) {
        Message msg = new Message();
        msg.what = AnimationMsg.SET_VALUE.ordinal();
        msg.obj = new float[]{_value, _value};
        this.mAnimationHandler.sendMessage(msg);
    }

    public void setValueAnimated(float _valueFrom, float _valueTo, long _animationDuration) {
        this.mAnimationDuration = _animationDuration;
        Message msg = new Message();
        msg.what = AnimationMsg.SET_VALUE_ANIMATED.ordinal();
        msg.obj = new float[]{_valueFrom, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
    }

    public void setValueAnimated(float _valueTo, long _animationDuration) {
        this.mAnimationDuration = _animationDuration;
        Message msg = new Message();
        msg.what = AnimationMsg.SET_VALUE_ANIMATED.ordinal();
        msg.obj = new float[]{this.mCurrentValue, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
    }

    public void setValueAnimated(float _valueTo) {
        this.mAnimationDuration = 1200.0;
        Message msg = new Message();
        msg.what = AnimationMsg.SET_VALUE_ANIMATED.ordinal();
        msg.obj = new float[]{this.mCurrentValue, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
    }

    private static class AnimationHandler
    extends Handler {
        private final WeakReference<CircleProgressView> mCircleViewWeakReference;
        private float mSpinningBarLengthStart;
        private long mAnimationStartTime;
        private long mLengthChangeAnimationStartTime;
        private TimeInterpolator mLengthChangeInterpolator = new DecelerateInterpolator();
        private double mLengthChangeAnimationDuration;

        AnimationHandler(CircleProgressView _circleView) {
            super(_circleView.getContext().getMainLooper());
            this.mCircleViewWeakReference = new WeakReference<CircleProgressView>(_circleView);
        }

        public void handleMessage(Message msg) {
            CircleProgressView circleView = (CircleProgressView)((Object)this.mCircleViewWeakReference.get());
            if (circleView == null) {
                return;
            }
            AnimationMsg msgType = AnimationMsg.values()[msg.what];
            if (msgType == AnimationMsg.TICK) {
                this.removeMessages(AnimationMsg.TICK.ordinal());
            }
            block0 : switch (circleView.mAnimationState) {
                case IDLE: {
                    switch (msgType) {
                        case START_SPINNING: {
                            this.enterSpinning(circleView);
                            break;
                        }
                        case STOP_SPINNING: {
                            break;
                        }
                        case SET_VALUE: {
                            this.setValue(msg, circleView);
                            break;
                        }
                        case SET_VALUE_ANIMATED: {
                            this.enterSetValueAnimated(msg, circleView);
                            break;
                        }
                        case TICK: {
                            this.removeMessages(AnimationMsg.TICK.ordinal());
                        }
                    }
                    break;
                }
                case SPINNING: {
                    switch (msgType) {
                        case START_SPINNING: {
                            break;
                        }
                        case STOP_SPINNING: {
                            this.enterEndSpinning(circleView);
                            break;
                        }
                        case SET_VALUE: {
                            this.setValue(msg, circleView);
                            break;
                        }
                        case SET_VALUE_ANIMATED: {
                            this.enterEndSpinningStartAnimating(circleView, msg);
                            break;
                        }
                        case TICK: {
                            float length_delta = circleView.mSpinningBarLengthCurrent - circleView.mSpinningBarLengthOrig;
                            float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                            t = t > 1.0f ? 1.0f : t;
                            float interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                            if (Math.abs(length_delta) < 1.0f) {
                                circleView.mSpinningBarLengthCurrent = circleView.mSpinningBarLengthOrig;
                            } else if (circleView.mSpinningBarLengthCurrent < circleView.mSpinningBarLengthOrig) {
                                circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart + (circleView.mSpinningBarLengthOrig - this.mSpinningBarLengthStart) * interpolatedRatio;
                            } else {
                                circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart - (this.mSpinningBarLengthStart - circleView.mSpinningBarLengthOrig) * interpolatedRatio;
                            }
                            CircleProgressView circleProgressView = circleView;
                            circleProgressView.mCurrentSpinnerDegreeValue = circleProgressView.mCurrentSpinnerDegreeValue + circleView.mSpinSpeed;
                            if (circleView.mCurrentSpinnerDegreeValue > 360.0f) {
                                circleView.mCurrentSpinnerDegreeValue = 0.0f;
                            }
                            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
                            circleView.invalidate();
                        }
                    }
                    break;
                }
                case END_SPINNING: {
                    switch (msgType) {
                        case START_SPINNING: {
                            circleView.mAnimationState = AnimationState.SPINNING;
                            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
                            break;
                        }
                        case STOP_SPINNING: {
                            break;
                        }
                        case SET_VALUE: {
                            this.setValue(msg, circleView);
                            break;
                        }
                        case SET_VALUE_ANIMATED: {
                            this.enterEndSpinningStartAnimating(circleView, msg);
                            break;
                        }
                        case TICK: {
                            float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                            t = t > 1.0f ? 1.0f : t;
                            float interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                            circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                            CircleProgressView circleProgressView = circleView;
                            circleProgressView.mCurrentSpinnerDegreeValue = circleProgressView.mCurrentSpinnerDegreeValue + circleView.mSpinSpeed;
                            if (circleView.mSpinningBarLengthCurrent < 0.01f) {
                                circleView.mAnimationState = AnimationState.IDLE;
                            }
                            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
                            circleView.invalidate();
                        }
                    }
                    break;
                }
                case END_SPINNING_START_ANIMATING: {
                    switch (msgType) {
                        case START_SPINNING: {
                            circleView.mDrawArcWhileSpinning = false;
                            this.enterSpinning(circleView);
                            break;
                        }
                        case STOP_SPINNING: {
                            break;
                        }
                        case SET_VALUE: {
                            circleView.mDrawArcWhileSpinning = false;
                            this.setValue(msg, circleView);
                            break;
                        }
                        case SET_VALUE_ANIMATED: {
                            circleView.mValueFrom = 0.0f;
                            circleView.mValueTo = ((float[])msg.obj)[1];
                            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
                            break;
                        }
                        case TICK: {
                            float interpolatedRatio;
                            if (circleView.mSpinningBarLengthCurrent > circleView.mSpinningBarLengthOrig && !circleView.mDrawArcWhileSpinning) {
                                float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                                t = t > 1.0f ? 1.0f : t;
                                interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                                circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                            }
                            CircleProgressView t = circleView;
                            t.mCurrentSpinnerDegreeValue = t.mCurrentSpinnerDegreeValue + circleView.mSpinSpeed;
                            if (circleView.mCurrentSpinnerDegreeValue > 360.0f && !circleView.mDrawArcWhileSpinning) {
                                this.mAnimationStartTime = System.currentTimeMillis();
                                circleView.mDrawArcWhileSpinning = true;
                                this.initReduceAnimation(circleView);
                            }
                            if (circleView.mDrawArcWhileSpinning) {
                                circleView.mCurrentSpinnerDegreeValue = 360.0f;
                                t = circleView;
                                t.mSpinningBarLengthCurrent = t.mSpinningBarLengthCurrent - circleView.mSpinSpeed;
                                this.calcNextAnimationValue(circleView);
                                float t2 = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                                t2 = t2 > 1.0f ? 1.0f : t2;
                                interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t2);
                                circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                            }
                            if ((double)circleView.mSpinningBarLengthCurrent < 0.1) {
                                circleView.mAnimationState = AnimationState.ANIMATING;
                                circleView.invalidate();
                                circleView.mDrawArcWhileSpinning = false;
                                circleView.mSpinningBarLengthCurrent = circleView.mSpinningBarLengthOrig;
                            } else {
                                circleView.invalidate();
                            }
                            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
                        }
                    }
                    break;
                }
                case ANIMATING: {
                    switch (msgType) {
                        case START_SPINNING: {
                            this.enterSpinning(circleView);
                            break block0;
                        }
                        case STOP_SPINNING: {
                            break block0;
                        }
                        case SET_VALUE: {
                            this.setValue(msg, circleView);
                            break block0;
                        }
                        case SET_VALUE_ANIMATED: {
                            this.mAnimationStartTime = System.currentTimeMillis();
                            circleView.mValueFrom = circleView.mCurrentValue;
                            circleView.mValueTo = ((float[])msg.obj)[1];
                            break block0;
                        }
                        case TICK: {
                            if (this.calcNextAnimationValue(circleView)) {
                                circleView.mAnimationState = AnimationState.IDLE;
                                circleView.mCurrentValue = circleView.mValueTo;
                            }
                            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
                            circleView.invalidate();
                        }
                    }
                }
            }
        }

        private void enterSetValueAnimated(Message msg, CircleProgressView _circleView) {
            _circleView.mValueFrom = ((float[])msg.obj)[0];
            _circleView.mValueTo = ((float[])msg.obj)[1];
            this.mAnimationStartTime = System.currentTimeMillis();
            _circleView.mAnimationState = AnimationState.ANIMATING;
            _circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)_circleView.mDelayMillis);
        }

        private void enterEndSpinningStartAnimating(CircleProgressView circleView, Message msg) {
            circleView.mAnimationState = AnimationState.END_SPINNING_START_ANIMATING;
            circleView.mValueFrom = 0.0f;
            circleView.mValueTo = ((float[])msg.obj)[1];
            this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
            this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
        }

        private void enterEndSpinning(CircleProgressView circleView) {
            circleView.mAnimationState = AnimationState.END_SPINNING;
            this.initReduceAnimation(circleView);
            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
        }

        private void initReduceAnimation(CircleProgressView circleView) {
            float degreesTillFinish = circleView.mSpinningBarLengthCurrent;
            float stepsTillFinish = degreesTillFinish / circleView.mSpinSpeed;
            this.mLengthChangeAnimationDuration = stepsTillFinish * (float)circleView.mDelayMillis * 2.0f;
            this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
            this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
        }

        private void enterSpinning(CircleProgressView circleView) {
            circleView.mAnimationState = AnimationState.SPINNING;
            circleView.mSpinningBarLengthCurrent = 360.0f / circleView.mMaxValue * circleView.mCurrentValue;
            circleView.mCurrentSpinnerDegreeValue = 360.0f / circleView.mMaxValue * circleView.mCurrentValue;
            this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
            this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
            float stepsTillFinish = circleView.mSpinningBarLengthOrig / circleView.mSpinSpeed;
            this.mLengthChangeAnimationDuration = stepsTillFinish * (float)circleView.mDelayMillis * 2.0f;
            circleView.mAnimationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mDelayMillis);
        }

        private boolean calcNextAnimationValue(CircleProgressView _circleView) {
            float t = (float)((double)(System.currentTimeMillis() - this.mAnimationStartTime) / _circleView.mAnimationDuration);
            t = t > 1.0f ? 1.0f : t;
            float interpolatedRatio = _circleView.mInterpolator.getInterpolation(t);
            _circleView.mCurrentValue = _circleView.mValueFrom + (_circleView.mValueTo - _circleView.mValueFrom) * interpolatedRatio;
            return t >= 1.0f;
        }

        private void setValue(Message msg, CircleProgressView _circleView) {
            _circleView.mValueFrom = _circleView.mValueTo;
            _circleView.mCurrentValue = (_circleView.mValueTo = ((float[])msg.obj)[0]);
            _circleView.mAnimationState = AnimationState.IDLE;
            _circleView.invalidate();
        }
    }

    private static enum AnimationMsg {
        START_SPINNING,
        STOP_SPINNING,
        SET_VALUE,
        SET_VALUE_ANIMATED,
        TICK;

    }

    private static enum AnimationState {
        IDLE,
        SPINNING,
        END_SPINNING,
        END_SPINNING_START_ANIMATING,
        ANIMATING;

    }
}

