/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.zugferd;

import com.itextpdf.text.io.StreamUtil;
import com.itextpdf.text.zugferd.checkers.NumberChecker;
import com.itextpdf.text.zugferd.checkers.basic.CountryCode;
import com.itextpdf.text.zugferd.checkers.basic.CurrencyCode;
import com.itextpdf.text.zugferd.checkers.basic.DateFormatCode;
import com.itextpdf.text.zugferd.checkers.basic.DocumentTypeCode;
import com.itextpdf.text.zugferd.checkers.basic.MeasurementUnitCode;
import com.itextpdf.text.zugferd.checkers.basic.TaxIDTypeCode;
import com.itextpdf.text.zugferd.checkers.basic.TaxTypeCode;
import com.itextpdf.text.zugferd.checkers.comfort.FreeTextSubjectCode;
import com.itextpdf.text.zugferd.checkers.comfort.GlobalIdentifierCode;
import com.itextpdf.text.zugferd.checkers.comfort.PaymentMeansCode;
import com.itextpdf.text.zugferd.checkers.comfort.TaxCategoryCode;
import com.itextpdf.text.zugferd.exceptions.DataIncompleteException;
import com.itextpdf.text.zugferd.exceptions.InvalidCodeException;
import com.itextpdf.text.zugferd.profiles.BasicProfile;
import com.itextpdf.text.zugferd.profiles.ComfortProfile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InvoiceDOM {
    public static final CountryCode COUNTRY_CODE = new CountryCode();
    public static final CurrencyCode CURR_CODE = new CurrencyCode();
    public static final DateFormatCode DF_CODE = new DateFormatCode();
    public static final GlobalIdentifierCode GI_CODE = new GlobalIdentifierCode();
    public static final MeasurementUnitCode M_UNIT_CODE = new MeasurementUnitCode();
    public static final NumberChecker DEC2 = new NumberChecker(2);
    public static final NumberChecker DEC4 = new NumberChecker(4);
    public static final PaymentMeansCode PM_CODE = new PaymentMeansCode();
    public static final TaxCategoryCode TC_CODE = new TaxCategoryCode();
    public static final TaxIDTypeCode TIDT_CODE = new TaxIDTypeCode();
    public static final TaxTypeCode TT_CODE = new TaxTypeCode();
    protected final Document doc;

    public InvoiceDOM(BasicProfile data) throws ParserConfigurationException, SAXException, IOException, DataIncompleteException, InvalidCodeException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new SafeEmptyEntityResolver());
        InputStream is = StreamUtil.getResourceStream((String)"com/itextpdf/text/zugferd/zugferd-template.xml");
        this.doc = docBuilder.parse(is);
        this.importData(this.doc, data);
    }

    private void importData(Document doc, BasicProfile data) throws DataIncompleteException, InvalidCodeException {
        if (!data.getTestIndicator()) {
            throw new InvalidCodeException("false", "the test indicator: the ZUGFeRD functionality is still in beta; contact sales@itextpdf.com for more info.");
        }
        this.importSpecifiedExchangedDocumentContext((Element)doc.getElementsByTagName("rsm:SpecifiedExchangedDocumentContext").item(0), data);
        this.importHeaderExchangedDocument((Element)doc.getElementsByTagName("rsm:HeaderExchangedDocument").item(0), data);
        this.importSpecifiedSupplyChainTradeTransaction((Element)doc.getElementsByTagName("rsm:SpecifiedSupplyChainTradeTransaction").item(0), data);
    }

    protected void importSpecifiedExchangedDocumentContext(Element element, BasicProfile data) {
        this.importContent(element, "udt:Indicator", data.getTestIndicator() ? "true" : "false", new String[0]);
    }

    protected void importHeaderExchangedDocument(Element element, BasicProfile data) throws DataIncompleteException, InvalidCodeException {
        this.check(data.getId(), "HeaderExchangedDocument > ID");
        this.importContent(element, "ram:ID", data.getId(), new String[0]);
        this.check(data.getName(), "HeaderExchangedDocument > Name");
        this.importContent(element, "ram:Name", data.getName(), new String[0]);
        DocumentTypeCode dtCode = new DocumentTypeCode(data instanceof ComfortProfile ? 1 : 0);
        this.importContent(element, "ram:TypeCode", dtCode.check(data.getTypeCode()), new String[0]);
        this.check(data.getDateTimeFormat(), "HeaderExchangedDocument > DateTimeString");
        this.importDateTime(element, "udt:DateTimeString", data.getDateTimeFormat(), data.getDateTime());
        String[][] notes = data.getNotes();
        String[] notesCodes = null;
        if (data instanceof ComfortProfile) {
            notesCodes = ((ComfortProfile)data).getNotesCodes();
        }
        this.importIncludedNotes(element, 1, notes, notesCodes);
    }

    protected void importContent(Element parent, String tag, String content, String ... attributes) {
        Node node = parent.getElementsByTagName(tag).item(0);
        node.setTextContent(content);
        if (attributes == null || attributes.length == 0) {
            return;
        }
        int n = attributes.length;
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i];
            if (++i == n) continue;
            String attrValue = attributes[i];
            Node attr = attrs.getNamedItem(attrName);
            if (attr == null) continue;
            attr.setTextContent(attrValue);
        }
    }

    protected void importDateTime(Element parent, String tag, String dateTimeFormat, Date dateTime) throws InvalidCodeException {
        if (dateTimeFormat == null) {
            return;
        }
        this.importContent(parent, tag, DF_CODE.convertToString(dateTime, DF_CODE.check(dateTimeFormat)), "format", dateTimeFormat);
    }

    protected void importIncludedNotes(Element parent, int level, String[][] notes, String[] notesCodes) throws DataIncompleteException, InvalidCodeException {
        if (notes == null) {
            return;
        }
        Node includedNoteNode = parent.getElementsByTagName("ram:IncludedNote").item(0);
        int n = notes.length;
        FreeTextSubjectCode ftsCode = new FreeTextSubjectCode(level);
        if (notesCodes != null && n != notesCodes.length) {
            throw new DataIncompleteException("Number of included notes is not equal to number of codes for included notes.");
        }
        for (int i = 0; i < n; ++i) {
            Element noteNode = (Element)includedNoteNode.cloneNode(true);
            Node content = noteNode.getElementsByTagName("ram:Content").item(0);
            for (String note : notes[i]) {
                Node newNode = content.cloneNode(true);
                newNode.setTextContent(note);
                noteNode.insertBefore(newNode, content);
            }
            if (notesCodes != null) {
                Node code = noteNode.getElementsByTagName("ram:SubjectCode").item(0);
                code.setTextContent(ftsCode.check(notesCodes[i]));
            }
            parent.insertBefore(noteNode, includedNoteNode);
        }
    }

    protected void importSpecifiedSupplyChainTradeTransaction(Element element, BasicProfile data) throws DataIncompleteException, InvalidCodeException {
        ComfortProfile comfortData = null;
        if (data instanceof ComfortProfile) {
            comfortData = (ComfortProfile)data;
        }
        if (comfortData != null) {
            String buyerReference = comfortData.getBuyerReference();
            this.importContent(element, "ram:BuyerReference", buyerReference, new String[0]);
        }
        this.check(data.getSellerName(), "SpecifiedSupplyChainTradeTransaction > ApplicableSupplyChainTradeAgreement > SellerTradeParty > Name");
        this.importSellerTradeParty(element, data);
        this.check(data.getBuyerName(), "SpecifiedSupplyChainTradeTransaction > ApplicableSupplyChainTradeAgreement > BuyerTradeParty > Name");
        this.importBuyerTradeParty(element, data);
        if (comfortData != null) {
            Element document = (Element)element.getElementsByTagName("ram:BuyerOrderReferencedDocument").item(0);
            this.importDateTime(document, "ram:IssueDateTime", comfortData.getBuyerOrderReferencedDocumentIssueDateTimeFormat(), comfortData.getBuyerOrderReferencedDocumentIssueDateTime());
            this.importContent(document, "ram:ID", comfortData.getBuyerOrderReferencedDocumentID(), new String[0]);
            document = (Element)element.getElementsByTagName("ram:ContractReferencedDocument").item(0);
            this.importDateTime(document, "ram:IssueDateTime", comfortData.getContractReferencedDocumentIssueDateTimeFormat(), comfortData.getContractReferencedDocumentIssueDateTime());
            this.importContent(document, "ram:ID", comfortData.getContractReferencedDocumentID(), new String[0]);
            document = (Element)element.getElementsByTagName("ram:CustomerOrderReferencedDocument").item(0);
            this.importDateTime(document, "ram:IssueDateTime", comfortData.getCustomerOrderReferencedDocumentIssueDateTimeFormat(), comfortData.getCustomerOrderReferencedDocumentIssueDateTime());
            this.importContent(document, "ram:ID", comfortData.getCustomerOrderReferencedDocumentID(), new String[0]);
        }
        Element parent = (Element)element.getElementsByTagName("ram:ActualDeliverySupplyChainEvent").item(0);
        this.importDateTime(parent, "udt:DateTimeString", data.getDeliveryDateTimeFormat(), data.getDeliveryDateTime());
        if (comfortData != null) {
            Element document = (Element)element.getElementsByTagName("ram:DeliveryNoteReferencedDocument").item(0);
            this.importDateTime(document, "ram:IssueDateTime", comfortData.getDeliveryNoteReferencedDocumentIssueDateTimeFormat(), comfortData.getDeliveryNoteReferencedDocumentIssueDateTime());
            this.importContent(document, "ram:ID", comfortData.getDeliveryNoteReferencedDocumentID(), new String[0]);
        }
        this.importContent(element, "ram:PaymentReference", data.getPaymentReference(), new String[0]);
        this.importContent(element, "ram:InvoiceCurrencyCode", CURR_CODE.check(data.getInvoiceCurrencyCode()), new String[0]);
        if (comfortData != null) {
            this.importInvoiceeTradeParty(element, comfortData);
        }
        parent = (Element)element.getElementsByTagName("ram:ApplicableSupplyChainTradeSettlement").item(0);
        this.importPaymentMeans(parent, data);
        this.importTax(parent, data);
        if (comfortData != null) {
            Element period = (Element)element.getElementsByTagName("ram:BillingSpecifiedPeriod").item(0);
            Element start = (Element)period.getElementsByTagName("ram:StartDateTime").item(0);
            this.importDateTime(start, "udt:DateTimeString", comfortData.getBillingStartDateTimeFormat(), comfortData.getBillingStartDateTime());
            Element end = (Element)period.getElementsByTagName("ram:EndDateTime").item(0);
            this.importDateTime(end, "udt:DateTimeString", comfortData.getBillingEndDateTimeFormat(), comfortData.getBillingEndDateTime());
            this.importSpecifiedTradeAllowanceCharge(parent, comfortData);
            this.importSpecifiedLogisticsServiceCharge(parent, comfortData);
            this.importSpecifiedTradePaymentTerms(parent, comfortData);
        }
        this.check(DEC2.check(data.getLineTotalAmount()), "SpecifiedTradeSettlementMonetarySummation > LineTotalAmount");
        this.check(CURR_CODE.check(data.getLineTotalAmountCurrencyID()), "SpecifiedTradeSettlementMonetarySummation > LineTotalAmount . currencyID");
        this.importContent(element, "ram:LineTotalAmount", data.getLineTotalAmount(), "currencyID", data.getLineTotalAmountCurrencyID());
        this.check(DEC2.check(data.getChargeTotalAmount()), "SpecifiedTradeSettlementMonetarySummation > ChargeTotalAmount");
        this.check(CURR_CODE.check(data.getChargeTotalAmountCurrencyID()), "SpecifiedTradeSettlementMonetarySummation > ChargeTotalAmount . currencyID");
        this.importContent(element, "ram:ChargeTotalAmount", data.getChargeTotalAmount(), "currencyID", data.getChargeTotalAmountCurrencyID());
        this.check(DEC2.check(data.getAllowanceTotalAmount()), "SpecifiedTradeSettlementMonetarySummation > AllowanceTotalAmount");
        this.check(CURR_CODE.check(data.getAllowanceTotalAmountCurrencyID()), "SpecifiedTradeSettlementMonetarySummation > AllowanceTotalAmount . currencyID");
        this.importContent(element, "ram:AllowanceTotalAmount", data.getAllowanceTotalAmount(), "currencyID", data.getAllowanceTotalAmountCurrencyID());
        this.check(DEC2.check(data.getTaxBasisTotalAmount()), "SpecifiedTradeSettlementMonetarySummation > TaxBasisTotalAmount");
        this.check(CURR_CODE.check(data.getTaxBasisTotalAmountCurrencyID()), "SpecifiedTradeSettlementMonetarySummation > TaxBasisTotalAmount . currencyID");
        this.importContent(element, "ram:TaxBasisTotalAmount", data.getTaxBasisTotalAmount(), "currencyID", data.getTaxBasisTotalAmountCurrencyID());
        this.check(DEC2.check(data.getTaxTotalAmount()), "SpecifiedTradeSettlementMonetarySummation > TaxTotalAmount");
        this.check(CURR_CODE.check(data.getTaxTotalAmountCurrencyID()), "SpecifiedTradeSettlementMonetarySummation > TaxTotalAmount . currencyID");
        this.importContent(element, "ram:TaxTotalAmount", data.getTaxTotalAmount(), "currencyID", data.getTaxTotalAmountCurrencyID());
        this.check(DEC2.check(data.getGrandTotalAmount()), "SpecifiedTradeSettlementMonetarySummation > GrandTotalAmount");
        this.check(CURR_CODE.check(data.getGrandTotalAmountCurrencyID()), "SpecifiedTradeSettlementMonetarySummation > GrandTotalAmount . currencyID");
        this.importContent(element, "ram:GrandTotalAmount", data.getGrandTotalAmount(), "currencyID", data.getGrandTotalAmountCurrencyID());
        if (comfortData != null) {
            this.importContent(element, "ram:TotalPrepaidAmount", comfortData.getTotalPrepaidAmount(), "currencyID", comfortData.getTotalPrepaidAmountCurrencyID());
            this.importContent(element, "ram:DuePayableAmount", comfortData.getDuePayableAmount(), "currencyID", comfortData.getDuePayableAmountCurrencyID());
        }
        if (comfortData != null) {
            this.importLineItemsComfort(element, comfortData);
        } else {
            this.importLineItemsBasic(element, data);
        }
    }

    protected void importSellerTradeParty(Element parent, BasicProfile data) throws DataIncompleteException, InvalidCodeException {
        String id = null;
        String[] globalID = null;
        String[] globalIDScheme = null;
        if (data instanceof ComfortProfile) {
            id = ((ComfortProfile)data).getSellerID();
            globalID = ((ComfortProfile)data).getSellerGlobalID();
            globalIDScheme = ((ComfortProfile)data).getSellerGlobalSchemeID();
        }
        String name = data.getSellerName();
        String postcode = data.getSellerPostcode();
        String lineOne = data.getSellerLineOne();
        String lineTwo = data.getSellerLineTwo();
        String cityName = data.getSellerCityName();
        String countryID = data.getSellerCountryID();
        String[] taxRegistrationID = data.getSellerTaxRegistrationID();
        String[] taxRegistrationSchemeID = data.getSellerTaxRegistrationSchemeID();
        this.importTradeParty((Element)parent.getElementsByTagName("ram:SellerTradeParty").item(0), id, globalID, globalIDScheme, name, postcode, lineOne, lineTwo, cityName, countryID, taxRegistrationID, taxRegistrationSchemeID);
    }

    protected void importBuyerTradeParty(Element parent, BasicProfile data) throws DataIncompleteException, InvalidCodeException {
        String id = null;
        String[] globalID = null;
        String[] globalIDScheme = null;
        if (data instanceof ComfortProfile) {
            id = ((ComfortProfile)data).getBuyerID();
            globalID = ((ComfortProfile)data).getBuyerGlobalID();
            globalIDScheme = ((ComfortProfile)data).getBuyerGlobalSchemeID();
        }
        String name = data.getBuyerName();
        String postcode = data.getBuyerPostcode();
        String lineOne = data.getBuyerLineOne();
        String lineTwo = data.getBuyerLineTwo();
        String cityName = data.getBuyerCityName();
        String countryID = data.getBuyerCountryID();
        String[] taxRegistrationID = data.getBuyerTaxRegistrationID();
        String[] taxRegistrationSchemeID = data.getBuyerTaxRegistrationSchemeID();
        this.importTradeParty((Element)parent.getElementsByTagName("ram:BuyerTradeParty").item(0), id, globalID, globalIDScheme, name, postcode, lineOne, lineTwo, cityName, countryID, taxRegistrationID, taxRegistrationSchemeID);
    }

    protected void importInvoiceeTradeParty(Element parent, ComfortProfile data) throws DataIncompleteException, InvalidCodeException {
        String name = data.getInvoiceeName();
        if (name == null) {
            return;
        }
        String id = data.getInvoiceeID();
        String[] globalID = data.getInvoiceeGlobalID();
        String[] globalIDScheme = data.getInvoiceeGlobalSchemeID();
        String postcode = data.getInvoiceePostcode();
        String lineOne = data.getInvoiceeLineOne();
        String lineTwo = data.getInvoiceeLineTwo();
        String cityName = data.getInvoiceeCityName();
        String countryID = data.getInvoiceeCountryID();
        String[] taxRegistrationID = data.getInvoiceeTaxRegistrationID();
        String[] taxRegistrationSchemeID = data.getInvoiceeTaxRegistrationSchemeID();
        this.importTradeParty((Element)parent.getElementsByTagName("ram:InvoiceeTradeParty").item(0), id, globalID, globalIDScheme, name, postcode, lineOne, lineTwo, cityName, countryID, taxRegistrationID, taxRegistrationSchemeID);
    }

    protected void importTradeParty(Element parent, String id, String[] globalID, String[] globalIDScheme, String name, String postcode, String lineOne, String lineTwo, String cityName, String countryID, String[] taxRegistrationID, String[] taxRegistrationSchemeID) throws DataIncompleteException, InvalidCodeException {
        int n;
        Node node;
        if (id != null) {
            node = parent.getElementsByTagName("ram:ID").item(0);
            node.setTextContent(id);
        }
        if (globalID != null) {
            n = globalID.length;
            if (globalIDScheme == null || globalIDScheme.length != n) {
                throw new DataIncompleteException("Number of global ID schemes is not equal to number of global IDs.");
            }
            node = parent.getElementsByTagName("ram:GlobalID").item(0);
            for (int i = 0; i < n; ++i) {
                Element idNode = (Element)node.cloneNode(true);
                NamedNodeMap attrs = idNode.getAttributes();
                idNode.setTextContent(globalID[i]);
                Node schemeID = attrs.getNamedItem("schemeID");
                schemeID.setTextContent(GI_CODE.check(globalIDScheme[i]));
                parent.insertBefore(idNode, node);
            }
        }
        this.importContent(parent, "ram:Name", name, new String[0]);
        this.importContent(parent, "ram:PostcodeCode", postcode, new String[0]);
        this.importContent(parent, "ram:LineOne", lineOne, new String[0]);
        this.importContent(parent, "ram:LineTwo", lineTwo, new String[0]);
        this.importContent(parent, "ram:CityName", cityName, new String[0]);
        if (countryID != null) {
            this.importContent(parent, "ram:CountryID", COUNTRY_CODE.check(countryID), new String[0]);
        }
        n = taxRegistrationID.length;
        if (taxRegistrationSchemeID != null && taxRegistrationSchemeID.length != n) {
            throw new DataIncompleteException("Number of tax ID schemes is not equal to number of tax IDs.");
        }
        Element tax = (Element)parent.getElementsByTagName("ram:SpecifiedTaxRegistration").item(0);
        node = tax.getElementsByTagName("ram:ID").item(0);
        for (int i = 0; i < n; ++i) {
            Element idNode = (Element)node.cloneNode(true);
            idNode.setTextContent(taxRegistrationID[i]);
            NamedNodeMap attrs = idNode.getAttributes();
            Node schemeID = attrs.getNamedItem("schemeID");
            schemeID.setTextContent(TIDT_CODE.check(taxRegistrationSchemeID[i]));
            tax.insertBefore(idNode, node);
        }
    }

    protected void importPaymentMeans(Element parent, BasicProfile data) throws InvalidCodeException {
        String[] pmID = data.getPaymentMeansID();
        int n = pmID.length;
        String[] pmTypeCode = new String[n];
        String[][] pmInformation = new String[n][];
        String[] pmSchemeAgencyID = data.getPaymentMeansSchemeAgencyID();
        String[] pmPayerIBAN = new String[n];
        String[] pmPayerProprietaryID = new String[n];
        String[] pmIBAN = data.getPaymentMeansPayeeAccountIBAN();
        String[] pmAccountName = data.getPaymentMeansPayeeAccountAccountName();
        String[] pmAccountID = data.getPaymentMeansPayeeAccountProprietaryID();
        String[] pmPayerBIC = new String[n];
        String[] pmPayerGermanBankleitzahlID = new String[n];
        String[] pmPayerFinancialInst = new String[n];
        String[] pmBIC = data.getPaymentMeansPayeeFinancialInstitutionBIC();
        String[] pmGermanBankleitzahlID = data.getPaymentMeansPayeeFinancialInstitutionGermanBankleitzahlID();
        String[] pmFinancialInst = data.getPaymentMeansPayeeFinancialInstitutionName();
        if (data instanceof ComfortProfile) {
            ComfortProfile comfortData = (ComfortProfile)data;
            pmTypeCode = comfortData.getPaymentMeansTypeCode();
            pmInformation = comfortData.getPaymentMeansInformation();
            pmPayerIBAN = comfortData.getPaymentMeansPayerAccountIBAN();
            pmPayerProprietaryID = comfortData.getPaymentMeansPayerAccountProprietaryID();
            pmPayerBIC = comfortData.getPaymentMeansPayerFinancialInstitutionBIC();
            pmPayerGermanBankleitzahlID = comfortData.getPaymentMeansPayerFinancialInstitutionGermanBankleitzahlID();
            pmPayerFinancialInst = comfortData.getPaymentMeansPayerFinancialInstitutionName();
        }
        Node node = parent.getElementsByTagName("ram:SpecifiedTradeSettlementPaymentMeans").item(0);
        for (int i = 0; i < pmID.length; ++i) {
            Node newNode = node.cloneNode(true);
            this.importPaymentMeans((Element)newNode, pmTypeCode[i], pmInformation[i], pmID[i], pmSchemeAgencyID[i], pmPayerIBAN[i], pmPayerProprietaryID[i], pmIBAN[i], pmAccountName[i], pmAccountID[i], pmPayerBIC[i], pmPayerGermanBankleitzahlID[i], pmPayerFinancialInst[i], pmBIC[i], pmGermanBankleitzahlID[i], pmFinancialInst[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importPaymentMeans(Element parent, String typeCode, String[] information, String id, String scheme, String payerIban, String payerProprietaryID, String iban, String accName, String accID, String payerBic, String payerBank, String payerInst, String bic, String bank, String inst) throws InvalidCodeException {
        if (typeCode != null) {
            this.importContent(parent, "ram:TypeCode", PM_CODE.check(typeCode), new String[0]);
        }
        if (information != null) {
            Node node = parent.getElementsByTagName("ram:Information").item(0);
            for (String info : information) {
                Node newNode = node.cloneNode(true);
                newNode.setTextContent(info);
                parent.insertBefore(newNode, node);
            }
        }
        this.importContent(parent, "ram:ID", id, "schemeAgencyID", scheme);
        Element payer = (Element)parent.getElementsByTagName("ram:PayerPartyDebtorFinancialAccount").item(0);
        this.importContent(payer, "ram:IBANID", payerIban, new String[0]);
        this.importContent(payer, "ram:ProprietaryID", payerProprietaryID, new String[0]);
        Element payee = (Element)parent.getElementsByTagName("ram:PayeePartyCreditorFinancialAccount").item(0);
        this.importContent(payee, "ram:IBANID", iban, new String[0]);
        this.importContent(payee, "ram:AccountName", accName, new String[0]);
        this.importContent(payee, "ram:ProprietaryID", accID, new String[0]);
        payer = (Element)parent.getElementsByTagName("ram:PayerSpecifiedDebtorFinancialInstitution").item(0);
        this.importContent(payer, "ram:BICID", payerBic, new String[0]);
        this.importContent(payer, "ram:GermanBankleitzahlID", payerBank, new String[0]);
        this.importContent(payer, "ram:Name", payerInst, new String[0]);
        payee = (Element)parent.getElementsByTagName("ram:PayeeSpecifiedCreditorFinancialInstitution").item(0);
        this.importContent(payee, "ram:BICID", bic, new String[0]);
        this.importContent(payee, "ram:GermanBankleitzahlID", bank, new String[0]);
        this.importContent(payee, "ram:Name", inst, new String[0]);
    }

    protected void importTax(Element parent, BasicProfile data) throws InvalidCodeException, DataIncompleteException {
        String[] calculated = data.getTaxCalculatedAmount();
        int n = calculated.length;
        String[] calculatedCurr = data.getTaxCalculatedAmountCurrencyID();
        String[] typeCode = data.getTaxTypeCode();
        String[] exemptionReason = new String[n];
        String[] basisAmount = data.getTaxBasisAmount();
        String[] basisAmountCurr = data.getTaxBasisAmountCurrencyID();
        String[] category = new String[n];
        String[] percent = data.getTaxApplicablePercent();
        if (data instanceof ComfortProfile) {
            ComfortProfile comfortData = (ComfortProfile)data;
            exemptionReason = comfortData.getTaxExemptionReason();
            category = comfortData.getTaxCategoryCode();
        }
        Node node = parent.getElementsByTagName("ram:ApplicableTradeTax").item(0);
        for (int i = 0; i < n; ++i) {
            Node newNode = node.cloneNode(true);
            this.importTax((Element)newNode, calculated[i], calculatedCurr[i], typeCode[i], exemptionReason[i], basisAmount[i], basisAmountCurr[i], category[i], percent[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importTax(Element parent, String calculatedAmount, String currencyID, String typeCode, String exemptionReason, String basisAmount, String basisAmountCurr, String category, String percent) throws InvalidCodeException, DataIncompleteException {
        this.check(CURR_CODE.check(currencyID), "ApplicableTradeTax > CalculatedAmount > CurrencyID");
        this.importContent(parent, "ram:CalculatedAmount", DEC2.check(calculatedAmount), "currencyID", currencyID);
        this.check(typeCode, "ApplicableTradeTax > TypeCode");
        this.importContent(parent, "ram:TypeCode", TT_CODE.check(typeCode), new String[0]);
        this.importContent(parent, "ram:ExemptionReason", exemptionReason, new String[0]);
        this.check(CURR_CODE.check(basisAmountCurr), "ApplicableTradeTax > BasisAmount > CurrencyID");
        this.importContent(parent, "ram:BasisAmount", DEC2.check(basisAmount), "currencyID", basisAmountCurr);
        if (category != null) {
            this.importContent(parent, "ram:CategoryCode", TC_CODE.check(category), new String[0]);
        }
        this.importContent(parent, "ram:ApplicablePercent", DEC2.check(percent), new String[0]);
    }

    protected void importSpecifiedTradeAllowanceCharge(Element parent, ComfortProfile data) throws InvalidCodeException {
        Boolean[] indicator = data.getSpecifiedTradeAllowanceChargeIndicator();
        String[] actualAmount = data.getSpecifiedTradeAllowanceChargeActualAmount();
        String[] actualAmountCurr = data.getSpecifiedTradeAllowanceChargeActualAmountCurrency();
        String[] reason = data.getSpecifiedTradeAllowanceChargeReason();
        String[][] typeCode = data.getSpecifiedTradeAllowanceChargeTaxTypeCode();
        String[][] categoryCode = data.getSpecifiedTradeAllowanceChargeTaxCategoryCode();
        String[][] percent = data.getSpecifiedTradeAllowanceChargeTaxApplicablePercent();
        Element node = (Element)parent.getElementsByTagName("ram:SpecifiedTradeAllowanceCharge").item(0);
        for (int i = 0; i < indicator.length; ++i) {
            Node newNode = node.cloneNode(true);
            this.importSpecifiedTradeAllowanceCharge((Element)newNode, indicator[i], actualAmount[i], actualAmountCurr[i], reason[i], typeCode[i], categoryCode[i], percent[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importSpecifiedTradeAllowanceCharge(Element parent, boolean indicator, String actualAmount, String actualAmountCurrency, String reason, String[] typeCode, String[] categoryCode, String[] percent) throws InvalidCodeException {
        this.importContent(parent, "udt:Indicator", indicator ? "true" : "false", new String[0]);
        this.importContent(parent, "ram:ActualAmount", DEC4.check(actualAmount), "currencyID", CURR_CODE.check(actualAmountCurrency));
        this.importContent(parent, "ram:Reason", reason, new String[0]);
        Node node = parent.getElementsByTagName("ram:CategoryTradeTax").item(0);
        for (int i = 0; i < typeCode.length; ++i) {
            Element newNode = (Element)node.cloneNode(true);
            this.importContent(newNode, "ram:TypeCode", TT_CODE.check(typeCode[i]), new String[0]);
            this.importContent(newNode, "ram:CategoryCode", TC_CODE.check(categoryCode[i]), new String[0]);
            this.importContent(newNode, "ram:ApplicablePercent", DEC2.check(percent[i]), new String[0]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importSpecifiedLogisticsServiceCharge(Element parent, ComfortProfile data) throws InvalidCodeException {
        String[][] description = data.getSpecifiedLogisticsServiceChargeDescription();
        String[] appliedAmount = data.getSpecifiedLogisticsServiceChargeAmount();
        String[] appliedAmountCurr = data.getSpecifiedLogisticsServiceChargeAmountCurrency();
        String[][] typeCode = data.getSpecifiedLogisticsServiceChargeTaxTypeCode();
        String[][] categoryCode = data.getSpecifiedLogisticsServiceChargeTaxCategoryCode();
        String[][] percent = data.getSpecifiedLogisticsServiceChargeTaxApplicablePercent();
        Node node = parent.getElementsByTagName("ram:SpecifiedLogisticsServiceCharge").item(0);
        for (int i = 0; i < appliedAmount.length; ++i) {
            Node newNode = node.cloneNode(true);
            this.importSpecifiedLogisticsServiceCharge((Element)newNode, description[i], appliedAmount[i], appliedAmountCurr[i], typeCode[i], categoryCode[i], percent[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importSpecifiedLogisticsServiceCharge(Element parent, String[] description, String appliedAmount, String currencyID, String[] typeCode, String[] categoryCode, String[] percent) throws InvalidCodeException {
        Node node = parent.getElementsByTagName("ram:Description").item(0);
        for (String d : description) {
            Node newNode = node.cloneNode(true);
            newNode.setTextContent(d);
            parent.insertBefore(newNode, node);
        }
        this.importContent(parent, "ram:AppliedAmount", DEC4.check(appliedAmount), "currencyID", CURR_CODE.check(currencyID));
        node = parent.getElementsByTagName("ram:AppliedTradeTax").item(0);
        for (int i = 0; i < typeCode.length; ++i) {
            Element newNode = (Element)node.cloneNode(true);
            this.importContent(newNode, "ram:TypeCode", TT_CODE.check(typeCode[i]), new String[0]);
            this.importContent(newNode, "ram:CategoryCode", TC_CODE.check(categoryCode[i]), new String[0]);
            this.importContent(newNode, "ram:ApplicablePercent", DEC2.check(percent[i]), new String[0]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importSpecifiedTradePaymentTerms(Element parent, ComfortProfile data) throws InvalidCodeException {
        String[][] description = data.getSpecifiedTradePaymentTermsDescription();
        Date[] dateTime = data.getSpecifiedTradePaymentTermsDueDateTime();
        String[] dateTimeFormat = data.getSpecifiedTradePaymentTermsDueDateTimeFormat();
        Node node = parent.getElementsByTagName("ram:SpecifiedTradePaymentTerms").item(0);
        for (int i = 0; i < description.length; ++i) {
            Node newNode = node.cloneNode(true);
            this.importSpecifiedTradePaymentTerms((Element)newNode, description[i], dateTime[i], dateTimeFormat[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importSpecifiedTradePaymentTerms(Element parent, String[] description, Date dateTime, String dateTimeFormat) throws InvalidCodeException {
        Node node = parent.getElementsByTagName("ram:Description").item(0);
        for (String d : description) {
            Node newNode = node.cloneNode(true);
            newNode.setTextContent(d);
            parent.insertBefore(newNode, node);
        }
        if (dateTimeFormat != null) {
            this.importDateTime(parent, "udt:DateTimeString", dateTimeFormat, dateTime);
        }
    }

    protected void importLineItemsComfort(Element parent, ComfortProfile data) throws DataIncompleteException, InvalidCodeException {
        String[] lineIDs = data.getLineItemLineID();
        if (lineIDs.length == 0) {
            throw new DataIncompleteException("You can create an invoice without any line items");
        }
        String[][][] includedNote = data.getLineItemIncludedNote();
        String[] grossPriceChargeAmount = data.getLineItemGrossPriceChargeAmount();
        String[] grossPriceChargeAmountCurrencyID = data.getLineItemGrossPriceChargeAmountCurrencyID();
        String[] grossPriceBasisQuantity = data.getLineItemGrossPriceBasisQuantity();
        String[] grossPriceBasisQuantityCode = data.getLineItemGrossPriceBasisQuantityCode();
        Boolean[][] grossPriceTradeAllowanceChargeIndicator = data.getLineItemGrossPriceTradeAllowanceChargeIndicator();
        String[][] grossPriceTradeAllowanceChargeActualAmount = data.getLineItemGrossPriceTradeAllowanceChargeActualAmount();
        String[][] grossPriceTradeAllowanceChargeActualAmountCurrencyID = data.getLineItemGrossPriceTradeAllowanceChargeActualAmountCurrencyID();
        String[][] grossPriceTradeAllowanceChargeReason = data.getLineItemGrossPriceTradeAllowanceChargeReason();
        String[] netPriceChargeAmount = data.getLineItemNetPriceChargeAmount();
        String[] netPriceChargeAmountCurrencyID = data.getLineItemNetPriceChargeAmountCurrencyID();
        String[] netPriceBasisQuantity = data.getLineItemNetPriceBasisQuantity();
        String[] netPriceBasisQuantityCode = data.getLineItemNetPriceBasisQuantityCode();
        String[] billedQuantity = data.getLineItemBilledQuantity();
        String[] billedQuantityUnitCode = data.getLineItemBilledQuantityUnitCode();
        String[][] settlementTaxTypeCode = data.getLineItemSettlementTaxTypeCode();
        String[][] settlementTaxExemptionReason = data.getLineItemSettlementTaxExemptionReason();
        String[][] settlementTaxCategoryCode = data.getLineItemSettlementTaxCategoryCode();
        String[][] settlementTaxApplicablePercent = data.getLineItemSettlementTaxApplicablePercent();
        String[] totalAmount = data.getLineItemLineTotalAmount();
        String[] totalAmountCurrencyID = data.getLineItemLineTotalAmountCurrencyID();
        String[] specifiedTradeProductGlobalID = data.getLineItemSpecifiedTradeProductGlobalID();
        String[] specifiedTradeProductSchemeID = data.getLineItemSpecifiedTradeProductSchemeID();
        String[] specifiedTradeProductSellerAssignedID = data.getLineItemSpecifiedTradeProductSellerAssignedID();
        String[] specifiedTradeProductBuyerAssignedID = data.getLineItemSpecifiedTradeProductBuyerAssignedID();
        String[] specifiedTradeProductName = data.getLineItemSpecifiedTradeProductName();
        String[] specifiedTradeProductDescription = data.getLineItemSpecifiedTradeProductDescription();
        Node node = parent.getElementsByTagName("ram:IncludedSupplyChainTradeLineItem").item(0);
        for (int i = 0; i < lineIDs.length; ++i) {
            Node newNode = node.cloneNode(true);
            this.importLineItemComfort((Element)newNode, lineIDs[i], includedNote[i], grossPriceChargeAmount[i], grossPriceChargeAmountCurrencyID[i], grossPriceBasisQuantity[i], grossPriceBasisQuantityCode[i], grossPriceTradeAllowanceChargeIndicator[i], grossPriceTradeAllowanceChargeActualAmount[i], grossPriceTradeAllowanceChargeActualAmountCurrencyID[i], grossPriceTradeAllowanceChargeReason[i], netPriceChargeAmount[i], netPriceChargeAmountCurrencyID[i], netPriceBasisQuantity[i], netPriceBasisQuantityCode[i], billedQuantity[i], billedQuantityUnitCode[i], settlementTaxTypeCode[i], settlementTaxExemptionReason[i], settlementTaxCategoryCode[i], settlementTaxApplicablePercent[i], totalAmount[i], totalAmountCurrencyID[i], specifiedTradeProductGlobalID[i], specifiedTradeProductSchemeID[i], specifiedTradeProductSellerAssignedID[i], specifiedTradeProductBuyerAssignedID[i], specifiedTradeProductName[i], specifiedTradeProductDescription[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importLineItemComfort(Element parent, String lineID, String[][] note, String grossPriceChargeAmount, String grossPriceChargeAmountCurrencyID, String grossPriceBasisQuantity, String grossPriceBasisQuantityCode, Boolean[] grossPriceTradeAllowanceChargeIndicator, String[] grossPriceTradeAllowanceChargeActualAmount, String[] grossPriceTradeAllowanceChargeActualAmountCurrencyID, String[] grossPriceTradeAllowanceChargeReason, String netPriceChargeAmount, String netPriceChargeAmountCurrencyID, String netPriceBasisQuantity, String netPriceBasisQuantityCode, String billedQuantity, String billedQuantityCode, String[] settlementTaxTypeCode, String[] settlementTaxExemptionReason, String[] settlementTaxCategoryCode, String[] settlementTaxApplicablePercent, String totalAmount, String totalAmountCurrencyID, String specifiedTradeProductGlobalID, String specifiedTradeProductSchemeID, String specifiedTradeProductSellerAssignedID, String specifiedTradeProductBuyerAssignedID, String specifiedTradeProductName, String specifiedTradeProductDescription) throws DataIncompleteException, InvalidCodeException {
        Node newNode;
        int i;
        Node node;
        Element sub = (Element)parent.getElementsByTagName("ram:AssociatedDocumentLineDocument").item(0);
        this.importContent(sub, "ram:LineID", lineID, new String[0]);
        this.importIncludedNotes(sub, 2, note, null);
        if (grossPriceChargeAmount != null) {
            sub = (Element)parent.getElementsByTagName("ram:GrossPriceProductTradePrice").item(0);
            this.importContent(sub, "ram:ChargeAmount", DEC4.check(grossPriceChargeAmount), "currencyID", CURR_CODE.check(grossPriceChargeAmountCurrencyID));
            if (grossPriceBasisQuantity != null) {
                this.importContent(sub, "ram:BasisQuantity", DEC4.check(grossPriceBasisQuantity), "unitCode", M_UNIT_CODE.check(grossPriceBasisQuantityCode));
            }
            node = sub.getElementsByTagName("ram:AppliedTradeAllowanceCharge").item(0);
            if (grossPriceTradeAllowanceChargeIndicator != null) {
                for (i = 0; i < grossPriceTradeAllowanceChargeIndicator.length; ++i) {
                    newNode = node.cloneNode(true);
                    this.importAppliedTradeAllowanceCharge((Element)newNode, grossPriceTradeAllowanceChargeIndicator[i], grossPriceTradeAllowanceChargeActualAmount[i], grossPriceTradeAllowanceChargeActualAmountCurrencyID[i], grossPriceTradeAllowanceChargeReason[i]);
                    sub.insertBefore(newNode, node);
                }
            }
        }
        if (netPriceChargeAmount != null) {
            sub = (Element)parent.getElementsByTagName("ram:NetPriceProductTradePrice").item(0);
            this.importContent(sub, "ram:ChargeAmount", DEC4.check(netPriceChargeAmount), "currencyID", CURR_CODE.check(netPriceChargeAmountCurrencyID));
            if (netPriceBasisQuantity != null) {
                this.importContent(sub, "ram:BasisQuantity", DEC4.check(netPriceBasisQuantity), "unitCode", M_UNIT_CODE.check(netPriceBasisQuantityCode));
            }
        }
        sub = (Element)parent.getElementsByTagName("ram:SpecifiedSupplyChainTradeDelivery").item(0);
        this.importContent(sub, "ram:BilledQuantity", DEC4.check(billedQuantity), "unitCode", M_UNIT_CODE.check(billedQuantityCode));
        sub = (Element)parent.getElementsByTagName("ram:SpecifiedSupplyChainTradeSettlement").item(0);
        node = sub.getElementsByTagName("ram:ApplicableTradeTax").item(0);
        for (i = 0; i < settlementTaxApplicablePercent.length; ++i) {
            newNode = node.cloneNode(true);
            this.importTax((Element)newNode, settlementTaxTypeCode[i], settlementTaxExemptionReason[i], settlementTaxCategoryCode[i], settlementTaxApplicablePercent[i]);
            sub.insertBefore(newNode, node);
        }
        this.importContent(sub, "ram:LineTotalAmount", totalAmount, "currencyID", totalAmountCurrencyID);
        sub = (Element)parent.getElementsByTagName("ram:SpecifiedTradeProduct").item(0);
        if (specifiedTradeProductGlobalID != null) {
            this.importContent(sub, "ram:GlobalID", specifiedTradeProductGlobalID, "schemeID", GI_CODE.check(specifiedTradeProductSchemeID));
        }
        this.importContent(sub, "ram:SellerAssignedID", specifiedTradeProductSellerAssignedID, new String[0]);
        this.importContent(sub, "ram:BuyerAssignedID", specifiedTradeProductBuyerAssignedID, new String[0]);
        this.importContent(sub, "ram:Name", specifiedTradeProductName, new String[0]);
        this.importContent(sub, "ram:Description", specifiedTradeProductDescription, new String[0]);
    }

    protected void importAppliedTradeAllowanceCharge(Element parent, boolean indicator, String actualAmount, String currencyID, String reason) throws DataIncompleteException, InvalidCodeException {
        this.importContent(parent, "udt:Indicator", indicator ? "true" : "false", new String[0]);
        this.check(DEC4.check(actualAmount), "AppliedTradeAllowanceCharge > ActualAmount");
        this.importContent(parent, "ram:ActualAmount", actualAmount, "currencyID", CURR_CODE.check(currencyID));
        this.importContent(parent, "ram:Reason", reason, new String[0]);
    }

    protected void importTax(Element parent, String typeCode, String exemptionReason, String category, String percent) throws InvalidCodeException, DataIncompleteException {
        this.check(typeCode, "ApplicableTradeTax > TypeCode");
        this.importContent(parent, "ram:TypeCode", TT_CODE.check(typeCode), new String[0]);
        this.importContent(parent, "ram:ExemptionReason", exemptionReason, new String[0]);
        if (category != null) {
            this.importContent(parent, "ram:CategoryCode", TC_CODE.check(category), new String[0]);
        }
        this.importContent(parent, "ram:ApplicablePercent", DEC2.check(percent), new String[0]);
    }

    protected void importLineItemsBasic(Element parent, BasicProfile data) throws DataIncompleteException, InvalidCodeException {
        String[] quantity = data.getLineItemBilledQuantity();
        if (quantity.length == 0) {
            throw new DataIncompleteException("You can create an invoice without any line items");
        }
        String[] quantityCode = data.getLineItemBilledQuantityUnitCode();
        String[] name = data.getLineItemSpecifiedTradeProductName();
        Node node = parent.getElementsByTagName("ram:IncludedSupplyChainTradeLineItem").item(0);
        for (int i = 0; i < quantity.length; ++i) {
            Node newNode = node.cloneNode(true);
            this.importLineItemBasic((Element)newNode, quantity[i], quantityCode[i], name[i]);
            parent.insertBefore(newNode, node);
        }
    }

    protected void importLineItemBasic(Element parent, String quantity, String code, String name) throws InvalidCodeException {
        Element sub = (Element)parent.getElementsByTagName("ram:SpecifiedSupplyChainTradeDelivery").item(0);
        this.importContent(sub, "ram:BilledQuantity", DEC4.check(quantity), "unitCode", M_UNIT_CODE.check(code));
        sub = (Element)parent.getElementsByTagName("ram:SpecifiedTradeProduct").item(0);
        this.importContent(sub, "ram:Name", name, new String[0]);
    }

    public byte[] toXML() throws TransformerException {
        InvoiceDOM.removeEmptyNodes(this.doc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(this.doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        return out.toByteArray();
    }

    protected static void removeEmptyNodes(Node node) {
        boolean emptyText;
        NodeList list = node.getChildNodes();
        for (int i = list.getLength() - 1; i >= 0; --i) {
            InvoiceDOM.removeEmptyNodes(list.item(i));
        }
        boolean emptyElement = node.getNodeType() == 1 && node.getChildNodes().getLength() == 0;
        boolean bl = emptyText = node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
        if (emptyElement || emptyText) {
            node.getParentNode().removeChild(node);
        }
    }

    protected void check(String s, String message) throws DataIncompleteException {
        if (s == null || s.trim().length() == 0) {
            throw new DataIncompleteException(message);
        }
    }

    private static class SafeEmptyEntityResolver
    implements EntityResolver {
        private SafeEmptyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

