/*
 * Decompiled with CFR 0.152.
 */
package com.ismaeldivita.chipnavigation.view;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.ismaeldivita.chipnavigation.R;
import com.ismaeldivita.chipnavigation.model.MenuItem;
import com.ismaeldivita.chipnavigation.util.ImageViewKt;
import com.ismaeldivita.chipnavigation.util.TextViewKt;
import com.ismaeldivita.chipnavigation.util.ViewGroupKt;
import com.ismaeldivita.chipnavigation.util.ViewKt;
import com.ismaeldivita.chipnavigation.view.BadgeImageView;
import com.ismaeldivita.chipnavigation.view.MenuItemView;
import com.ismaeldivita.chipnavigation.view.VerticalMenuItemView;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u00020\u0001:\u00018B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020&J\b\u0010*\u001a\u00020&H\u0016J\u0006\u0010+\u001a\u00020&J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020-H\u0016J\u0010\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\bH\u0016J\b\u00102\u001a\u00020&H\u0002J\b\u00103\u001a\u00020&H\u0002J\u001c\u00104\u001a\u000205*\u00020\u00112\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0013\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\n \u000b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000f\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\"\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b#\u0010\u0016\u00a8\u00069"}, d2={"Lcom/ismaeldivita/chipnavigation/view/VerticalMenuItemView;", "Lcom/ismaeldivita/chipnavigation/view/MenuItemView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "badgeCount", "", "container", "Landroid/view/View;", "kotlin.jvm.PlatformType", "getContainer", "()Landroid/view/View;", "container$delegate", "Lkotlin/Lazy;", "containerBackground", "Landroid/graphics/drawable/GradientDrawable;", "containerForeground", "countLabel", "Landroid/widget/TextView;", "getCountLabel", "()Landroid/widget/TextView;", "countLabel$delegate", "doubleSpace", "icon", "Lcom/ismaeldivita/chipnavigation/view/BadgeImageView;", "getIcon", "()Lcom/ismaeldivita/chipnavigation/view/BadgeImageView;", "icon$delegate", "originalTypeFace", "Landroid/graphics/Typeface;", "radius", "", "title", "getTitle", "title$delegate", "bind", "", "item", "Lcom/ismaeldivita/chipnavigation/model/MenuItem;", "collapse", "dismissBadge", "expand", "isExpanded", "", "setEnabled", "enabled", "showBadge", "count", "styleContainerForCollapseState", "styleContainerForExpandedState", "cornerAnimation", "Landroid/animation/Animator;", "from", "to", "Companion", "chip-navigation-bar_release"})
public final class VerticalMenuItemView
extends MenuItemView {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy title$delegate;
    @NotNull
    private final Lazy icon$delegate;
    @NotNull
    private final Lazy countLabel$delegate;
    @NotNull
    private final Lazy container$delegate;
    @NotNull
    private final GradientDrawable containerBackground;
    @NotNull
    private final GradientDrawable containerForeground;
    private final int doubleSpace;
    @NotNull
    private final Typeface originalTypeFace;
    private int badgeCount;
    private float radius;
    @Deprecated
    private static final long BACKGROUND_CORNER_ANIMATION_DURATION = 250L;
    @Deprecated
    private static final char BULLET = '\u2b24';

    @JvmOverloads
    public VerticalMenuItemView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.title$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TextView>(this){
            final /* synthetic */ VerticalMenuItemView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final TextView invoke() {
                return (TextView)this.this$0.findViewById(R.id.cbn_item_title);
            }
        }));
        this.icon$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BadgeImageView>(this){
            final /* synthetic */ VerticalMenuItemView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final BadgeImageView invoke() {
                return (BadgeImageView)this.this$0.findViewById(R.id.cnb_item_icon);
            }
        }));
        this.countLabel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TextView>(this){
            final /* synthetic */ VerticalMenuItemView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final TextView invoke() {
                return (TextView)this.this$0.findViewById(R.id.cbn_item_notification_count);
            }
        }));
        this.container$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(this){
            final /* synthetic */ VerticalMenuItemView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final View invoke() {
                return this.this$0.findViewById(R.id.cbn_item_internal_container);
            }
        }));
        this.containerBackground = new GradientDrawable();
        this.containerForeground = new GradientDrawable();
        this.doubleSpace = (int)this.getResources().getDimension(R.dimen.cnb_space_2);
        this.badgeCount = -1;
        View.inflate((Context)this.getContext(), (int)R.layout.cnb_vertical_menu_item, (ViewGroup)((ViewGroup)this));
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        Typeface typeface = this.getCountLabel().getTypeface();
        Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"countLabel.typeface");
        this.originalTypeFace = typeface;
    }

    public /* synthetic */ VerticalMenuItemView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final TextView getTitle() {
        Lazy lazy = this.title$delegate;
        return (TextView)lazy.getValue();
    }

    private final BadgeImageView getIcon() {
        Lazy lazy = this.icon$delegate;
        return (BadgeImageView)((Object)lazy.getValue());
    }

    private final TextView getCountLabel() {
        Lazy lazy = this.countLabel$delegate;
        return (TextView)lazy.getValue();
    }

    private final View getContainer() {
        Lazy lazy = this.container$delegate;
        return (View)lazy.getValue();
    }

    @Override
    public void bind(@NotNull MenuItem item) {
        int p0;
        TextView textView;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.setId(item.getId());
        this.setEnabled(item.getEnabled());
        this.radius = item.getMenuStyle().getRadius();
        this.setImportantForAccessibility(1);
        CharSequence charSequence = item.getContentDescription();
        if (charSequence == null) {
            charSequence = item.getTitle();
        }
        this.setContentDescription(charSequence);
        Integer n2 = item.getMenuStyle().getTextAppearance();
        if (n2 != null) {
            n = n2;
            textView = this.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"title");
            p0 = ((Number)n).intValue();
            boolean bl = false;
            textView.setTextAppearance(p0);
        }
        this.getTitle().setText(item.getTitle());
        Object object = this.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"title");
        TextViewKt.setColorStateListAnimator(object, item.getTextColor(), item.getMenuStyle().getUnselectedColor());
        Integer n3 = item.getMenuStyle().getTextAppearance();
        if (n3 != null) {
            n = n3;
            textView = this.getCountLabel();
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"countLabel");
            p0 = ((Number)n).intValue();
            boolean bl = false;
            textView.setTextAppearance(p0);
        }
        object = this.getCountLabel();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"countLabel");
        TextViewKt.setColorStateListAnimator(object, item.getTextColor(), item.getMenuStyle().getUnselectedColor());
        this.getIcon().getLayoutParams().width = item.getMenuStyle().getIconSize();
        this.getIcon().getLayoutParams().height = item.getMenuStyle().getIconSize();
        this.getIcon().setBadgeColor(item.getMenuStyle().getBadgeColor());
        this.getIcon().setImageResource(item.getIcon());
        object = this.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"icon");
        ImageViewKt.setColorStateListAnimator((ImageView)object, item.getIconColor(), item.getMenuStyle().getUnselectedColor(), item.getTintMode());
        this.containerBackground.setTint(item.getBackgroundColor());
        this.containerForeground.setTint(-16777216);
        this.styleContainerForCollapseState();
        object = this.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container");
        ViewKt.setCustomRipple((View)object, (Drawable)this.containerBackground, (Drawable)this.containerForeground);
    }

    @Override
    public void showBadge(int count) {
        this.badgeCount = count;
        if (this.badgeCount > 0) {
            this.getCountLabel().setTypeface(this.originalTypeFace);
            this.getCountLabel().setText((CharSequence)String.valueOf(this.badgeCount));
        } else {
            this.getCountLabel().setTypeface(Typeface.DEFAULT);
            this.getCountLabel().setText((CharSequence)"\u2b24");
        }
        if (!this.isExpanded()) {
            this.getIcon().showBadge(this.badgeCount);
        }
    }

    @Override
    public void dismissBadge() {
        this.badgeCount = -1;
        this.getIcon().dismissBadge();
        this.getCountLabel().setText((CharSequence)"");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled && this.isSelected()) {
            this.setSelected(false);
        }
    }

    public final void expand() {
        this.styleContainerForExpandedState();
        if (this.badgeCount >= 0) {
            this.getIcon().dismissBadge();
        }
    }

    public final void collapse() {
        this.styleContainerForCollapseState();
        if (this.badgeCount >= 0) {
            this.getIcon().showBadge(this.badgeCount);
        }
    }

    private final boolean isExpanded() {
        return this.getTitle().getVisibility() == 0;
    }

    private final void styleContainerForCollapseState() {
        this.getTitle().setVisibility(8);
        this.getCountLabel().setVisibility(8);
        this.containerForeground.setCornerRadius(this.radius);
        Object object = this.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container");
        ViewGroupKt.updateLayoutParams(object, (Function1)new Function1<ViewGroup.MarginLayoutParams, Unit>(this){
            final /* synthetic */ VerticalMenuItemView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ViewGroup.MarginLayoutParams $this$updateLayoutParams) {
                Intrinsics.checkNotNullParameter((Object)$this$updateLayoutParams, (String)"$this$updateLayoutParams");
                $this$updateLayoutParams.setMarginStart(VerticalMenuItemView.access$getDoubleSpace$p(this.this$0));
            }
        });
        object = this.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"icon");
        ViewGroupKt.updateLayoutParams(object, styleContainerForCollapseState.2.INSTANCE);
        if (this.isSelected()) {
            this.cornerAnimation(this.containerBackground, 0.0f, this.radius).start();
        } else {
            this.containerBackground.setCornerRadius(this.radius);
        }
    }

    private final void styleContainerForExpandedState() {
        float[] fArray;
        Object object;
        if (this.getLayoutDirection() == 0) {
            object = new float[]{0.0f, 0.0f, this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f};
            fArray = object;
        } else {
            object = new float[]{this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f, this.radius, this.radius};
            fArray = object;
        }
        float[] cornerArray = fArray;
        this.getTitle().setAlpha(0.0f);
        this.getTitle().setVisibility(0);
        this.getTitle().animate().alpha(1.0f).setStartDelay(200L).start();
        this.getCountLabel().setVisibility(0);
        object = this.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container");
        ViewGroupKt.updateLayoutParams((View)object, styleContainerForExpandedState.1.INSTANCE);
        object = (Object)this.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"icon");
        ViewGroupKt.updateLayoutParams((View)object, (Function1)new Function1<ViewGroup.MarginLayoutParams, Unit>(this){
            final /* synthetic */ VerticalMenuItemView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ViewGroup.MarginLayoutParams $this$updateLayoutParams) {
                Intrinsics.checkNotNullParameter((Object)$this$updateLayoutParams, (String)"$this$updateLayoutParams");
                $this$updateLayoutParams.setMarginStart(VerticalMenuItemView.access$getDoubleSpace$p(this.this$0));
                $this$updateLayoutParams.setMarginEnd(VerticalMenuItemView.access$getDoubleSpace$p(this.this$0));
            }
        });
        this.containerForeground.setCornerRadii(cornerArray);
        if (this.isSelected()) {
            this.cornerAnimation(this.containerBackground, this.radius, 0.0f).start();
        } else {
            this.containerBackground.setCornerRadii(cornerArray);
        }
    }

    private final Animator cornerAnimation(GradientDrawable $this$cornerAnimation, float from, float to) {
        Object object = new float[]{from, to};
        Object $this$cornerAnimation_u24lambda_u2d2 = object = (Object)ObjectAnimator.ofFloat((float[])object);
        boolean bl = false;
        $this$cornerAnimation_u24lambda_u2d2.addUpdateListener(arg_0 -> VerticalMenuItemView.cornerAnimation$lambda-2$lambda-1($this$cornerAnimation, this, arg_0));
        $this$cornerAnimation_u24lambda_u2d2.setDuration(250L);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ofFloat(from, to).apply \u2026MATION_DURATION\n        }");
        return (Animator)object2;
    }

    @JvmOverloads
    public VerticalMenuItemView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void cornerAnimation$lambda-2$lambda-1(GradientDrawable $this_cornerAnimation, VerticalMenuItemView this$0, ValueAnimator it) {
        float[] fArray;
        float[] fArray2;
        Intrinsics.checkNotNullParameter((Object)$this_cornerAnimation, (String)"$this_cornerAnimation");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = it.getAnimatedValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        float corner = ((Float)object).floatValue();
        if ($this_cornerAnimation.getLayoutDirection() == 0) {
            fArray2 = new float[]{corner, corner, this$0.radius, this$0.radius, this$0.radius, this$0.radius, corner, corner};
            fArray = fArray2;
        } else {
            fArray2 = new float[]{this$0.radius, this$0.radius, corner, corner, corner, corner, this$0.radius, this$0.radius};
            fArray = fArray2;
        }
        float[] cornerArray = fArray;
        $this_cornerAnimation.setCornerRadii(cornerArray);
    }

    public static final /* synthetic */ int access$getDoubleSpace$p(VerticalMenuItemView $this) {
        return $this.doubleSpace;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ismaeldivita/chipnavigation/view/VerticalMenuItemView$Companion;", "", "()V", "BACKGROUND_CORNER_ANIMATION_DURATION", "", "BULLET", "", "chip-navigation-bar_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

