/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.library.truetime;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.SystemClock;
import com.instacart.library.truetime.SntpClient;
import com.instacart.library.truetime.TrueLog;

class DiskCacheClient {
    private static final String KEY_CACHED_SHARED_PREFS = "com.instacart.library.truetime.shared_preferences";
    private static final String KEY_CACHED_BOOT_TIME = "com.instacart.library.truetime.cached_boot_time";
    private static final String KEY_CACHED_DEVICE_UPTIME = "com.instacart.library.truetime.cached_device_uptime";
    private static final String KEY_CACHED_SNTP_TIME = "com.instacart.library.truetime.cached_sntp_time";
    private static final String TAG = DiskCacheClient.class.getSimpleName();
    private SharedPreferences _sharedPreferences = null;

    DiskCacheClient() {
    }

    void enableDiskCaching(Context context) {
        this._sharedPreferences = context.getSharedPreferences(KEY_CACHED_SHARED_PREFS, 0);
    }

    void clearCachedInfo(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(KEY_CACHED_SHARED_PREFS, 0);
        if (sharedPreferences == null) {
            return;
        }
        sharedPreferences.edit().clear().apply();
    }

    void cacheTrueTimeInfo(SntpClient sntpClient) {
        if (this.sharedPreferencesUnavailable()) {
            return;
        }
        long cachedSntpTime = sntpClient.getCachedSntpTime();
        long cachedDeviceUptime = sntpClient.getCachedDeviceUptime();
        long bootTime = cachedSntpTime - cachedDeviceUptime;
        TrueLog.d(TAG, String.format("Caching true time info to disk sntp [%s] device [%s] boot [%s]", cachedSntpTime, cachedDeviceUptime, bootTime));
        this._sharedPreferences.edit().putLong(KEY_CACHED_BOOT_TIME, bootTime).apply();
        this._sharedPreferences.edit().putLong(KEY_CACHED_DEVICE_UPTIME, cachedDeviceUptime).apply();
        this._sharedPreferences.edit().putLong(KEY_CACHED_SNTP_TIME, cachedSntpTime).apply();
    }

    boolean isTrueTimeCachedFromAPreviousBoot() {
        if (this.sharedPreferencesUnavailable()) {
            return false;
        }
        long cachedBootTime = this._sharedPreferences.getLong(KEY_CACHED_BOOT_TIME, 0L);
        if (cachedBootTime == 0L) {
            return false;
        }
        boolean bootTimeChanged = SystemClock.elapsedRealtime() < this.getCachedDeviceUptime();
        TrueLog.i(TAG, "---- boot time changed " + bootTimeChanged);
        return !bootTimeChanged;
    }

    long getCachedDeviceUptime() {
        if (this.sharedPreferencesUnavailable()) {
            return 0L;
        }
        return this._sharedPreferences.getLong(KEY_CACHED_DEVICE_UPTIME, 0L);
    }

    long getCachedSntpTime() {
        if (this.sharedPreferencesUnavailable()) {
            return 0L;
        }
        return this._sharedPreferences.getLong(KEY_CACHED_SNTP_TIME, 0L);
    }

    private boolean sharedPreferencesUnavailable() {
        if (this._sharedPreferences == null) {
            TrueLog.w(TAG, "Cannot use disk caching strategy for TrueTime. SharedPreferences unavailable");
            return true;
        }
        return false;
    }
}

