/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.library.truetime;

import android.content.Context;
import com.instacart.library.truetime.SntpClient;
import com.instacart.library.truetime.TrueLog;
import com.instacart.library.truetime.TrueTime;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.FlowableTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.reactivestreams.Publisher;

public class TrueTimeRx
extends TrueTime {
    private static final TrueTimeRx RX_INSTANCE = new TrueTimeRx();
    private static final String TAG = TrueTimeRx.class.getSimpleName();
    private int _retryCount = 50;

    public static TrueTimeRx build() {
        return RX_INSTANCE;
    }

    public TrueTimeRx withSharedPreferences(Context context) {
        super.withSharedPreferences(context);
        return this;
    }

    public TrueTimeRx withConnectionTimeout(int timeout) {
        super.withConnectionTimeout(timeout);
        return this;
    }

    public TrueTimeRx withRootDelayMax(float rootDelay) {
        super.withRootDelayMax(rootDelay);
        return this;
    }

    public TrueTimeRx withRootDispersionMax(float rootDispersion) {
        super.withRootDispersionMax(rootDispersion);
        return this;
    }

    public TrueTimeRx withServerResponseDelayMax(int serverResponseDelayInMillis) {
        super.withServerResponseDelayMax(serverResponseDelayInMillis);
        return this;
    }

    public TrueTimeRx withLoggingEnabled(boolean isLoggingEnabled) {
        super.withLoggingEnabled(isLoggingEnabled);
        return this;
    }

    public TrueTimeRx withRetryCount(int retryCount) {
        this._retryCount = retryCount;
        return this;
    }

    public Flowable<Date> initializeRx(String ntpPoolAddress) {
        return this.initializeNtp(ntpPoolAddress).map((Function)new Function<long[], Date>(){

            public Date apply(long[] longs) throws Exception {
                return TrueTime.now();
            }
        });
    }

    public Flowable<long[]> initializeNtp(String ntpPool) {
        return Flowable.just((Object)ntpPool).compose(this.resolveNtpPoolToIpAddresses()).compose(this.performNtpAlgorithm());
    }

    public Flowable<long[]> initializeNtp(List<InetAddress> resolvedNtpAddresses) {
        return Flowable.fromIterable(resolvedNtpAddresses).compose(this.performNtpAlgorithm());
    }

    private FlowableTransformer<InetAddress, long[]> performNtpAlgorithm() {
        return new FlowableTransformer<InetAddress, long[]>(){

            public Flowable<long[]> apply(Flowable<InetAddress> inetAddressObservable) {
                return inetAddressObservable.map((Function)new Function<InetAddress, String>(){

                    public String apply(InetAddress inetAddress) {
                        return inetAddress.getHostAddress();
                    }
                }).flatMap(TrueTimeRx.this.bestResponseAgainstSingleIp(5)).take(5L).toList().toFlowable().filter((Predicate)new Predicate<List<long[]>>(){

                    public boolean test(List<long[]> longs) throws Exception {
                        return longs.size() > 0;
                    }
                }).map(TrueTimeRx.this.filterMedianResponse()).doOnNext((Consumer)new Consumer<long[]>(){

                    public void accept(long[] ntpResponse) {
                        TrueTimeRx.this.cacheTrueTimeInfo(ntpResponse);
                        TrueTime.saveTrueTimeInfoToDisk();
                    }
                });
            }
        };
    }

    private FlowableTransformer<String, InetAddress> resolveNtpPoolToIpAddresses() {
        return new FlowableTransformer<String, InetAddress>(){

            public Publisher<InetAddress> apply(Flowable<String> ntpPoolFlowable) {
                return ntpPoolFlowable.observeOn(Schedulers.io()).flatMap((Function)new Function<String, Flowable<InetAddress>>(){

                    public Flowable<InetAddress> apply(String ntpPoolAddress) {
                        try {
                            TrueLog.d((String)TAG, (String)("---- resolving ntpHost : " + ntpPoolAddress));
                            return Flowable.fromArray((Object[])InetAddress.getAllByName(ntpPoolAddress));
                        }
                        catch (UnknownHostException e) {
                            return Flowable.error((Throwable)e);
                        }
                    }
                });
            }
        };
    }

    private Function<String, Flowable<long[]>> bestResponseAgainstSingleIp(final int repeatCount) {
        return new Function<String, Flowable<long[]>>(){

            public Flowable<long[]> apply(String singleIp) {
                return Flowable.just((Object)singleIp).repeat((long)repeatCount).flatMap((Function)new Function<String, Flowable<long[]>>(){

                    public Flowable<long[]> apply(final String singleIpHostAddress) {
                        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<long[]>(){

                            public void subscribe(@NonNull FlowableEmitter<long[]> o) throws Exception {
                                block2: {
                                    TrueLog.d((String)TAG, (String)("---- requestTime from: " + singleIpHostAddress));
                                    try {
                                        o.onNext((Object)TrueTimeRx.this.requestTime(singleIpHostAddress));
                                        o.onComplete();
                                    }
                                    catch (IOException e) {
                                        if (o.isCancelled()) break block2;
                                        o.onError((Throwable)e);
                                    }
                                }
                            }
                        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).subscribeOn(Schedulers.io()).doOnError((Consumer)new Consumer<Throwable>(){

                            public void accept(Throwable throwable) {
                                TrueLog.e((String)TAG, (String)"---- Error requesting time", (Throwable)throwable);
                            }
                        }).retry((long)TrueTimeRx.this._retryCount);
                    }
                }).toList().toFlowable().map(TrueTimeRx.this.filterLeastRoundTripDelay());
            }
        };
    }

    private Function<List<long[]>, long[]> filterLeastRoundTripDelay() {
        return new Function<List<long[]>, long[]>(){

            public long[] apply(List<long[]> responseTimeList) {
                Collections.sort(responseTimeList, new Comparator<long[]>(){

                    @Override
                    public int compare(long[] lhsParam, long[] rhsLongParam) {
                        long rhs;
                        long lhs = SntpClient.getRoundTripDelay((long[])lhsParam);
                        return lhs < (rhs = SntpClient.getRoundTripDelay((long[])rhsLongParam)) ? -1 : (lhs == rhs ? 0 : 1);
                    }
                });
                TrueLog.d((String)TAG, (String)("---- filterLeastRoundTrip: " + responseTimeList));
                return responseTimeList.get(0);
            }
        };
    }

    private Function<List<long[]>, long[]> filterMedianResponse() {
        return new Function<List<long[]>, long[]>(){

            public long[] apply(List<long[]> bestResponses) {
                Collections.sort(bestResponses, new Comparator<long[]>(){

                    @Override
                    public int compare(long[] lhsParam, long[] rhsParam) {
                        long rhs;
                        long lhs = SntpClient.getClockOffset((long[])lhsParam);
                        return lhs < (rhs = SntpClient.getClockOffset((long[])rhsParam)) ? -1 : (lhs == rhs ? 0 : 1);
                    }
                });
                TrueLog.d((String)TAG, (String)("---- bestResponse: " + Arrays.toString(bestResponses.get(bestResponses.size() / 2))));
                return bestResponses.get(bestResponses.size() / 2);
            }
        };
    }
}

