/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer.widgets.video;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.TextureView;
import com.github.iielse.imageviewer.utils.Config;
import com.github.iielse.imageviewer.widgets.video.ExoVideoView;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.util.EventLogger;
import com.google.android.exoplayer2.video.VideoSize;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e*\u0001$\b\u0016\u0018\u0000 A2\u00020\u0001:\u0003ABCB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012J\u0018\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0018\u0010.\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0018\u0010/\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020)H\u0014J\u0006\u00103\u001a\u00020)J\u0014\u00104\u001a\u0004\u0018\u0001012\n\b\u0002\u00105\u001a\u0004\u0018\u000106J\u000e\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020\u001aJ\u0006\u00109\u001a\u00020)J\u0006\u0010:\u001a\u00020)J\u0012\u0010;\u001a\u00020)2\n\b\u0002\u00105\u001a\u0004\u0018\u000106J\u000e\u0010<\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010=\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u0007J\u0010\u0010>\u001a\u00020)2\b\u0010?\u001a\u0004\u0018\u00010'J\u0018\u0010@\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView;", "Landroid/view/TextureView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "ar", "", "autoRelease", "getAutoRelease", "()Z", "exoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "listeners", "", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener;", "logger", "Lcom/google/android/exoplayer2/util/EventLogger;", "getLogger", "()Lcom/google/android/exoplayer2/util/EventLogger;", "logger$delegate", "Lkotlin/Lazy;", "playUrl", "", "prepared", "getPrepared", "setPrepared", "(Z)V", "scaleType", "getScaleType", "()I", "st", "videoListener", "com/github/iielse/imageviewer/widgets/video/ExoVideoView$videoListener$1", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$videoListener$1;", "videoRenderedCallback", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$VideoRenderedListener;", "addAnalyticsListener", "", "analyticsListener", "centerCrop", "videoWidth", "videoHeight", "fitCenter", "fitXY", "newExoPlayer", "Lcom/google/android/exoplayer2/ExoPlayer;", "onDetachedFromWindow", "pause", "player", "provider", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$MediaItemProvider;", "prepare", "url", "release", "reset", "resume", "setAutoRelease", "setScaleType", "setVideoRenderedCallback", "listener", "updateTextureViewSize", "Companion", "MediaItemProvider", "VideoRenderedListener", "imageviewer_release"})
public class ExoVideoView
extends TextureView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy logger$delegate;
    @Nullable
    private SimpleExoPlayer exoPlayer;
    @Nullable
    private VideoRenderedListener videoRenderedCallback;
    @NotNull
    private final List<AnalyticsListener> listeners;
    @Nullable
    private String playUrl;
    private boolean prepared;
    private int st;
    private boolean ar;
    @NotNull
    private final videoListener.1 videoListener;
    public static final int SCALE_TYPE_FIT_XY = 0;
    public static final int SCALE_TYPE_FIT_CENTER = 1;
    public static final int SCALE_TYPE_CENTER_CROP = 2;

    @JvmOverloads
    public ExoVideoView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        boolean bl = false;
        this.listeners = new ArrayList();
        this.st = Config.INSTANCE.getVIDEO_SCALE_TYPE();
        this.ar = true;
        this.videoListener = new Player.Listener(this){
            final /* synthetic */ ExoVideoView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVideoSizeChanged(@NotNull VideoSize videoSize) {
                Intrinsics.checkNotNullParameter((Object)videoSize, (String)"videoSize");
                ExoVideoView.access$updateTextureViewSize(this.this$0, videoSize.width, videoSize.height);
            }
        };
    }

    public /* synthetic */ ExoVideoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final EventLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        boolean bl = false;
        return (EventLogger)lazy.getValue();
    }

    protected final boolean getPrepared() {
        return this.prepared;
    }

    protected final void setPrepared(boolean bl) {
        this.prepared = bl;
    }

    public final int getScaleType() {
        return this.st;
    }

    public final boolean getAutoRelease() {
        return this.ar;
    }

    public final void prepare(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.playUrl = url;
    }

    public final void resume(@Nullable MediaItemProvider provider) {
        String string = this.playUrl;
        if (string == null) {
            return;
        }
        String url = string;
        if (this.exoPlayer == null) {
            this.prepared = false;
            this.setAlpha(0.0f);
            this.newExoPlayer();
            string = this.exoPlayer;
            if (string != null) {
                MediaItemProvider mediaItemProvider = provider;
                List list2 = mediaItemProvider == null ? null : mediaItemProvider.provide(url);
                string.setMediaItems(list2 == null ? CollectionsKt.listOf((Object)MediaItem.fromUri((String)url)) : list2);
            }
            if ((string = this.exoPlayer) != null) {
                string.prepare();
            }
        }
        if ((string = this.exoPlayer) != null) {
            string.setPlayWhenReady(true);
        }
    }

    public static /* synthetic */ void resume$default(ExoVideoView exoVideoView, MediaItemProvider mediaItemProvider, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resume");
        }
        if ((n & 1) != 0) {
            mediaItemProvider = null;
        }
        exoVideoView.resume(mediaItemProvider);
    }

    public final void pause() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.setPlayWhenReady(false);
        }
    }

    public final void reset() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.seekTo(0L);
        }
        simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.setPlayWhenReady(false);
        }
    }

    public final void release() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) {
            return;
        }
        SimpleExoPlayer player = simpleExoPlayer;
        player.setPlayWhenReady(false);
        player.setVideoTextureView(null);
        player.removeListener((Player.Listener)this.videoListener);
        player.removeAnalyticsListener((AnalyticsListener)this.getLogger());
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnalyticsListener it = (AnalyticsListener)element$iv;
            boolean bl = false;
            player.removeAnalyticsListener(it);
        }
        player.release();
        this.exoPlayer = null;
    }

    public final void setScaleType(int scaleType) {
        this.st = scaleType;
    }

    public final void setAutoRelease(boolean autoRelease) {
        this.ar = autoRelease;
    }

    public final void setVideoRenderedCallback(@Nullable VideoRenderedListener listener) {
        this.videoRenderedCallback = listener;
    }

    public final void addAnalyticsListener(@NotNull AnalyticsListener analyticsListener) {
        Intrinsics.checkNotNullParameter((Object)analyticsListener, (String)"analyticsListener");
        if (!this.listeners.contains(analyticsListener)) {
            this.listeners.add(analyticsListener);
        }
    }

    @Nullable
    public final ExoPlayer player(@Nullable MediaItemProvider provider) {
        String string = this.playUrl;
        if (string == null) {
            return null;
        }
        String url = string;
        if (this.exoPlayer == null) {
            this.prepared = false;
            this.setAlpha(0.0f);
            this.newExoPlayer();
            string = this.exoPlayer;
            if (string != null) {
                MediaItemProvider mediaItemProvider = provider;
                List list2 = mediaItemProvider == null ? null : mediaItemProvider.provide(url);
                string.setMediaItems(list2 == null ? CollectionsKt.listOf((Object)MediaItem.fromUri((String)url)) : list2);
            }
            if ((string = this.exoPlayer) != null) {
                string.prepare();
            }
        }
        return (ExoPlayer)this.exoPlayer;
    }

    public static /* synthetic */ ExoPlayer player$default(ExoVideoView exoVideoView, MediaItemProvider mediaItemProvider, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: player");
        }
        if ((n & 1) != 0) {
            mediaItemProvider = null;
        }
        return exoVideoView.player(mediaItemProvider);
    }

    private final ExoPlayer newExoPlayer() {
        this.release();
        SimpleExoPlayer simpleExoPlayer = new SimpleExoPlayer.Builder(this.getContext()).build();
        boolean bl = false;
        boolean bl2 = false;
        SimpleExoPlayer it = simpleExoPlayer;
        boolean bl3 = false;
        it.setVideoTextureView((TextureView)this);
        it.addListener((Player.Listener)this.videoListener);
        if (Config.INSTANCE.getDEBUG()) {
            it.addAnalyticsListener((AnalyticsListener)this.getLogger());
        }
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnalyticsListener userListener = (AnalyticsListener)element$iv;
            boolean bl4 = false;
            it.addAnalyticsListener(userListener);
        }
        this.exoPlayer = it;
        SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)simpleExoPlayer2, (String)"Builder(context).build().also {\n            it.setVideoTextureView(this)\n            it.addListener(videoListener)\n            if (Config.DEBUG) it.addAnalyticsListener(logger)\n            listeners.toList().forEach { userListener -> it.addAnalyticsListener(userListener) }\n            exoPlayer = it\n        }");
        return (ExoPlayer)simpleExoPlayer2;
    }

    private final void updateTextureViewSize(int videoWidth, int videoHeight) {
        int n = this.st;
        switch (n) {
            case 1: {
                this.fitCenter(videoWidth, videoHeight);
                break;
            }
            case 2: {
                this.centerCrop(videoWidth, videoHeight);
                break;
            }
            case 0: {
                this.fitXY(videoWidth, videoHeight);
            }
        }
        this.invalidate();
        this.setAlpha(1.0f);
        VideoRenderedListener videoRenderedListener = this.videoRenderedCallback;
        if (videoRenderedListener != null) {
            videoRenderedListener.onRendered(this);
        }
        this.prepared = true;
    }

    private final void fitCenter(int videoWidth, int videoHeight) {
        float sx = (float)this.getWidth() * 1.0f / (float)videoWidth;
        float sy = (float)this.getHeight() * 1.0f / (float)videoHeight;
        Matrix matrix = new Matrix();
        matrix.postScale((float)videoWidth * 1.0f / (float)this.getWidth(), (float)videoHeight * 1.0f / (float)this.getHeight());
        boolean bl = false;
        bl = false;
        matrix.postScale(Math.min(sx, sy), Math.min(sx, sy));
        matrix.postTranslate(sx > sy ? ((float)this.getWidth() - (float)videoWidth * sy) / (float)2 : 0.0f, sx > sy ? 0.0f : ((float)this.getHeight() - (float)videoHeight * sx) / (float)2);
        this.setTransform(matrix);
    }

    private final void centerCrop(int videoWidth, int videoHeight) {
        float sx = (float)this.getWidth() * 1.0f / (float)videoWidth;
        float sy = (float)this.getHeight() * 1.0f / (float)videoHeight;
        Matrix matrix = new Matrix();
        matrix.postScale((float)videoWidth * 1.0f / (float)this.getWidth(), (float)videoHeight * 1.0f / (float)this.getHeight());
        boolean bl = false;
        bl = false;
        matrix.postScale(Math.max(sx, sy), Math.max(sx, sy));
        matrix.postTranslate(sx < sy ? ((float)this.getWidth() - (float)videoWidth * sy) / (float)2 : 0.0f, sx < sy ? 0.0f : ((float)this.getHeight() - (float)videoHeight * sx) / (float)2);
        this.setTransform(matrix);
    }

    private final void fitXY(int videoWidth, int videoHeight) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.getAutoRelease()) {
            this.release();
        }
    }

    @JvmOverloads
    public ExoVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExoVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateTextureViewSize(ExoVideoView $this, int videoWidth, int videoHeight) {
        $this.updateTextureViewSize(videoWidth, videoHeight);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$VideoRenderedListener;", "", "onRendered", "", "view", "Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView;", "imageviewer_release"})
    public static interface VideoRenderedListener {
        public void onRendered(@NotNull ExoVideoView var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$MediaItemProvider;", "", "provide", "", "Lcom/google/android/exoplayer2/MediaItem;", "playUrl", "", "imageviewer_release"})
    public static interface MediaItemProvider {
        @Nullable
        public List<MediaItem> provide(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/iielse/imageviewer/widgets/video/ExoVideoView$Companion;", "", "()V", "SCALE_TYPE_CENTER_CROP", "", "SCALE_TYPE_FIT_CENTER", "SCALE_TYPE_FIT_XY", "imageviewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

