/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer.core;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.iielse.imageviewer.core.DataProvider;
import com.github.iielse.imageviewer.core.ImageLoader;
import com.github.iielse.imageviewer.core.OverlayCustomizer;
import com.github.iielse.imageviewer.core.Photo;
import com.github.iielse.imageviewer.core.Transformer;
import com.github.iielse.imageviewer.core.VHCustomizer;
import com.github.iielse.imageviewer.core.ViewerCallback;
import com.github.iielse.imageviewer.widgets.video.ExoVideoView2;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0010J\u0010\u0010\u001c\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u001d\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001e\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/github/iielse/imageviewer/core/Components;", "", "()V", "dataProvider", "Lcom/github/iielse/imageviewer/core/DataProvider;", "imageLoader", "Lcom/github/iielse/imageviewer/core/ImageLoader;", "initialize", "", "overlayCustomizer", "Lcom/github/iielse/imageviewer/core/OverlayCustomizer;", "transformer", "Lcom/github/iielse/imageviewer/core/Transformer;", "vhCustomizer", "Lcom/github/iielse/imageviewer/core/VHCustomizer;", "viewerCallback", "Lcom/github/iielse/imageviewer/core/ViewerCallback;", "working", "getWorking", "()Z", "", "release", "requireDataProvider", "requireImageLoader", "requireOverlayCustomizer", "requireTransformer", "requireVHCustomizer", "requireViewerCallback", "setOverlayCustomizer", "setVHCustomizer", "setViewerCallback", "imageviewer_release"})
public final class Components {
    @NotNull
    public static final Components INSTANCE = new Components();
    private static boolean initialize;
    @Nullable
    private static ImageLoader imageLoader;
    @Nullable
    private static DataProvider dataProvider;
    @Nullable
    private static Transformer transformer;
    @Nullable
    private static VHCustomizer vhCustomizer;
    @Nullable
    private static OverlayCustomizer overlayCustomizer;
    @Nullable
    private static ViewerCallback viewerCallback;

    private Components() {
    }

    public final boolean getWorking() {
        return initialize;
    }

    public final void initialize(@NotNull ImageLoader imageLoader, @NotNull DataProvider dataProvider2, @NotNull Transformer transformer2) {
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkNotNullParameter((Object)dataProvider2, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
        if (initialize) {
            throw new IllegalStateException();
        }
        Components.imageLoader = imageLoader;
        dataProvider = dataProvider2;
        transformer = transformer2;
        initialize = true;
    }

    public final void setVHCustomizer(@Nullable VHCustomizer vhCustomizer) {
        Components.vhCustomizer = vhCustomizer;
    }

    public final void setViewerCallback(@Nullable ViewerCallback viewerCallback) {
        Components.viewerCallback = viewerCallback;
    }

    public final void setOverlayCustomizer(@Nullable OverlayCustomizer overlayCustomizer) {
        Components.overlayCustomizer = overlayCustomizer;
    }

    @NotNull
    public final ImageLoader requireImageLoader() {
        ImageLoader imageLoader = Components.imageLoader;
        return imageLoader == null ? (ImageLoader)new ImageLoader(){

            public void load(@NotNull ExoVideoView2 exoVideoView, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                ImageLoader.DefaultImpls.load((ImageLoader)this, exoVideoView, data, viewHolder);
            }

            public void load(@NotNull SubsamplingScaleImageView subsamplingView, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                ImageLoader.DefaultImpls.load((ImageLoader)this, subsamplingView, data, viewHolder);
            }

            public void load(@NotNull ImageView view, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                ImageLoader.DefaultImpls.load((ImageLoader)this, view, data, viewHolder);
            }
        } : imageLoader;
    }

    @NotNull
    public final DataProvider requireDataProvider() {
        DataProvider dataProvider2 = dataProvider;
        return dataProvider2 == null ? (DataProvider)new DataProvider(){

            public void exclude(@NotNull List<? extends Photo> exclude, @NotNull Photo target) {
                DataProvider.DefaultImpls.exclude(this, exclude, target);
            }

            public void loadAfter(long key, @NotNull Function1<? super List<? extends Photo>, Unit> callback2) {
                DataProvider.DefaultImpls.loadAfter(this, key, callback2);
            }

            public void loadBefore(long key, @NotNull Function1<? super List<? extends Photo>, Unit> callback2) {
                DataProvider.DefaultImpls.loadBefore(this, key, callback2);
            }

            @NotNull
            public List<Photo> loadInitial() {
                return DataProvider.DefaultImpls.loadInitial(this);
            }
        } : dataProvider2;
    }

    @NotNull
    public final Transformer requireTransformer() {
        Transformer transformer2 = transformer;
        return transformer2 == null ? (Transformer)new Transformer(){

            @Nullable
            public ImageView getView(long key) {
                return Transformer.DefaultImpls.getView(this, key);
            }
        } : transformer2;
    }

    @NotNull
    public final VHCustomizer requireVHCustomizer() {
        VHCustomizer vHCustomizer = vhCustomizer;
        return vHCustomizer == null ? (VHCustomizer)new VHCustomizer(){

            public void bind(int type, @NotNull Photo data, @NotNull RecyclerView.ViewHolder viewHolder) {
                VHCustomizer.DefaultImpls.bind(this, type, data, viewHolder);
            }

            public void initialize(int type, @NotNull RecyclerView.ViewHolder viewHolder) {
                VHCustomizer.DefaultImpls.initialize(this, type, viewHolder);
            }
        } : vHCustomizer;
    }

    @NotNull
    public final ViewerCallback requireViewerCallback() {
        ViewerCallback viewerCallback = Components.viewerCallback;
        return viewerCallback == null ? (ViewerCallback)new ViewerCallback(){

            public void onDrag(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull View view, float fraction) {
                ViewerCallback.DefaultImpls.onDrag(this, viewHolder, view, fraction);
            }

            public void onInit(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
                ViewerCallback.DefaultImpls.onInit(this, viewHolder, position);
            }

            public void onPageScrollStateChanged(int state) {
                ViewerCallback.DefaultImpls.onPageScrollStateChanged(this, state);
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                ViewerCallback.DefaultImpls.onPageScrolled(this, position, positionOffset, positionOffsetPixels);
            }

            public void onPageSelected(int position, @NotNull RecyclerView.ViewHolder viewHolder) {
                ViewerCallback.DefaultImpls.onPageSelected(this, position, viewHolder);
            }

            public void onRelease(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull View view) {
                ViewerCallback.DefaultImpls.onRelease(this, viewHolder, view);
            }

            public void onRestore(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull View view, float fraction) {
                ViewerCallback.DefaultImpls.onRestore(this, viewHolder, view, fraction);
            }
        } : viewerCallback;
    }

    @NotNull
    public final OverlayCustomizer requireOverlayCustomizer() {
        OverlayCustomizer overlayCustomizer = Components.overlayCustomizer;
        return overlayCustomizer == null ? (OverlayCustomizer)new OverlayCustomizer(){

            @Nullable
            public View provideView(@NotNull ViewGroup parent) {
                return OverlayCustomizer.DefaultImpls.provideView(this, parent);
            }
        } : overlayCustomizer;
    }

    public final void release() {
        initialize = false;
        imageLoader = null;
        dataProvider = null;
        transformer = null;
        vhCustomizer = null;
        viewerCallback = null;
        overlayCustomizer = null;
    }
}

