/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.I;
import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.LogSink;
import com.ihsanbal.logging.Logger;
import com.ihsanbal.logging.LoggingInterceptor;
import com.ihsanbal.logging.PrinterKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/ihsanbal/logging/Printer;", "", "<init>", "()V", "Companion", "lib"})
public final class Printer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int JSON_INDENT = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @NotNull
    private static final String DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
    @NotNull
    private static final String N = "\n";
    @NotNull
    private static final String T = "\t";
    @NotNull
    private static final String REQUEST_UP_LINE = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    @NotNull
    private static final String END_LINE = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    @NotNull
    private static final String RESPONSE_UP_LINE = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    @NotNull
    private static final String BODY_TAG = "Body:";
    @NotNull
    private static final String URL_TAG = "URL: ";
    @NotNull
    private static final String METHOD_TAG = "Method: @";
    @NotNull
    private static final String HEADERS_TAG = "Headers:";
    @NotNull
    private static final String STATUS_LINE_TAG = "Status Code: ";
    @NotNull
    private static final String RECEIVED_TAG = "Received in: ";
    @NotNull
    private static final String DEFAULT_LINE = "\u2502 ";
    @NotNull
    private static final String OOM_OMITTED = LINE_SEPARATOR + "Output omitted because of Object size.";

    private Printer() {
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007JT\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070-2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0007J\u0010\u00100\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+H\u0002J+\u00101\u001a\b\u0012\u0004\u0012\u00020\u0007022\u0006\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u00105J+\u00106\u001a\b\u0012\u0004\u0012\u00020\u0007022\u0006\u00107\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u00108J \u00109\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0016\u0010;\u001a\u00020\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070-H\u0002J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\"H\u0002JQ\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00072\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u0007022\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020\u00182\u0006\u0010C\u001a\u00020\u00182\n\b\u0002\u0010D\u001a\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010FJ\u001a\u0010G\u001a\u00020\u00072\b\u0010H\u001a\u0004\u0018\u00010\u001f2\u0006\u0010)\u001a\u00020\"H\u0002J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\"H\u0002J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0002J(\u0010L\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00072\b\u0010M\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/ihsanbal/logging/Printer$Companion;", "", "<init>", "()V", "JSON_INDENT", "", "LINE_SEPARATOR", "", "kotlin.jvm.PlatformType", "DOUBLE_SEPARATOR", "N", "T", "REQUEST_UP_LINE", "END_LINE", "RESPONSE_UP_LINE", "BODY_TAG", "URL_TAG", "METHOD_TAG", "HEADERS_TAG", "STATUS_LINE_TAG", "RECEIVED_TAG", "DEFAULT_LINE", "OOM_OMITTED", "isEmpty", "", "line", "printJsonRequest", "", "builder", "Lcom/ihsanbal/logging/LoggingInterceptor$Builder;", "body", "Lokhttp3/RequestBody;", "url", "header", "Lokhttp3/Headers;", "method", "printJsonResponse", "chainMs", "", "isSuccessful", "code", "headers", "response", "Lokhttp3/Response;", "segments", "", "message", "responseUrl", "getResponseBody", "getRequest", "", "level", "Lcom/ihsanbal/logging/Level;", "(Lcom/ihsanbal/logging/Level;Lokhttp3/Headers;Ljava/lang/String;)[Ljava/lang/String;", "getStatusLine", "tookMs", "(JILjava/lang/String;)[Ljava/lang/String;", "emit", "tag", "slashSegments", "dotHeaders", "logLines", "type", "lines", "logger", "Lcom/ihsanbal/logging/Logger;", "withLineSize", "useLogHack", "sink", "Lcom/ihsanbal/logging/LogSink;", "(ILjava/lang/String;[Ljava/lang/String;Lcom/ihsanbal/logging/Logger;ZZLcom/ihsanbal/logging/LogSink;)V", "bodyToString", "requestBody", "bodyHasUnknownEncoding", "getJsonString", "msg", "printFailed", "reason", "lib"})
    @SourceDebugExtension(value={"SMAP\nPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Printer.kt\ncom/ihsanbal/logging/Printer$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n106#2:278\n78#2,22:279\n37#3,2:301\n37#3,2:303\n37#3,2:305\n1869#4,2:307\n*S KotlinDebug\n*F\n+ 1 Printer.kt\ncom/ihsanbal/logging/Printer$Companion\n*L\n39#1:278\n39#1:279,22\n52#1:301,2\n68#1:303,2\n122#1:305,2\n150#1:307,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmpty(String line) {
            if (((CharSequence)line).length() == 0) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            if (Intrinsics.areEqual((Object)Printer.N, (Object)line)) return true;
            if (Intrinsics.areEqual((Object)Printer.T, (Object)line)) return true;
            String $this$trim$iv = line;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() != 0) return false;
            return true;
        }

        public final void printJsonRequest(@NotNull LoggingInterceptor.Builder builder, @Nullable RequestBody body, @NotNull String url, @NotNull Headers header, @NotNull String method) {
            block6: {
                String[] it;
                Object object;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        object = body;
                        if (body == null) break block4;
                        it = object;
                        boolean bl = false;
                        String string = LINE_SEPARATOR + Printer.BODY_TAG + LINE_SEPARATOR + Companion.bodyToString((RequestBody)body, header);
                        object = string;
                        if (string != null) break block5;
                    }
                    object = "";
                }
                Object requestBody = object;
                String tag = builder.getTag(true);
                LogSink sink = builder.getSink();
                this.emit(builder, tag, Printer.REQUEST_UP_LINE);
                it = new String[]{Printer.URL_TAG + url};
                this.logLines(builder.getType(), tag, it, builder.getLogger(), false, builder.isLogHackEnable(), sink);
                this.logLines(builder.getType(), tag, this.getRequest(builder.getLevel(), header, method), builder.getLogger(), true, builder.isLogHackEnable(), sink);
                if (builder.getLevel() == Level.BASIC || builder.getLevel() == Level.BODY) {
                    int n = builder.getType();
                    CharSequence charSequence = (CharSequence)requestBody;
                    it = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)LINE_SEPARATOR, (String)"access$getLINE_SEPARATOR$cp(...)");
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])it, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    this.logLines(n, tag, thisCollection$iv.toArray(new String[0]), builder.getLogger(), true, builder.isLogHackEnable(), sink);
                }
                this.emit(builder, tag, Printer.END_LINE);
                LogSink logSink = sink;
                if (logSink == null) break block6;
                logSink.close(builder.getType(), tag);
            }
        }

        public final void printJsonResponse(@NotNull LoggingInterceptor.Builder builder, long chainMs, boolean isSuccessful, int code, @NotNull Headers headers, @NotNull Response response, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter(segments, (String)"segments");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)responseUrl, (String)"responseUrl");
                String responseBody = LINE_SEPARATOR + Printer.BODY_TAG + LINE_SEPARATOR + this.getResponseBody(response);
                String tag = builder.getTag(false);
                String[] statusLine = this.getStatusLine(chainMs, code, message);
                LogSink sink = builder.getSink();
                this.emit(builder, tag, Printer.RESPONSE_UP_LINE);
                String[] stringArray = new String[]{Printer.URL_TAG + responseUrl};
                this.logLines(builder.getType(), tag, stringArray, builder.getLogger(), false, builder.isLogHackEnable(), sink);
                this.logLines(builder.getType(), tag, statusLine, builder.getLogger(), true, builder.isLogHackEnable(), sink);
                if (builder.getLevel() == Level.BASIC || builder.getLevel() == Level.BODY) {
                    int n = builder.getType();
                    CharSequence charSequence = responseBody;
                    stringArray = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)LINE_SEPARATOR, (String)"access$getLINE_SEPARATOR$cp(...)");
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    this.logLines(n, tag, thisCollection$iv.toArray(new String[0]), builder.getLogger(), true, builder.isLogHackEnable(), sink);
                }
                this.emit(builder, tag, Printer.END_LINE);
                LogSink logSink = sink;
                if (logSink == null) break block1;
                logSink.close(builder.getType(), tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getResponseBody(Response response) {
            MediaType contentType;
            Object object;
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            ResponseBody responseBody2 = responseBody;
            Headers headers = response.headers();
            long contentLength = responseBody2.contentLength();
            if (!HttpHeaders.promisesBody((Response)response)) {
                return "End request - Promises Body";
            }
            if (this.bodyHasUnknownEncoding(response.headers())) {
                return "encoded body omitted";
            }
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = null;
            buffer = source.getBuffer();
            Long gzippedLength = null;
            if (StringsKt.equals((String)"gzip", (String)headers.get("Content-Encoding"), (boolean)true)) {
                gzippedLength = buffer.size();
                Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                Throwable throwable = null;
                try {
                    GzipSource gzippedResponseBody = (GzipSource)closeable;
                    boolean bl = false;
                    buffer = new Buffer();
                    long l = buffer.writeAll((Source)gzippedResponseBody);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if ((object = (contentType = responseBody2.contentType())) == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                Charset charset = StandardCharsets.UTF_8;
                object = charset;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            }
            Object charset = object;
            if (!PrinterKt.isProbablyUtf8(buffer)) {
                return "End request - binary " + buffer.size() + ":byte body omitted";
            }
            if (contentLength != 0L) {
                return this.getJsonString(buffer.clone().readString((Charset)charset));
            }
            return gzippedLength != null ? "End request - " + buffer.size() + ":byte, " + gzippedLength + "-gzipped-byte body" : "End request - " + buffer.size() + ":byte body";
        }

        private final String[] getRequest(Level level, Headers headers, String method) {
            String log = null;
            boolean loggableHeader = level == Level.HEADERS || level == Level.BASIC;
            log = Printer.METHOD_TAG + method + DOUBLE_SEPARATOR + (this.isEmpty(String.valueOf(headers)) ? "" : (loggableHeader ? Printer.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(headers) : ""));
            CharSequence charSequence = log;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)LINE_SEPARATOR, (String)"access$getLINE_SEPARATOR$cp(...)");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        private final String[] getStatusLine(long tookMs, int code, String message) {
            String status = Printer.STATUS_LINE_TAG + code + " / " + message + " (Received in: " + tookMs + " ms)";
            String[] stringArray = new String[]{status};
            return stringArray;
        }

        private final void emit(LoggingInterceptor.Builder builder, String tag, String line) {
            LogSink sink = builder.getSink();
            Logger logger = builder.getLogger();
            LogSink logSink = sink;
            if (logSink != null) {
                logSink.log(builder.getType(), tag, line);
            } else if (logger == null) {
                I.Companion.log$default(I.Companion, builder.getType(), tag, line, builder.isLogHackEnable(), null, 16, null);
            } else {
                logger.log(builder.getType(), tag, line);
            }
        }

        private final String slashSegments(List<String> segments) {
            StringBuilder segmentString = new StringBuilder();
            for (String segment : segments) {
                segmentString.append("/").append(segment);
            }
            String string = segmentString.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String dotHeaders(Headers headers) {
            StringBuilder builder = new StringBuilder();
            Iterable $this$forEach$iv = (Iterable)headers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                builder.append((String)pair.getFirst() + ": " + (String)pair.getSecond()).append(Printer.N);
            }
            return ((Object)StringsKt.dropLast((CharSequence)builder, (int)1)).toString();
        }

        private final void logLines(int type, String tag, String[] lines, Logger logger, boolean withLineSize, boolean useLogHack, LogSink sink) {
            int n = lines.length;
            block0: for (int i = 0; i < n; ++i) {
                int maxLogSize;
                int i2 = 0;
                String line = lines[i];
                int lineLength = line.length();
                int n2 = lineLength / (maxLogSize = withLineSize ? 110 : lineLength);
                if (i2 > n2) continue;
                while (true) {
                    int start = i2 * maxLogSize;
                    int end = (i2 + 1) * maxLogSize;
                    end = end > line.length() ? line.length() : end;
                    StringBuilder stringBuilder = new StringBuilder().append(Printer.DEFAULT_LINE);
                    String string = line.substring(start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String chunk = stringBuilder.append(string).toString();
                    LogSink logSink = sink;
                    if (logSink != null) {
                        logSink.log(type, tag, chunk);
                    } else if (logger == null) {
                        I.Companion.log$default(I.Companion, type, tag, chunk, useLogHack, null, 16, null);
                    } else {
                        logger.log(type, tag, chunk);
                    }
                    if (i2 == n2) continue block0;
                    ++i2;
                }
            }
        }

        static /* synthetic */ void logLines$default(Companion companion, int n, String string, String[] stringArray, Logger logger, boolean bl, boolean bl2, LogSink logSink, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                logSink = null;
            }
            companion.logLines(n, string, stringArray, logger, bl, bl2, logSink);
        }

        private final String bodyToString(RequestBody requestBody, Headers headers) {
            if (requestBody != null) {
                RequestBody it = requestBody;
                boolean bl = false;
                try {
                    if (Companion.bodyHasUnknownEncoding(headers)) {
                        return "encoded body omitted)";
                    }
                    if (requestBody.isDuplex()) {
                        return "duplex request body omitted";
                    }
                    if (requestBody.isOneShot()) {
                        return "one-shot body omitted";
                    }
                    Buffer buffer = new Buffer();
                    requestBody.writeTo((BufferedSink)buffer);
                    MediaType contentType = requestBody.contentType();
                    Object object = contentType;
                    if (object == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                        Charset charset = StandardCharsets.UTF_8;
                        object = charset;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    }
                    Object charset = object;
                    return PrinterKt.isProbablyUtf8(buffer) ? Companion.getJsonString(buffer.readString((Charset)charset)) + LINE_SEPARATOR + requestBody.contentLength() + "-byte body" : "binary " + requestBody.contentLength() + "-byte body omitted";
                }
                catch (IOException e) {
                    return "{\"err\": \"" + e.getMessage() + "\"}";
                }
            }
            return "";
        }

        private final boolean bodyHasUnknownEncoding(Headers headers) {
            String string = headers.get("Content-Encoding");
            if (string == null) {
                return false;
            }
            String contentEncoding = string;
            return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
        }

        private final String getJsonString(String msg) {
            String string;
            String message = null;
            try {
                String string2;
                if (StringsKt.startsWith$default((String)msg, (String)"{", (boolean)false, (int)2, null)) {
                    JSONObject jsonObject = new JSONObject(msg);
                    string2 = jsonObject.toString(3);
                } else if (StringsKt.startsWith$default((String)msg, (String)"[", (boolean)false, (int)2, null)) {
                    JSONArray jsonArray = new JSONArray(msg);
                    string2 = jsonArray.toString(3);
                } else {
                    string2 = msg;
                }
                string = string2;
                Intrinsics.checkNotNull((Object)string);
            }
            catch (JSONException e) {
                string = msg;
            }
            catch (OutOfMemoryError e1) {
                string = OOM_OMITTED;
            }
            message = string;
            return message;
        }

        public final void printFailed(@NotNull String tag, @NotNull LoggingInterceptor.Builder builder, @NotNull String responseUrl, @Nullable String reason) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)responseUrl, (String)"responseUrl");
                LogSink sink = builder.getSink();
                this.emit(builder, tag, Printer.RESPONSE_UP_LINE);
                String[] stringArray = new String[]{Printer.URL_TAG + responseUrl};
                this.logLines(builder.getType(), tag, stringArray, builder.getLogger(), false, builder.isLogHackEnable(), sink);
                String[] stringArray2 = (String[])reason;
                String failureLine = stringArray2 == null || StringsKt.isBlank((CharSequence)stringArray2) ? "Response failed" : "Response failed: " + reason;
                stringArray2 = new String[]{failureLine};
                this.logLines(builder.getType(), tag, stringArray2, builder.getLogger(), true, builder.isLogHackEnable(), sink);
                this.emit(builder, tag, Printer.END_LINE);
                LogSink logSink = sink;
                if (logSink == null) break block0;
                logSink.close(builder.getType(), tag);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

